/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.notificacoes.components;

import br.com.system.app.components.VerticalScrollLayout;
import br.com.system.app.features.notificacoes.components.NotificacoesResultList;
import br.com.system.app.features.notificacoes.model.Notificacoes;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.accordion.Accordion;
import com.vaadin.flow.component.accordion.AccordionPanel;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class NotificacoesResultList
extends VerticalScrollLayout {
    private static final long serialVersionUID = 1L;
    private Accordion accordion;
    private final List<Notificacoes> items = new ArrayList();
    private final List<ChangeStatusListener> listeners = new ArrayList();

    public NotificacoesResultList() {
        this.setWidthFull();
        this.setHeightFull();
        this.getStyle().set("padding", "10px");
    }

    public void setItems(List<Notificacoes> items) {
        this.items.clear();
        this.items.addAll(items);
        this.renderItens();
    }

    public void addChangeStatusListener(ChangeStatusListener listener) {
        this.listeners.add(listener);
    }

    private void renderItens() {
        this.removeAll();
        this.accordion = new Accordion();
        this.accordion.setWidthFull();
        this.accordion.setHeightFull();
        this.accordion.close();
        this.items.forEach(notificacao -> this.accordion.add(this.createPanelItem(notificacao)));
        this.add(new Component[]{this.accordion});
    }

    private AccordionPanel createPanelItem(Notificacoes item) {
        AccordionPanel panel = new AccordionPanel();
        Summary summary = this.createSummary(item);
        panel.setSummary((Component)summary);
        panel.setContent(this.createContent(item, summary));
        return panel;
    }

    private Summary createSummary(Notificacoes item) {
        return new Summary(item.getAssunto() + " " + item.getDataHora().format(FormatDate.DATETIME_BR.toDTF()), item.isLido());
    }

    private Component createContent(Notificacoes item, Summary summary) {
        Div container = new Div();
        container.getStyle().set("display", "flex");
        container.getStyle().set("flex-direction", "column");
        Span span = new Span();
        span.getElement().setProperty("innerHTML", item.getMensagem());
        span.getStyle().set("flex", "1");
        ToggleStatusButton toggleStatusButton = new ToggleStatusButton(item.isLido());
        toggleStatusButton.addClickListener((ComponentEventListener & Serializable)event -> this.notifyListeners(item, toggleStatusButton, summary));
        container.add(new Component[]{span, toggleStatusButton});
        return container;
    }

    private void notifyListeners(Notificacoes item, ToggleStatusButton button, Summary summary) {
        this.listeners.forEach(listener -> listener.onToggle(item, button, summary));
    }
}

