/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.notificacoes.service;

import br.com.system.app.features.email.service.SendMailService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.notificacoes.service.NotificacoesDiariasScreenService;
import br.com.system.app.features.notificacoes.service.NotificacoesLogService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoNotificacao;
import br.com.system.app.features.pedido.repository.PedidoNotificacaoRepository;
import br.com.system.app.features.pedido.repository.PedidoRepository;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.commons.HtmlUtil;
import br.com.system.commons.SleepUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NotificacaoDiariaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaService estruturaService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private PedidoRepository pr;
    @Autowired
    private SendMailService sendmail;
    @Autowired
    private PedidoNotificacaoRepository pedidoNotificacaoRepository;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;
    @Autowired
    private NotificacoesLogService notificacoesLogService;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private NotificacoesDiariasScreenService notificacoesDiariasScreenService;

    @Async(value="asyncDefault")
    public void send() {
        Thread.currentThread().setName("asyncDefault-notificacao-diaria-send");
        LocalDateTime dataInicial = LocalDateTime.of(LocalDate.now().minusDays(1L), LocalTime.of(17, 0));
        LocalDateTime dataFinal = LocalDateTime.of(LocalDate.now(), LocalTime.now());
        List estruturas = this.estruturaService.getAtivas();
        for (Long eId : estruturas) {
            Estrutura estrutura = this.estruturaService.getById(eId);
            List hs = this.eus.getAtivosByEstrutura(estrutura);
            for (HierarquiaDTO h : hs) {
                EstruturaUsuario eu = this.eus.getById(h.getEstruturaUsuarioId());
                try {
                    Set<Long> hierarquia;
                    if (eu.getUsuario().getInformativoComHierarquia() == null) continue;
                    if (eu.getUsuario().getInformativoComHierarquia().booleanValue()) {
                        hierarquia = this.hierarquiaService.getHierarquia(eu);
                    } else {
                        hierarquia = new HashSet();
                        hierarquia.add(eu.getId());
                    }
                    List atHoje = this.pr.findByListaEuAndDateBetween(hierarquia, dataInicial, dataFinal);
                    List atAmanha = this.pedidoNotificacaoRepository.findMarcadoByDataBYHierarquia(hierarquia, LocalDate.now().plusDays(1L));
                    if (atHoje.size() <= 0 && atAmanha.size() <= 0) continue;
                    String msg = this.getHtmlEmail(atHoje, atAmanha, h);
                    if (!h.getEmail().isEmpty()) {
                        this.sendmail.sendNoReply(((Pedido)atHoje.get(0)).getEstruturaUsuario(), h.getEmail(), "[NEO SALES] Seu e-mail informativo di\u00e1rio " + LocalDate.now().format(FormatDate.DATE_BR.toDTF()), msg);
                        this.notificacoesLogService.gravarEmail(eu, h.getEmail(), msg);
                        SleepUtil.inSeconds((Integer)1);
                    }
                    this.notificacoesService.notify(eu, "Resumo de movimenta\u00e7\u00f5es di\u00e1rias", msg);
                    this.notificacoesDiariasScreenService.create(eu, msg);
                }
                catch (Exception e) {
                    this.notificacoesLogService.gravarErro(eu, e.getMessage());
                }
            }
        }
    }

    private String getHtmlEmail(List<Pedido> atHoje, List<PedidoNotificacao> atAmanha, HierarquiaDTO h) {
        StringBuilder html = new StringBuilder(HtmlUtil.getCssTable());
        html.append("Ol\u00e1 <B>").append(h.getUsuarioNome()).append("</B> segue abaixo suas atividades marcadas para amanha e suas atividades movimentadas hoje.<BR><BR>");
        html.append("<table class=\"table\">");
        html.append("<tr><th colspan=9 style=\"text-align: center;\">RELAT\u00d3RIO GERADO \u00c0S ").append(LocalDateTime.now().format(FormatDate.DATETIME_BR.toDTF())).append("</th></tr>");
        html.append("<tr><th colspan=9 style=\"text-align: center;\">PR\u00d3XIMAS ATIVIDADES AGENDADAS</th></tr>");
        html.append("<tr><th>Usu\u00e1rio</th><th>Hora</th><th>Pedido</th><th>Cnpj</th><th>Cliente</th><th>Etapa</th><th>Cadastro</th><th>Vinculo</th><th>Tags</th></tr>");
        for (PedidoNotificacao pn : atAmanha) {
            Pedido pedido = pn.getPedido();
            html.append("<tr>");
            html.append("<td>").append(pn.getEstruturaUsuario().getUsuario().getNome()).append("</td>");
            html.append("<td>").append(pn.getHora() == null ? "" : pn.getHora()).append("</td>");
            html.append("<td>").append(pedido.getNumero()).append("</td>");
            html.append("<td>").append(pedido.getCliente().getCpfCnpj()).append("</td>");
            html.append("<td>").append(pedido.getCliente().getNome()).append("</td>");
            html.append("<td>").append(pedido.getPedidoEtapa().getNome()).append("</td>");
            html.append("<td>").append(pedido.getDataCadastro().format(FormatDate.DATE_BR.toDTF())).append("</td>");
            html.append("<td>").append(pedido.getNumeroPedidoVinculado() == null ? "" : pedido.getNumeroPedidoVinculado()).append("</td>");
            html.append("<td>").append(pedido.getTags() == null ? "" : pedido.getTags()).append("</td>");
            html.append("</tr>");
        }
        html.append("</table>");
        html.append("<table class=\"table\">");
        html.append("<tr><th colspan=8 style=\"text-align: center;\">\u00daLTIMAS MOVIMENTA\u00c7\u00d5ES</th></tr>");
        html.append("<tr><th>Usu\u00e1rio</th><th>Pedido</th><th>Cnpj</th><th>Cliente</th><th>Etapa</th><th>Cadastro</th><th>Vinculo</th><th>Tags</th><th>Nota Fiscal</th></tr>");
        for (Pedido pedido : atHoje) {
            html.append("<tr>");
            html.append("<td>").append(pedido.getEstruturaUsuario().getUsuario().getNome()).append("</td>");
            html.append("<td>").append(pedido.getNumero()).append("</td>");
            html.append("<td>").append(pedido.getCliente().getCpfCnpj()).append("</td>");
            html.append("<td>").append(pedido.getCliente().getNome()).append("</td>");
            html.append("<td>").append(pedido.getPedidoEtapa().getNome()).append("</td>");
            html.append("<td>").append(pedido.getDataCadastro().format(FormatDate.DATE_BR.toDTF())).append("</td>");
            html.append("<td>").append(pedido.getNumeroPedidoVinculado() == null ? "" : pedido.getNumeroPedidoVinculado()).append("</td>");
            html.append("<td>").append(pedido.getTags() == null ? "" : pedido.getTags()).append("</td>");
            html.append("<td>").append(pedido.getNotasFiscais() == null ? "" : pedido.getNotasFiscais()).append("</td>");
            html.append("</tr>");
        }
        html.append("</table>");
        html.append("<BR><BR>Att<BR>Equipe de Suporte.</body></html>");
        return html.toString();
    }
}

