/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.pedido.model.PedidoItemEtapa;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.repository.PedidoItemEtapaRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PedidoItemEtapaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String NOME_ETAPA_INICIAL = "CONCLUIDO";
    @Autowired
    private PedidoItemEtapaRepository pedidoItemEtapaRepository;

    public List<PedidoItemEtapa> getAllAtivos(Estrutura e) {
        return this.pedidoItemEtapaRepository.findByEstruturaAndAtivo(e, true);
    }

    public PedidoItemEtapa getEtapaInicial(Estrutura estrutura, PedidoOrigem origem) {
        return this.getAndCreate(estrutura, "CONCLUIDO", origem);
    }

    public PedidoItemEtapa salvar(PedidoItemEtapa itemEtapa) {
        if (itemEtapa.getEstrutura() == null) {
            throw new BusinessException("Estrutura nao informada");
        }
        return (PedidoItemEtapa)this.pedidoItemEtapaRepository.save((Object)itemEtapa);
    }

    public PedidoItemEtapa getByIdAndEstrutura(Long id, Estrutura estrutura) {
        return this.pedidoItemEtapaRepository.findByIdAndEstrutura(id, estrutura);
    }

    public List<PedidoItemEtapa> getByEstrutura(Estrutura estrutura) {
        return this.pedidoItemEtapaRepository.findByEstrutura(estrutura);
    }

    public PedidoItemEtapa getByNameAndPedidoOrigemAndEstrutura(Estrutura estrutura, String nome, Long idPedidoOrigem) {
        List listaPedidoItemEtapa = this.pedidoItemEtapaRepository.findByNomeAndEstruturaAndPedidoOrigemId(nome, estrutura, idPedidoOrigem);
        if (listaPedidoItemEtapa == null || listaPedidoItemEtapa.size() <= 0) {
            return null;
        }
        return (PedidoItemEtapa)listaPedidoItemEtapa.get(0);
    }

    public PedidoItemEtapa getByNome(Estrutura estrutura, String nome, PedidoOrigem pedidoOrigem) {
        if (nome == null) {
            throw new BusinessException("Nome da Etapa do item pedido n\u00e3o informado");
        }
        if ((nome = nome.replace("  ", " ").trim()).isEmpty()) {
            throw new BusinessException("Nome da etapa do item pedido n\u00e3o informado");
        }
        return this.getByNameAndPedidoOrigemAndEstrutura(estrutura, nome, pedidoOrigem.getId());
    }

    public PedidoItemEtapa getAndCreate(Estrutura estrutura, String nome, PedidoOrigem pedidoOrigem) {
        if (nome == null) {
            throw new BusinessException("Nome da Etapa do item pedido n\u00e3o informado");
        }
        if ((nome = nome.replace("  ", " ").trim()).isEmpty()) {
            throw new BusinessException("Nome da etapa do item pedido n\u00e3o informado");
        }
        PedidoItemEtapa pie = this.getByNameAndPedidoOrigemAndEstrutura(estrutura, nome, pedidoOrigem.getId());
        if (pie == null) {
            pie = new PedidoItemEtapa();
            pie.setAtivo(true);
            pie.setEstrutura(estrutura);
            pie.setNome(nome);
            pie.setDescricao("");
            pie.setPedidoOrigem(pedidoOrigem);
            pie = (PedidoItemEtapa)this.pedidoItemEtapaRepository.save((Object)pie);
        }
        return pie;
    }
}

