/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.pedido.model.PedidoItemSolicitacao;
import br.com.system.app.features.pedido.repository.PedidoItemSolicitacaoRepository;
import br.com.system.app.features.shared.model.OperadoraEnum;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PedidoItemSolicitacaoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String PORTADO = "PORTADO";
    private final String NOVO = "NOVO";
    private final String RENOVACAO = "RENOVA\u00c7\u00c3O";
    private final String NOVO_PORTADO = "NOVO / PORTADO";
    @Autowired
    private PedidoItemSolicitacaoRepository repository;

    public PedidoItemSolicitacao getPortado(EstruturaTipo et) {
        if (et.getOperadora().equals((Object)OperadoraEnum.TIM)) {
            return this.repository.findByEstruturaTipoAndNome(et, "NOVO / PORTADO");
        }
        return this.repository.findByEstruturaTipoAndNome(et, "PORTADO");
    }

    public PedidoItemSolicitacao getNovo(EstruturaTipo et) {
        return this.repository.findByEstruturaTipoAndNome(et, "NOVO");
    }

    public PedidoItemSolicitacao getRenovacao(EstruturaTipo et) {
        return this.repository.findByEstruturaTipoAndNome(et, "RENOVA\u00c7\u00c3O");
    }

    public List<PedidoItemSolicitacao> getAtivos(EstruturaTipo et) {
        return this.repository.findByEstruturaTipoAndAtivo(et, Boolean.TRUE);
    }

    public PedidoItemSolicitacao getByNome(EstruturaTipo et, String nome) {
        return this.repository.findByEstruturaTipoAndNome(et, nome);
    }
}

