/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.pedido.model.PedidoOrigem;
import br.com.system.app.features.pedido.repository.PedidoOrigemRepository;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PedidoOrigemService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String ORIGEM = "NEOCRM";
    @Autowired
    private PedidoOrigemRepository pedidoOrigemRepository;

    public PedidoOrigem getOrigemConexao(Estrutura estrutura) {
        return this.pedidoOrigemRepository.findByEstruturaTipoAndNome(estrutura.getEstruturaTipo(), "CONEXAO");
    }

    public PedidoOrigem getPedidoVivoCorp(Estrutura estrutura) {
        return this.pedidoOrigemRepository.findByEstruturaTipoAndNome(estrutura.getEstruturaTipo(), "VIVO-CORP");
    }

    public PedidoOrigem getOrigemIW(Estrutura estrutura) {
        return this.pedidoOrigemRepository.findByEstruturaTipoAndNome(estrutura.getEstruturaTipo(), "IW");
    }

    public PedidoOrigem getOrigemByNome(EstruturaTipo estruturaTipo, String nome) {
        return this.pedidoOrigemRepository.findByEstruturaTipoAndNome(estruturaTipo, nome);
    }

    public PedidoOrigem getOrigemAtividade(Estrutura estrutura) {
        return this.pedidoOrigemRepository.findByEstruturaTipoAndNome(estrutura.getEstruturaTipo(), "NEOCRM");
    }

    public PedidoOrigem getById(Long id) {
        return (PedidoOrigem)this.pedidoOrigemRepository.findById((Object)id).get();
    }

    public List<PedidoOrigem> getByEstruturaTipoActiveOnly(EstruturaTipo estruturaTipo) {
        return this.pedidoOrigemRepository.findByEstruturaTipoIdAndAtivo(estruturaTipo.getId(), Boolean.valueOf(true));
    }

    public List<PedidoOrigem> getByEstruturaTipo(EstruturaTipo estruturaTipo) {
        return this.pedidoOrigemRepository.findByEstruturaTipoId(estruturaTipo.getId());
    }
}

