/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pedido.dto.PedidoStatusDTO;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoStatus;
import br.com.system.app.features.pedido.repository.PedidoRepository;
import br.com.system.app.features.pedido.repository.PedidoStatusRepository;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PedidoStatusService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PedidoStatusRepository pedidoStatusRepository;

    public void movimentar(Set<Long> pedidos, PedidoEtapa pe, EstruturaUsuario eu, boolean forcar) {
        for (Long pedido : pedidos) {
            Pedido p = (Pedido)this.pedidoRepository.findById((Object)pedido).get();
            if (!forcar && !p.getPedidoEtapa().isEditavel() || p.getPedidoEtapa().getId().equals(pe.getId())) continue;
            this.movimentar(p, pe, eu, "");
            p = null;
        }
    }

    public void movimentar(Pedido pedido, PedidoEtapa pe, EstruturaUsuario eu, String movimentacao) {
        this.sair(pedido, eu);
        this.entrar(pedido, pe, eu, movimentacao);
    }

    public void entrar(Pedido pedido, PedidoEtapa pe, EstruturaUsuario eu, String movimentacao) {
        PedidoStatus psEntrou = new PedidoStatus();
        psEntrou.setPedido(pedido);
        psEntrou.setPedidoEtapa(pe);
        psEntrou.setDataHoraEntrou(LocalDateTime.now());
        psEntrou.setEstruturaUsuarioEntrou(eu);
        psEntrou.setMovimentacao(movimentacao);
        this.pedidoStatusRepository.save((Object)psEntrou);
    }

    public void sair(Pedido pedido, EstruturaUsuario eu) {
        this.sair(pedido, null, eu);
    }

    public void sair(Pedido pedido, PedidoEtapa pe, EstruturaUsuario eu) {
        PedidoStatus psSaiu;
        if (pe == null) {
            pe = pedido.getPedidoEtapa();
        }
        if ((psSaiu = this.pedidoStatusRepository.findFirstByPedidoAndPedidoEtapaOrderByIdDesc(pedido, pe)) == null || psSaiu.getDataHoraSaiu() != null) {
            psSaiu = new PedidoStatus();
            psSaiu.setPedido(pedido);
            psSaiu.setPedidoEtapa(pedido.getPedidoEtapa());
            psSaiu.setDataHoraEntrou(pedido.getDataHoraAtualizacao());
            psSaiu.setEstruturaUsuarioEntrou(pedido.getEstruturaUsuario());
        }
        psSaiu.setDataHoraSaiu(LocalDateTime.now());
        psSaiu.setEstruturaUsuarioSaiu(eu);
        this.pedidoStatusRepository.save((Object)psSaiu);
    }

    public List<PedidoStatus> getByPedido(Pedido pedido) {
        return this.pedidoStatusRepository.findByPedidoOrderByDataHoraEntrou(pedido);
    }

    public List<PedidoStatusDTO> getByListaPedido(Estrutura e, Set<Long> pedidos) {
        return this.pedidoStatusRepository.findByListPedido(e.getId(), pedidos, null);
    }

    public List<PedidoStatusDTO> getForBi(Long eId, LocalDateTime dataHoraUltimaCarga) {
        return this.pedidoStatusRepository.findByListPedido(eId, null, dataHoraUltimaCarga);
    }

    @Transactional
    public void deleteByPedido(Pedido pedido) {
        this.pedidoStatusRepository.deleteByPedido(pedido);
    }
}

