/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import br.com.system.app.features.pedido.model.PedidoEtapaGrupo;
import br.com.system.app.features.pedido.model.PedidoEtapaGrupoItem;
import br.com.system.app.features.pedido.service.PedidoEtapaGrupoService;
import br.com.system.app.features.pedido.service.PedidoEtapaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="atividade-etapas-grupo", layout=MainLayout.class)
@PageTitle(value="Grupo de Etapas")
@RolesAllowed(value={"ATIVIDADE_ETAPA_GRUPO_VIEW"})
public class PedidoEtapaGrupoView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoEtapaService pes;
    private final PedidoEtapaGrupoService pegs;
    private GridCrud<PedidoEtapaGrupo> crud;
    private PedidoEtapaGrupo grupo;
    Button btnAdd;
    Button btnEditar;
    Button btnExcluir;

    public PedidoEtapaGrupoView(PedidoEtapaService pes, PedidoEtapaGrupoService pegs) {
        this.pes = pes;
        this.pegs = pegs;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.setWidth("600px");
        this.btnAdd = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Criar Novo Grupo");
        this.btnAdd.setEnabled(this.hasPermission("ATIVIDADE_ETAPA_GRUPO_SAVE"));
        this.btnAdd.addClickListener((ComponentEventListener & Serializable)e -> {
            this.grupo = null;
            this.form();
        });
        this.btnEditar = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Editar");
        this.btnEditar.setEnabled(this.hasPermission("ATIVIDADE_ETAPA_GRUPO_SAVE"));
        this.btnEditar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione um item para editar");
                return;
            }
            this.grupo = (PedidoEtapaGrupo)this.crud.getGrid().getSelectedItems().iterator().next();
            this.form();
        });
        this.btnExcluir = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir");
        this.btnExcluir.setEnabled(this.hasPermission("ATIVIDADE_ETAPA_GRUPO_DELETE"));
        this.btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().size() <= 0) {
                this.showNotification("Selecione um item para editar");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Excluir", "Confirma exclus\u00e3o");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                this.pegs.delete((PedidoEtapaGrupo)this.crud.getGrid().getSelectedItems().iterator().next());
                cd.close();
                this.crud.refreshGrid();
            });
        });
        VerticalContainer main = new VerticalContainer(new Component[0]);
        main.setHeightFull();
        main.add(new Component[]{this.getGrid()});
        return main;
    }

    private GridCrud<PedidoEtapaGrupo> getGrid() {
        this.crud = new GridCrud(PedidoEtapaGrupo.class);
        this.crud.getCrudLayout().addToolbarComponent((Component)new HorizontalContainer(new Component[]{this.btnAdd, this.btnEditar, this.btnExcluir}));
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn("nome").setFlexGrow(0).setWidth("380px");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[0]);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }

    private void form() {
        Dialog d = new Dialog();
        d.setWidth("450px");
        d.setCloseOnOutsideClick(false);
        TextField nome = new TextField("Nome");
        nome.setWidthFull();
        MultiComboBox cbEtapa = new MultiComboBox("Etapas", (Collection)this.pes.getAllAtivos(this.getEstrutura()));
        cbEtapa.setWidthFull();
        cbEtapa.setItemLabelGenerator(PedidoEtapa::getNomeAndOrigemAndTipo);
        if (this.grupo == null) {
            this.grupo = new PedidoEtapaGrupo();
            this.grupo.setEstrutura(this.getEstrutura());
        } else {
            HashSet<PedidoEtapa> etapas = new HashSet<PedidoEtapa>();
            for (PedidoEtapaGrupoItem pegi : this.grupo.getItens()) {
                etapas.add(pegi.getPedidoEtapa());
            }
            cbEtapa.setValue(etapas);
            nome.setValue(this.grupo.getNome());
        }
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar");
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (nome.getValue().isEmpty()) {
                this.showNotification("Informe um nome para o grupo");
                return;
            }
            if (cbEtapa.getValue().size() <= 0) {
                this.showNotification("Selecione pelo menos 1 etapa para criar o grupo");
                return;
            }
            this.grupo.getItens().removeAll(this.grupo.getItens());
            for (PedidoEtapa pe : cbEtapa.getValue()) {
                PedidoEtapaGrupoItem pegi = new PedidoEtapaGrupoItem();
                pegi.setPedidoEtapa(pe);
                pegi.setPedidoEtapaGrupo(this.grupo);
                this.grupo.getItens().add(pegi);
            }
            this.grupo.setNome(nome.getValue());
            this.pegs.save(this.grupo);
            d.close();
            this.crud.refreshGrid();
        });
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> d.close());
        d.add(new Component[]{new VerticalContainer(new Component[]{UIUtils.createHeader((String)"Insira as etapas"), nome, cbEtapa, new FooterContainer(new Component[]{btnFechar, btnSalvar})})});
        d.open();
    }
}

