/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pedido.view;

import br.com.system.app.MainLayout;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.pedido.model.PedidoSubCategoria;
import br.com.system.app.features.pedido.service.PedidoSubCategoriaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="cadastro-sub-pedido-categoria", layout=MainLayout.class)
@PageTitle(value="")
@RolesAllowed(value={"PEDIDO_SUB_CATEGORIA_VIEW"})
public class PedidoSubCategoriaView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PedidoSubCategoriaService pcs;
    private final EstruturaComplementoService ecs;

    @Autowired
    public PedidoSubCategoriaView(PedidoSubCategoriaService pcs, EstruturaComplementoService ecs) {
        this.pcs = pcs;
        this.ecs = ecs;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    private Component createContent() {
        EstruturaComplemento compl = this.ecs.getComplementos(this.getEstrutura());
        GridCrud crud = new GridCrud(PedidoSubCategoria.class);
        crud.getCrudLayout().addToolbarComponent((Component)new H3(compl.getNomeCampoSubCategoria()));
        crud.getAddButton().setText("Adicionar");
        crud.getGrid().setColumns(new String[0]);
        crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
        crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getAtivo() != false ? "SIM" : "N\u00c3O")).setHeader("ATIVO");
        crud.getGrid().setColumnReorderingAllowed(true);
        crud.getCrudFormFactory().setUseBeanValidation(true);
        crud.getCrudFormFactory().setVisibleProperties(new String[]{"nome", "ativo"});
        crud.getAddButton().setVisible(this.hasPermission("PEDIDO_SUB_CATEGORIA_SAVE"));
        crud.getUpdateButton().setVisible(this.hasPermission("PEDIDO_SUB_CATEGORIA_SAVE"));
        crud.getDeleteButton().setVisible(false);
        crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return crud;
    }
}

