/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.popnovidade;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.popnovidade.model.PopNovidade;
import br.com.system.app.features.popnovidade.service.PopNovidadeService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.IFrame;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import java.io.Serializable;

public class PopNovidadeView
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final PopNovidade pn;
    private final EstruturaUsuario eu;
    private final PopNovidadeService service;

    public PopNovidadeView(EstruturaUsuario eu, PopNovidade pn, PopNovidadeService service) {
        this.eu = eu;
        this.pn = pn;
        this.service = service;
        this.setCloseOnOutsideClick(false);
    }

    public void create() {
        VerticalContainer v = new VerticalContainer(new Component[0]);
        Icon icon = new Icon(VaadinIcon.BOMB);
        icon.setColor(Color.RED.getValue());
        Span label = new Span(this.pn.getTitulo());
        label.addClassName("h6");
        FlexBoxLayout cab = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[]{icon, label});
        cab.setAlignItems(FlexComponent.Alignment.CENTER);
        v.add(new Component[]{cab});
        IFrame iFrame = new IFrame(this.pn.getLinkVideo());
        iFrame.setHeight("240px");
        iFrame.setWidth("426px");
        iFrame.setAllow("accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture");
        iFrame.getElement().setAttribute("allowfullscreen", true);
        iFrame.getElement().setAttribute("frameborder", "2");
        v.add(new Component[]{iFrame});
        Button btnClose = UIUtils.createSmallButton((String)"Fechar");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button btnVisto = UIUtils.createSmallButton((String)"N\u00e3o ver mais");
        btnVisto.addClickListener((ComponentEventListener & Serializable)e -> {
            this.service.saveVisto(this.pn, this.eu);
            this.close();
        });
        v.add(new Component[]{new FooterContainer(new Component[]{btnVisto, btnClose})});
        this.add(new Component[]{v});
        this.open();
    }
}

