/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.repository;

import br.com.system.app.features.estrutura.model.EstruturaSenhas;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.pedido.dto.PedidoSlaENUM;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.dto.TagOptionEnum;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.producaopainel.dto.ProducaoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoEtapaDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoExportacaoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoFilterEtapaEnum;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoPedidoFilter;
import br.com.system.app.features.producaopainel.dto.ProducaoProdutoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoReturnType;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.repository.ProducaoPainelRepositoryQuery;
import br.com.system.app.features.shared.model.CnpjCpfEnum;
import br.com.system.app.features.usuario.model.UsuarioTag;
import br.com.system.commons.StringUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class ProducaoPainelRepositoryImpl
implements ProducaoPainelRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private EstruturaComplementoService complementoService;
    @Autowired
    private EstruturaUsuarioService eus;

    @Transactional(readOnly=true)
    public List<ProducaoPedidoDTO> getProducaoByPedido(EstruturaUsuario eu, ProducaoPedidoFilter filter, Boolean orderAsc, Pageable pageable) {
        Query query = this.getQueryProducaoPedido(eu, filter, pageable, Boolean.valueOf(false), orderAsc);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public Integer countProducaoByPedido(EstruturaUsuario eu, ProducaoPedidoFilter filter) {
        Query query = this.getQueryProducaoPedido(eu, filter, null, Boolean.valueOf(true), Boolean.valueOf(false));
        Integer total = StringUtil.toInteger((String)query.getSingleResult().toString());
        return total;
    }

    private Query getQueryProducaoPedido(EstruturaUsuario eu, ProducaoPedidoFilter filter, Pageable pageable, Boolean count, Boolean orderAsc) {
        Query query;
        int ind;
        if (filter.getPedidoTipo() == null) {
            filter.setPedidoTipo(PedidoTipoEnum.COMERCIAL);
        }
        StringBuilder sql = new StringBuilder();
        if (count.booleanValue()) {
            if (filter.getProducaoFilterEtapaEnum() != null && filter.getFilterPedidoEtapa() != null && !filter.getFilterPedidoEtapa().isEmpty()) {
                sql.append("SELECT COUNT(DISTINCT pedido.id) as total");
            } else {
                sql.append("SELECT COUNT(*) as total");
            }
        } else {
            if (filter.getProducaoFilterEtapaEnum() != null && filter.getFilterPedidoEtapa() != null && !filter.getFilterPedidoEtapa().isEmpty()) {
                sql.append(" SELECT DISTINCT");
            } else {
                sql.append(" SELECT ");
            }
            sql.append(" pedido.id,pedido.tags,pedido.login_operadora,pedido.complementos,pedido.lead_sistema,pedido.data_retorno_futuro,");
            sql.append("     pedido.numero as numero_pedido,pedido.numero_pedido_vinculado,pedido.numero_pedido_origem,");
            sql.append("     cliente.cpf_cnpj,cliente.nome as nome_cliente,pedido.pedido_etapa_id,");
            sql.append("     pedido.data_hora_atualizacao,pedido.data_cadastro,pedido_etapa.nome as nome_status,usuario.nome nome_usuario,");
            sql.append("     uAdm.nome as nome_usuario_adm,pedido.pedido_tipo,pedido.notas_fiscais,");
            sql.append("     pedido_origem_etapa.nome nome_etapa_origem,");
            sql.append("     pedido_origem.id pedido_origem_id,");
            sql.append("     pedido_origem.nome nome_origem,");
            sql.append("     usuario.login login_usuario,");
            sql.append("     usuario.tags tag_usuario,pedido_etapa.atualiza_data_referencia,");
            sql.append("     equipe.nome equipe_usuario,pedido_etapa.sla_dias etapa_sla_dias,");
            sql.append("     pedido.data_hora_ultima_mov,NEO_TIMEDIFF(pedido.data_hora_ultima_mov,current_timestamp()) tempo,pedido_etapa.editavel,");
            sql.append("     pedido.numero_simulacao,pedido.cotacao as numero_cotacao,");
            sql.append("     pedido_categoria.nome pedido_categoria,pedido_sub_categoria.nome pedido_sub_categoria,");
            if (filter.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP)) {
                sql.append(" if (w.numero is null,'',w.numero) whatsapp_numero,if (wa.id is null,'0',wa.id) whatsapp_atendimento_id,");
                sql.append(" if (wa.fechado, true,false) whatsapp_fechado,if (w.nome is null,'',w.nome) whatsapp_nome,");
                sql.append(" wa.ultima_mensagem whats_ultima_mensagem,wa.lida whats_lida,wa.escolha_tipo as whatsapp_escolha_tipo,");
                sql.append(" w.login whats_login,");
            } else {
                sql.append(" '0' whatsapp_atendimento_id,'' whatsapp_numero,0 whatsapp_fechado,'' whatsapp_nome,'' whats_ultima_mensagem,0 whats_lida,'' whatsapp_escolha_tipo, '' whats_login,");
            }
            sql.append("     pedido_etapa.sla_horas");
        }
        sql.append(" FROM");
        String index = "force index(idx_pedido_estrutura_tipo_etapa_data)";
        if (filter.getFilterNomeCliente() != null && !filter.getFilterNomeCliente().isEmpty()) {
            sql.append(" cliente ");
            sql.append(" join pedido on (pedido.cliente_id=cliente.id)");
        } else if (filter.getFilterCnpj() != null && !filter.getFilterCnpj().isEmpty()) {
            sql.append(" cliente ");
            sql.append(" join pedido on (pedido.cliente_id=cliente.id)");
        } else {
            sql.append(" pedido  forceIndex ");
            sql.append(" join cliente on (pedido.cliente_id=cliente.id)");
        }
        sql.append("     join estrutura_usuario on (pedido.estrutura_usuario_id = estrutura_usuario.id)");
        sql.append("     join usuario on (estrutura_usuario.usuario_id=usuario.id)");
        sql.append("     join pedido_etapa on (pedido.pedido_etapa_id = pedido_etapa.id)");
        sql.append("     join pedido_origem on (pedido.pedido_origem_id=pedido_origem.id)");
        sql.append("     join pedido_origem pedido_origem_etapa on (pedido_etapa.pedido_origem_id=pedido_origem_etapa.id)");
        sql.append("     left join pedido_categoria on (pedido.pedido_categoria_id=pedido_categoria.id)");
        sql.append("     left join pedido_sub_categoria on (pedido.pedido_sub_categoria_id=pedido_sub_categoria.id)");
        sql.append("     left join estrutura_usuario euAdm on (pedido.estrutura_usuario_adm_id = euAdm.id)");
        sql.append("     left join usuario uAdm on (euAdm.usuario_id=uAdm.id)");
        sql.append("     left join equipe on (estrutura_usuario.equipe_id=equipe.id)");
        if (filter.getProducaoFilterEtapaEnum() != null && filter.getFilterPedidoEtapa() != null && !filter.getFilterPedidoEtapa().isEmpty()) {
            sql.append("  join pedido_status on (pedido.id=pedido_status.pedido_id)");
        }
        if (filter.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP)) {
            sql.append("  left join whatsapp_atendimento wa on (pedido.id=wa.pedido_id )");
            sql.append("  left join whatsapp w on (wa.whatsapp_id=w.id)");
        }
        sql.append(" WHERE");
        sql.append("     estrutura_usuario.estrutura_id=:estruturaId");
        if (filter.getSomenteComAtendimento() != null && filter.getSomenteComAtendimento().booleanValue()) {
            sql.append(" AND wa.pedido_id !=0 and wa.pedido_id is not null");
            index = "";
        }
        if (filter.getNumeroWhats() != null && !filter.getNumeroWhats().isEmpty()) {
            sql.append(" AND w.numero = '").append(filter.getNumeroWhats()).append("'");
            index = "";
        }
        if (filter.getNomeWhats() != null && !filter.getNomeWhats().isEmpty()) {
            sql.append(" AND w.nome like '%").append(filter.getNomeWhats()).append("%'");
            index = "";
        }
        if (filter.getCpfCnpjEnum() != null) {
            if (filter.getCpfCnpjEnum().equals((Object)CnpjCpfEnum.CNPJ)) {
                sql.append(" AND length(cliente.cpf_cnpj)=14");
                index = "";
            } else if (filter.getCpfCnpjEnum().equals((Object)CnpjCpfEnum.CPF)) {
                sql.append(" AND length(cliente.cpf_cnpj)=11");
                index = "";
            }
        }
        if (filter.getDataNotificacao() != null) {
            sql.append(" AND pedido.id in (select pedido_id from pedido_notificacao WHERE data='").append(filter.getDataNotificacao().format(DateTimeFormatter.ISO_DATE)).append("')");
            index = "";
        }
        if (this.eus.hasPermission(eu, "ATIVIDADE_VISUALIZA_SOMENTE_PROPRIETARIO").booleanValue()) {
            if (filter.getHierarquia().size() == 1) {
                sql.append(" AND pedido.estrutura_usuario_id=:hierarquia");
            } else if (filter.getHierarquia().size() > 1) {
                sql.append("     AND pedido.estrutura_usuario_id in :hierarquia");
            }
        } else if (filter.getHierarquia().size() == 1) {
            sql.append(" AND (pedido.estrutura_usuario_id=:hierarquia or pedido.estrutura_usuario_adm_id=:hierarquia)");
        } else if (filter.getHierarquia().size() > 1) {
            sql.append("     AND (pedido.estrutura_usuario_id in :hierarquia");
            sql.append("     or pedido.estrutura_usuario_adm_id in :hierarquia)");
        }
        sql.append("    AND pedido.pedido_tipo=:pedidoTipo");
        if (filter.getPedidoCategoria() != null) {
            sql.append(" AND pedido.pedido_categoria_id=:pedidoCategoriaId");
            index = "";
        }
        if (filter.getPedidoSubCategoria() != null) {
            sql.append(" AND pedido.pedido_sub_categoria_id=:pedidoSubCategoriaId");
            index = "";
        }
        if (filter.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP) && filter.isKanban()) {
            sql.append("  and (wa.etapa='ATENDENTE' or wa.etapa is null) ");
            index = "";
        }
        if (filter.getPedidoSlaENUM() != null && filter.getPedidoSlaENUM().equals((Object)PedidoSlaENUM.NO_PRAZO)) {
            sql.append(" AND NEO_TIMEDIFF(pedido.data_hora_ultima_mov,current_timestamp()) <= pedido_etapa.sla_horas");
            index = "";
        } else if (filter.getPedidoSlaENUM() != null && filter.getPedidoSlaENUM().equals((Object)PedidoSlaENUM.FORA_DO_PRAZO)) {
            sql.append(" AND NEO_TIMEDIFF(pedido.data_hora_ultima_mov,current_timestamp()) > pedido_etapa.sla_horas");
            index = "";
        }
        if (filter.getFilterNumeroPedido().size() <= 0 && filter.getFilterCnpj().size() <= 0 && filter.getFilterNumeroVinculado().size() <= 0 && filter.getConsiderarDatas().booleanValue()) {
            if (filter.getDataInicialCadastro() != null) {
                sql.append(" AND pedido.data_cadastro >=:dataInicialCadastro");
                index = "";
            }
            if (filter.getDataFinalCadatro() != null) {
                sql.append(" AND pedido.data_cadastro <=:dataFinalCadastro");
                index = "";
            }
            if (filter.getProducaoFilterEtapaEnum() == null || filter.isKanban() && filter.getFilterCnpj().isEmpty()) {
                if (filter.getDataInicialAtualizacao() != null) {
                    sql.append(" AND pedido.data_hora_atualizacao  >=:dataInicialAtualizacao");
                }
                if (filter.getDataFinalAtualizacao() != null) {
                    sql.append(" AND pedido.data_hora_atualizacao  <=:dataFinalAtualizacao");
                }
            }
        }
        if (filter.getNaoVinculado() != null && filter.getNaoVinculado().booleanValue()) {
            sql.append(" AND pedido.numero_pedido_vinculado is null");
            index = "";
        }
        if (filter.getUsuarioTags() != null && !filter.getUsuarioTags().isEmpty()) {
            sql.append(" AND (");
            ind = 0;
            for (UsuarioTag ut : filter.getUsuarioTags()) {
                sql.append("find_in_set('").append(ut.getTag()).append("',usuario.tags)");
                if (ind < filter.getUsuarioTags().size() - 1) {
                    sql.append(" or ");
                }
                ++ind;
            }
            index = "";
            sql.append(")");
        }
        if (filter.getTags() != null && !filter.getTags().isEmpty()) {
            sql.append(" AND (");
            ind = 0;
            for (PedidoTags pt : filter.getTags()) {
                if (filter.getTagOptionEnum() != null && filter.getTagOptionEnum().equals((Object)TagOptionEnum.NAO)) {
                    sql.append(" not ");
                }
                sql.append("find_in_set('").append(pt.getTag()).append("',pedido.tags)");
                if (ind < filter.getTags().size() - 1) {
                    if (filter.getTagOptionEnum() != null && (filter.getTagOptionEnum().equals((Object)TagOptionEnum.OU) || filter.getTagOptionEnum().equals((Object)TagOptionEnum.NAO))) {
                        sql.append(" or ");
                    } else if (filter.getTagOptionEnum() != null && filter.getTagOptionEnum().equals((Object)TagOptionEnum.E)) {
                        sql.append(" and ");
                    }
                }
                ++ind;
            }
            index = "";
            sql.append(")");
        }
        if (filter.getFilterEquipes() != null && !filter.getFilterEquipes().isEmpty()) {
            sql.append("   AND estrutura_usuario.equipe_id in :equipe");
            index = "";
        }
        if (filter.getFilterNomeCliente() != null && !filter.getFilterNomeCliente().isEmpty()) {
            sql.append(" AND cliente.nome like :nomeCliente");
            index = "";
        }
        if (filter.getFilterCnpj() != null && !filter.getFilterCnpj().isEmpty()) {
            sql.append(" AND (cliente.cpf_cnpj ").append(filter.getFilterCnpj().size() == 1 ? " = " : " in ").append(":listaCpfCnpj)");
            index = "";
        }
        if (filter.getFilterSenhas() != null && !filter.getFilterSenhas().isEmpty()) {
            sql.append(" AND pedido.estrutura_senhas_id in :loginOperadora");
            index = "";
        }
        if (filter.getFilterNumeroPedido() != null && !filter.getFilterNumeroPedido().isEmpty()) {
            sql.append("         AND pedido.numero in :numeroPedido");
            index = "";
        } else if (filter.getFilterNumeroVinculado() != null && !filter.getFilterNumeroVinculado().isEmpty()) {
            sql.append("         AND pedido.numero_pedido_vinculado in :numeroPedidoVinculado");
            index = "";
        } else if (!this.complementoService.getComplementos(filter.getEstrutura()).isMostrarAtividadeVinculada()) {
            sql.append("         AND (pedido.numero_pedido_vinculado is null or pedido_origem.nome !='NEOCRM')");
            index = "";
        }
        if (filter.getFilterCotacao() != null && !filter.getFilterCotacao().isEmpty()) {
            sql.append("         AND pedido.cotacao in :cotacao");
            index = "";
        }
        if (filter.getFilterSimulacao() != null && !filter.getFilterSimulacao().isEmpty()) {
            sql.append("         AND pedido.numero_simulacao in :simulacao");
            index = "";
        }
        if (filter.getFilterPedidoEtapa() != null && !filter.getFilterPedidoEtapa().isEmpty() && filter.getProducaoFilterEtapaEnum() == null) {
            if (filter.getFilterPedidoEtapa().size() == 1) {
                sql.append("         AND pedido.pedido_etapa_id = :pedidoEtapa");
            } else {
                sql.append("         AND pedido.pedido_etapa_id in :pedidoEtapa");
            }
        } else if (filter.getPedidoOrigem() != null && filter.getProducaoFilterEtapaEnum() == null) {
            sql.append("         AND pedido.pedido_origem_id=:pedidoOrigemId");
            index = "";
        }
        if (filter.getProducaoFilterEtapaEnum() != null && filter.getFilterPedidoEtapa() != null && !filter.getFilterPedidoEtapa().isEmpty()) {
            if (filter.getProducaoFilterEtapaEnum().equals((Object)ProducaoFilterEtapaEnum.ENTROU) && filter.getConsiderarDatas().booleanValue()) {
                if (filter.getDataInicialAtualizacao() != null) {
                    sql.append(" AND pedido_status.data_hora_entrou >=:dataInicialAtualizacao");
                }
                if (filter.getDataFinalAtualizacao() != null) {
                    sql.append(" AND pedido_status.data_hora_entrou  <=:dataFinalAtualizacao");
                }
            } else if (filter.getProducaoFilterEtapaEnum().equals((Object)ProducaoFilterEtapaEnum.SAIU) && filter.getConsiderarDatas().booleanValue()) {
                if (filter.getDataInicialAtualizacao() != null) {
                    sql.append(" AND pedido_status.data_hora_saiu  >=:dataInicialAtualizacao");
                }
                if (filter.getDataFinalAtualizacao() != null) {
                    sql.append(" AND pedido_status.data_hora_saiu  <=:dataFinalAtualizacao");
                }
            }
            index = "";
            sql.append("  AND pedido_status.pedido_etapa_id  in :pedidoEtapa");
        }
        if (!count.booleanValue()) {
            if (orderAsc != null && filter.isKanban()) {
                if (filter.getPedidoTipo().equals((Object)PedidoTipoEnum.WHATSAPP)) {
                    sql.append(" ORDER BY wa.lida asc,pedido.data_hora_atualizacao ").append(orderAsc != false ? "ASC" : "DESC");
                } else {
                    sql.append(" ORDER BY pedido.data_hora_atualizacao ").append(orderAsc != false ? "ASC" : "DESC");
                }
            } else if (orderAsc != null && pageable != null) {
                sql.append(" ORDER BY pedido.data_hora_atualizacao ").append(orderAsc != false ? "ASC" : "DESC");
            }
            if (pageable != null) {
                sql.append(" limit :limit offset :offset");
            }
            sqlS = sql.toString().replace("forceIndex", index);
            query = this.manager.createNativeQuery(sqlS, ProducaoPedidoDTO.class);
        } else {
            sqlS = sql.toString().replace("forceIndex", index);
            query = this.manager.createNativeQuery(sqlS);
        }
        query.setParameter("pedidoTipo", (Object)filter.getPedidoTipo().name());
        if (!filter.getHierarquia().isEmpty()) {
            query.setParameter("hierarquia", (Object)filter.getHierarquia());
        }
        if (filter.getFilterCnpj() != null && !filter.getFilterCnpj().isEmpty()) {
            query.setParameter("listaCpfCnpj", (Object)filter.getFilterCnpj());
        }
        if (filter.getFilterNumeroPedido().size() <= 0 && filter.getFilterCnpj().size() <= 0 && filter.getFilterNumeroVinculado().size() <= 0 && filter.getConsiderarDatas().booleanValue()) {
            if (filter.getDataInicialCadastro() != null) {
                query.setParameter("dataInicialCadastro", (Object)filter.getDataInicialCadastro());
            }
            if (filter.getDataFinalCadatro() != null) {
                query.setParameter("dataFinalCadastro", (Object)filter.getDataFinalCadatro());
            }
            if (filter.getProducaoFilterEtapaEnum() == null || filter.isKanban() && filter.getFilterCnpj().isEmpty()) {
                if (filter.getDataInicialAtualizacao() != null) {
                    query.setParameter("dataInicialAtualizacao", (Object)(String.valueOf(filter.getDataInicialAtualizacao()) + " 00:00:00"));
                }
                if (filter.getDataFinalAtualizacao() != null) {
                    query.setParameter("dataFinalAtualizacao", (Object)(String.valueOf(filter.getDataFinalAtualizacao()) + " 23:59:59"));
                }
            }
        }
        if (filter.getProducaoFilterEtapaEnum() != null && filter.getFilterPedidoEtapa() != null && !filter.getFilterPedidoEtapa().isEmpty()) {
            if (filter.getDataInicialAtualizacao() != null) {
                query.setParameter("dataInicialAtualizacao", (Object)(String.valueOf(filter.getDataInicialAtualizacao()) + " 00:00:00"));
            }
            if (filter.getDataFinalAtualizacao() != null) {
                query.setParameter("dataFinalAtualizacao", (Object)(String.valueOf(filter.getDataFinalAtualizacao()) + " 23:59:59"));
            }
        }
        if (filter.getFilterNomeCliente() != null && !filter.getFilterNomeCliente().isEmpty()) {
            query.setParameter("nomeCliente", (Object)(filter.getFilterNomeCliente() + "%"));
        }
        if (filter.getPedidoCategoria() != null) {
            query.setParameter("pedidoCategoriaId", (Object)filter.getPedidoCategoria().getId());
        }
        if (filter.getPedidoSubCategoria() != null) {
            query.setParameter("pedidoSubCategoriaId", (Object)filter.getPedidoSubCategoria().getId());
        }
        if (filter.getFilterNumeroPedido() != null && !filter.getFilterNumeroPedido().isEmpty()) {
            query.setParameter("numeroPedido", (Object)filter.getFilterNumeroPedido());
        }
        if (filter.getFilterNumeroVinculado() != null && !filter.getFilterNumeroVinculado().isEmpty()) {
            query.setParameter("numeroPedidoVinculado", (Object)filter.getFilterNumeroVinculado());
        }
        if (filter.getFilterCotacao() != null && !filter.getFilterCotacao().isEmpty()) {
            query.setParameter("cotacao", (Object)filter.getFilterCotacao());
        }
        if (filter.getFilterSimulacao() != null && !filter.getFilterSimulacao().isEmpty()) {
            query.setParameter("simulacao", (Object)filter.getFilterSimulacao());
        }
        if (filter.getFilterSenhas() != null && !filter.getFilterSenhas().isEmpty()) {
            query.setParameter("loginOperadora", (Object)filter.getFilterSenhas());
        }
        if (filter.getFilterPedidoEtapa() != null && !filter.getFilterPedidoEtapa().isEmpty()) {
            query.setParameter("pedidoEtapa", (Object)filter.getFilterPedidoEtapa());
        } else if (filter.getPedidoOrigem() != null && filter.getProducaoFilterEtapaEnum() == null) {
            query.setParameter("pedidoOrigemId", (Object)filter.getPedidoOrigem().getId());
        }
        if (filter.getFilterEquipes() != null && !filter.getFilterEquipes().isEmpty()) {
            query.setParameter("equipe", (Object)filter.getFilterEquipes());
        }
        query.setParameter("estruturaId", (Object)filter.getEstrutura().getId());
        if (!count.booleanValue() && pageable != null) {
            query.setParameter("limit", (Object)pageable.getPageSize());
            query.setParameter("offset", (Object)pageable.getOffset());
        }
        return query;
    }

    @Transactional(readOnly=true)
    public List<ProducaoDTO> getProducao(EstruturaUsuario eu, ProducaoPainel producaoPainel, String dataInicial, String dataFinal, HierarquiaDTO usuarioFiltro, Set<Long> equipe, Set<EstruturaSenhas> senha, ProducaoReturnType prt, Boolean ignoraHierarquia) {
        Query query = this.getQuery(eu, producaoPainel, dataInicial, dataFinal, usuarioFiltro, equipe, senha, prt, null, null, ignoraHierarquia);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<ProducaoExportacaoDTO> getProducaoExportacao(EstruturaUsuario eu, ProducaoPainel producaoPainel, String dataInicial, String dataFinal, HierarquiaDTO usuarioFiltro, Set<Long> equipe, Set<EstruturaSenhas> senha, ProducaoReturnType prt, LocalDateTime dataHoraInicioCarga, LocalDateTime dataHoraFimCarga, Boolean ignoraHierarquia) {
        Query query = this.getQuery(eu, producaoPainel, dataInicial, dataFinal, usuarioFiltro, equipe, senha, prt, dataHoraInicioCarga, dataHoraFimCarga, ignoraHierarquia);
        return query.getResultList();
    }

    private Query getQuery(EstruturaUsuario eu, ProducaoPainel producaoPainel, String dataInicial, String dataFinal, HierarquiaDTO usuarioFiltro, Set<Long> equipe, Set<EstruturaSenhas> senha, ProducaoReturnType prt, LocalDateTime dataHoraInicioCarga, LocalDateTime dataHoraFimCarga, Boolean ignoraHierarquia) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT (select uuid_short()) as id,");
        if (prt.equals((Object)ProducaoReturnType.GERAL)) {
            sql.append("     producao_linhas.nome AS nome_linha,");
            sql.append("     producao_colunas.nome AS nome_coluna,");
        } else if (prt.equals((Object)ProducaoReturnType.USUARIO)) {
            sql.append("     if (usuario.nome is null,'NAO DEFINIDO',usuario.nome) AS nome_linha,");
            sql.append("     producao_linhas.nome AS nome_coluna,");
        } else if (prt.equals((Object)ProducaoReturnType.EQUIPE)) {
            sql.append("     if (equipe.nome is null,'NAO DEFINIDO',equipe.nome) AS nome_linha,");
            sql.append("     producao_linhas.nome AS nome_coluna,");
        } else if (prt.equals((Object)ProducaoReturnType.CIDADE)) {
            sql.append("     if (mailing.cidade is null or mailing.estado is null,'NAO DEFINIDO',concat(mailing.cidade,'-',mailing.estado)) AS nome_linha,");
            sql.append("     producao_linhas.nome AS nome_coluna,");
        } else if (prt.equals((Object)ProducaoReturnType.ESTADO)) {
            sql.append("     if (mailing.estado is null,'NAO DEFINIDO',mailing.estado) AS nome_linha,");
            sql.append("     producao_linhas.nome AS nome_coluna,");
        } else if (prt.equals((Object)ProducaoReturnType.DDD)) {
            sql.append("     if (mailing.ddd is null,'NAO DEFINIDO',mailing.ddd) AS nome_linha,");
            sql.append("     producao_linhas.nome AS nome_coluna,");
        } else if (prt.equals((Object)ProducaoReturnType.LOGIN)) {
            sql.append("     if (pedido.login_operadora is null,'NAO DEFINIDO',pedido.login_operadora) AS nome_linha,");
            sql.append("     producao_linhas.nome AS nome_coluna,");
        } else if (prt.equals((Object)ProducaoReturnType.EXPORTACAO)) {
            sql.append("     pedido.id pedido_id,");
            sql.append("     producao_colunas.id as coluna_id, producao_colunas.nome AS nome_coluna,");
            sql.append("     producao_linhas.id as linha_id, producao_linhas.nome AS nome_linha,");
            sql.append("     produto.soma_quantidade,");
            sql.append("     cliente.id cliente_id,");
            sql.append("     pedido.numero as numero_pedido,pedido.numero_pedido_origem,pedido.numero_pedido_vinculado,pedido.tipo_negociacao,pedido.atividades,");
            sql.append("     pedido.data_cadastro,pedido.data_hora_atualizacao,pedido.nome_consultor_operadora,pedido.notas_fiscais,pedido.revisao,pedido.login_operadora,");
            sql.append("     cliente.nome as nome_cliente,cliente.cpf_cnpj,if (mailing.cidade is null,cliente.cidade,mailing.cidade) cidade,");
            sql.append("     if (mailing.estado is null,cliente.estado,mailing.estado) estado,mailing.ddd,");
            sql.append("     if (mailing.cep is null,cliente.cep,mailing.cep) cep,");
            sql.append("     equipe.id equipe_id,");
            sql.append("     equipe.nome AS nome_equipe,");
            sql.append("     concat(pedido_etapa.nome,' (',pedido_origem_etapa.nome,')') as nome_etapa,");
            sql.append("     pedido_item_etapa.nome as nome_etapa_item,");
            sql.append("     pedido_origem.nome as nome_origem,");
            sql.append("     produto.produto_categoria_id,produto.id produto_id,");
            sql.append("     produto_categoria.nome nome_categoria,");
            sql.append("     produto.nome as nome_produto,");
            sql.append("     pedido_item.id item_id,");
            sql.append("     pedido_item.data_referencia,pedido_item.item,pedido_item.data_portabilidade,");
            sql.append("     pedido_item.pedido_item_solicitacao_id,pedido_item.numero AS numero_telefone_item,");
            sql.append("     estrutura_usuario.id estrutura_usuario_id,");
            sql.append("     usuario.nome as nome_usuario,usuario.tags usuario_tags,usuario.login login_usuario,");
            sql.append("     uAdm.nome as nome_usuario_adm,pedido.tags,pedido.percentual_desconto,pedido.percentual_troca,pedido.cluster_origem,");
            sql.append("     pedido_item_solicitacao.id solicitacao_id,pedido.aparelho_cartao_credito,");
            sql.append("     pedido_item_solicitacao.nome nome_solicitacao,");
            sql.append("     pedido_item.quantidade,pedido_item.valor_unitario,pedido_item.desconto_por_item valor_desconto,");
            sql.append("     if (pedido_item.quantidade=0,pedido_item.valor_unitario-pedido_item.desconto_por_item,");
            sql.append("     pedido_item.quantidade*(pedido_item.valor_unitario-pedido_item.desconto_por_item)) as valor,");
            sql.append("     pedido_item.data_instalacao,pedido_item.periodo,pedido_item.rpon,pedido_item.instancia,endereco.cidade cidade_instalacao,endereco.estado estado_instalacao,");
            sql.append("     pedido.codigo_portabilidade,pedido.cotacao,pedido_item.numero_provisorio,pedido.numero_simulacao,");
            sql.append("     pedido_categoria.nome categoria_atividade,pedido_sub_categoria.nome sub_categoria_atividade,");
            sql.append("     dados.operadora_cedente,dados.nome_cedente,dados.telefone_cedente,dados.email_cedente,dados.cpf_cnpj_cedente,");
            sql.append("     pedido_item.valor_base_atual,pedido_item.valor_agregado");
        } else {
            return null;
        }
        if (!prt.equals((Object)ProducaoReturnType.EXPORTACAO)) {
            sql.append("    if (produto.soma_quantidade=1,pedido_item.quantidade,0) quantidade,");
            sql.append("    if (pedido_item.quantidade=0,pedido_item.valor_unitario-pedido_item.desconto_por_item,");
            sql.append("    pedido_item.quantidade*(pedido_item.valor_unitario-pedido_item.desconto_por_item)) as valor,");
            sql.append("    producao_linhas.posicao_linha,producao_colunas.posicao_coluna");
        }
        sql.append(" FROM");
        sql.append(" pedido");
        sql.append(" join pedido_item on (pedido.id = pedido_item.pedido_id)");
        sql.append(" left join pedido_item_dados dados on (pedido_item.id=dados.pedido_item_id)");
        sql.append(" join produto on (pedido_item.produto_id=produto.id)");
        sql.append(" join produto_categoria on (produto.produto_categoria_id=produto_categoria.id)");
        sql.append(" join producao_painel on (producao_painel.id=:producaoPainelId)");
        sql.append(" join producao_colunas on (producao_colunas.producao_painel_id = producao_painel.id)");
        sql.append(" join producao_pedido_etapa on (producao_colunas.id = producao_pedido_etapa.producao_colunas_id)");
        sql.append(" join producao_pedido_item_etapa on (producao_colunas.id = producao_pedido_item_etapa.producao_colunas_id)");
        sql.append(" join producao_linhas on (producao_linhas.producao_painel_id = producao_painel.id)");
        sql.append(" join producao_tipo_solicitacao on (producao_linhas.id = producao_tipo_solicitacao.producao_linhas_id)");
        sql.append(" join producao_produtos on (producao_linhas.id = producao_produtos.producao_linhas_id)");
        sql.append(" join estrutura_usuario on (pedido.estrutura_usuario_id = estrutura_usuario.id)");
        if (!ignoraHierarquia.booleanValue()) {
            sql.append(" join hierarquia ON (hierarquia.estrutura_usuario_id=:euId)");
        }
        if (prt.equals((Object)ProducaoReturnType.USUARIO) || prt.equals((Object)ProducaoReturnType.EXPORTACAO)) {
            sql.append(" join usuario on (estrutura_usuario.usuario_id = usuario.id)");
        }
        if (prt.equals((Object)ProducaoReturnType.EQUIPE) || prt.equals((Object)ProducaoReturnType.EXPORTACAO)) {
            sql.append("     left  join  equipe on (estrutura_usuario.equipe_id=equipe.id and equipe.estrutura_id=:estruturaId)");
        }
        if (prt.equals((Object)ProducaoReturnType.CIDADE) || prt.equals((Object)ProducaoReturnType.ESTADO) || prt.equals((Object)ProducaoReturnType.DDD) || prt.equals((Object)ProducaoReturnType.EXPORTACAO)) {
            sql.append(" join cliente on (pedido.cliente_id = cliente.id)");
            sql.append(" left join  mailing on (cliente.cpf_cnpj = mailing.cpf_cnpj)");
        }
        if (prt.equals((Object)ProducaoReturnType.EXPORTACAO)) {
            sql.append(" join pedido_etapa on (pedido.pedido_etapa_id = pedido_etapa.id and pedido_etapa.estrutura_id=:estruturaId )");
            sql.append(" join pedido_item_etapa on (pedido_item.pedido_item_etapa_id = pedido_item_etapa.id)");
            sql.append(" join pedido_item_solicitacao on (pedido_item.pedido_item_solicitacao_id=pedido_item_solicitacao.id)");
            sql.append(" join pedido_origem on (pedido.pedido_origem_id = pedido_origem.id)");
            sql.append(" join pedido_origem pedido_origem_etapa on (pedido_etapa.pedido_origem_id = pedido_origem_etapa.id)");
            sql.append(" left join estrutura_usuario euAdm on (pedido.estrutura_usuario_adm_id = euAdm.id and euAdm.estrutura_id=:estruturaId )");
            sql.append(" left join usuario uAdm on (euAdm.usuario_id = uAdm.id)");
            sql.append(" left join endereco on (pedido_item.endereco_id=endereco.id)");
            sql.append("     left join pedido_categoria on (pedido.pedido_categoria_id=pedido_categoria.id)");
            sql.append("     left join pedido_sub_categoria on (pedido.pedido_sub_categoria_id=pedido_sub_categoria.id)");
        }
        sql.append(" WHERE estrutura_usuario.estrutura_id=:estruturaId ");
        if (prt.equals((Object)ProducaoReturnType.USUARIO) || prt.equals((Object)ProducaoReturnType.EXPORTACAO)) {
            sql.append("     AND estrutura_usuario.usuario_id=usuario.id");
        }
        if (prt.equals((Object)ProducaoReturnType.CIDADE) || prt.equals((Object)ProducaoReturnType.ESTADO) || prt.equals((Object)ProducaoReturnType.DDD) || prt.equals((Object)ProducaoReturnType.EXPORTACAO)) {
            sql.append("     AND cliente.estrutura_id=:estruturaId");
        }
        if (prt.equals((Object)ProducaoReturnType.EXPORTACAO)) {
            sql.append("     AND pedido_etapa.estrutura_id=:estruturaId");
            sql.append("     AND pedido_item_etapa.estrutura_id=:estruturaId");
            sql.append("     AND produto.estrutura_tipo_id=:estruturaTipoId");
        }
        sql.append("         AND producao_painel.estrutura_id=:estruturaId");
        if (dataHoraInicioCarga != null || dataHoraFimCarga != null) {
            sql.append(" AND pedido.data_hora_atualizacao  >=:dataHoraInicioCarga");
            if (dataHoraFimCarga != null) {
                sql.append(" AND pedido.data_hora_atualizacao  <=:dataHoraFimCarga");
            }
        } else {
            sql.append("         AND ((producao_colunas.considerar_data = 0 and pedido.data_hora_atualizacao>='").append(LocalDate.now().minusMonths(2L)).append("')");
            sql.append("         OR pedido_item.data_referencia >=").append(":dataInicial");
            sql.append("         AND pedido_item.data_referencia <=").append(":dataFinal").append(")");
        }
        if (!ignoraHierarquia.booleanValue()) {
            sql.append("         and estrutura_usuario.id=hierarquia.estrutura_usuario_filho_id");
        }
        sql.append("         AND pedido_item.considerar_producao = 1");
        sql.append("         AND pedido.pedido_etapa_id = producao_pedido_etapa.pedido_etapa_id");
        sql.append("         AND pedido_item.pedido_item_etapa_id = producao_pedido_item_etapa.pedido_item_etapa_id");
        sql.append("         AND pedido_item.produto_id = producao_produtos.produto_id");
        sql.append("         AND pedido_item.pedido_item_solicitacao_id = producao_tipo_solicitacao.pedido_item_solicitacao_id");
        if (usuarioFiltro != null) {
            sql.append("     AND estrutura_usuario.id=").append(usuarioFiltro.getEstruturaUsuarioId());
        }
        if (equipe != null && !equipe.isEmpty()) {
            sql.append("     AND estrutura_usuario.equipe_id in  :equipe");
        }
        if (senha != null && !senha.isEmpty()) {
            sql.append("     AND pedido.login_operadora in :senhas");
        }
        Query query = prt.equals((Object)ProducaoReturnType.EXPORTACAO) ? this.manager.createNativeQuery(sql.toString(), ProducaoExportacaoDTO.class) : this.manager.createNativeQuery(sql.toString(), ProducaoDTO.class);
        if (dataHoraInicioCarga != null || dataHoraFimCarga != null) {
            query.setParameter("dataHoraInicioCarga", (Object)dataHoraInicioCarga);
            if (dataHoraFimCarga != null) {
                query.setParameter("dataHoraFimCarga", (Object)dataHoraFimCarga);
            }
        } else {
            query.setParameter("dataInicial", (Object)dataInicial);
            query.setParameter("dataFinal", (Object)dataFinal);
        }
        if (!ignoraHierarquia.booleanValue()) {
            query.setParameter("euId", (Object)eu.getId());
        }
        query.setParameter("producaoPainelId", (Object)producaoPainel.getId());
        query.setParameter("estruturaId", (Object)eu.getEstrutura().getId());
        if (equipe != null && !equipe.isEmpty()) {
            query.setParameter("equipe", equipe);
        }
        if (senha != null && !senha.isEmpty()) {
            HashSet<String> senhas = new HashSet<String>();
            for (EstruturaSenhas s : senha) {
                senhas.add(s.getNome());
            }
            query.setParameter("senhas", senhas);
        }
        if (prt.equals((Object)ProducaoReturnType.EXPORTACAO)) {
            query.setParameter("estruturaTipoId", (Object)eu.getEstrutura().getEstruturaTipo().getId());
        }
        return query;
    }

    @Transactional(readOnly=true)
    public List<ProducaoProdutoDTO> getProdutosPainel(ProducaoPainel painel) {
        String sql = "select (select uuid_short()) as id,producao_produtos.produto_id ,producao_produtos.producao_linhas_id linha_id  from producao_produtos,producao_linhas\n where producao_produtos.producao_linhas_id=producao_linhas.id\n and producao_linhas.producao_painel_id=:painelId";
        Query query = this.manager.createNativeQuery(sql, ProducaoProdutoDTO.class);
        query.setParameter("painelId", (Object)painel.getId());
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<ProducaoEtapaDTO> getEtapasPainel(ProducaoPainel painel) {
        String sql = "select (select uuid_short()) as id,producao_pedido_etapa.pedido_etapa_id etapa_id ,producao_pedido_etapa.producao_colunas_id coluna_id  from producao_pedido_etapa,producao_colunas\n where producao_pedido_etapa.producao_colunas_id=producao_colunas.id\n and producao_colunas.producao_painel_id=:painelId";
        Query query = this.manager.createNativeQuery(sql, ProducaoEtapaDTO.class);
        query.setParameter("painelId", (Object)painel.getId());
        return query.getResultList();
    }
}

