/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.service;

import br.com.system.app.features.cep.model.Ddd;
import br.com.system.app.features.cep.repository.DddRepository;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaTipoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.pedido.model.PedidoItemSolicitacao;
import br.com.system.app.features.producaopainel.dto.ProducaoExportacaoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoReturnType;
import br.com.system.app.features.producaopainel.model.ProducaoIntegracaoLog;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.repository.ProducaoPainelRepository;
import br.com.system.app.features.producaopainel.service.ProducaoIntegracaoLogService;
import br.com.system.app.features.producaopainel.service.ProducaoPainelService;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProducaoPainelIntegrationV2
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private DddRepository dddRepository;
    @Autowired
    private EstruturaTipoService ets;
    @Autowired
    private ProducaoPainelRepository ppr;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private ProducaoPainelService painelService;
    @Autowired
    private ProducaoIntegracaoLogService pils;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;
    @Autowired
    private UsuarioService usuarioService;

    public void doIntegration(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setCharacterEncoding("UTF-8");
        }
        catch (IOException e) {
            return;
        }
        try {
            String strOut;
            long minutes;
            String body = InputStreamUtil.toString((InputStream)request.getInputStream());
            if (body.isEmpty()) {
                out.print(this.example());
                return;
            }
            JSONObject jsonBody = new JSONObject(body);
            EstruturaComplemento estruturaCompl = this.estruturaComplementoService.getByTokenIntegration(jsonBody.getString("tokenEstrutura"));
            if (estruturaCompl == null) {
                this.printErro("Token Estrutura Inv\u00e1lido", out);
                return;
            }
            Usuario u = this.usuarioService.getByIntegrationToken(jsonBody.getString("tokenUsuario"));
            if (u == null) {
                this.printErro("Token usuario Inv\u00e1lido", out);
                this.pils.create(estruturaCompl.getEstrutura(), jsonBody.toString(), Integer.valueOf(0), false, "tokenn usuario invalido");
                return;
            }
            EstruturaUsuario eu = (EstruturaUsuario)this.eus.getByUsuarioAndEstrutura(u, estruturaCompl.getEstrutura()).get();
            LocalTime agora = LocalTime.now();
            LocalDateTime dataHoraInicioCarga = DateTimeUtil.toDateTime((String)jsonBody.getString("dataHoraInicioCarga"), (FormatDate)FormatDate.US_DATETIME);
            LocalDateTime dataHoraFimCarga = !jsonBody.has("dataHoraFimCarga") ? LocalDateTime.now() : DateTimeUtil.toDateTime((String)jsonBody.getString("dataHoraFimCarga"), (FormatDate)FormatDate.US_DATETIME);
            if (!DateTimeUtil.isOpen((LocalTime)LocalTime.of(22, 0), (LocalTime)LocalTime.of(5, 0), (LocalTime)agora) && (minutes = ChronoUnit.MINUTES.between(dataHoraInicioCarga, dataHoraFimCarga)) > 90L) {
                this.printErro("Entre 05:00 e 22:00 periodo m\u00e1ximo de pesquisa \u00e9 90 minutos", out);
                return;
            }
            Estrutura estrutura = eu.getEstrutura();
            ProducaoIntegracaoLog pil = this.pils.create(estrutura, jsonBody.toString(), Integer.valueOf(0), true, jsonBody.getString("tokenEstrutura"));
            ProducaoPainel painel = this.painelService.getById(Long.valueOf(jsonBody.getString("painelId")));
            List lista = this.ppr.getProducaoExportacao(eu, painel, null, null, null, null, null, ProducaoReturnType.EXPORTACAO, dataHoraInicioCarga, dataHoraFimCarga, Boolean.valueOf(false));
            if (jsonBody.has("outputFormat") && jsonBody.getString("outputFormat").equals("json")) {
                response.setContentType("application/json");
                strOut = this.getJson(lista, estruturaCompl.getEstrutura(), painel);
            } else {
                response.setContentType("text/csv");
                strOut = this.getCsv(lista, estruturaCompl.getEstrutura(), eu, painel);
            }
            out.print(strOut);
            pil.setRegistros(Integer.valueOf(lista.size()));
            this.pils.save(pil);
        }
        catch (Exception e) {
            this.printErro(e.getMessage(), out);
        }
    }

    private void printErro(String msg, PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)msg);
        out.print(jsonRetorno.toString());
    }

    private String getField(String field) {
        if (field == null) {
            return "";
        }
        return field.trim();
    }

    private String getDate(LocalDate dataBanco) {
        return dataBanco == null ? "" : dataBanco.format(FormatDate.DATE_BR.toDTF());
    }

    private String getDateTime(LocalDateTime dataHoraBanco) {
        return dataHoraBanco == null ? "" : dataHoraBanco.format(FormatDate.DATETIME_BR.toDTF());
    }

    private String getDDD(ProducaoExportacaoDTO ped) {
        Ddd ddd;
        if ((ped.getDdd() == null || ped.getDdd().isEmpty() || ped.getDdd().equals("0")) && (ddd = this.dddRepository.findFirstByEstadoAndCidade(ped.getEstado(), ped.getCidade())) != null && ddd.getDdd() > 0) {
            return ddd.getDdd().toString();
        }
        return ped.getDdd();
    }

    private String example() {
        return "<html><head><title>Integra\u00e7\u00e3o Painel de Produ\u00e7\u00e3o- BI</title></head><body><div><p ><img src=\"images/logos/neo-200.png\"></p>\n<h4 ><strong><u>Integra\u00e7\u00e3o Painel de Produ\u00e7\u00e3o- BI</u></strong></h4>\n<ul>\n <li>method - POST</li>\n <li>tokenEstrutura - Obrigat\u00f3rio</li>\n <li>tokenUsuario - Obrigat\u00f3rio</li>\n <li>dataHoraInicioCarga - Obrigat\u00f3rio</li>\n <li>dataHoraFimCarga - N\u00e3o Obrigat\u00f3rio</li>\n <li>painelId - Obrigat\u00f3rio</li>\n <li>outputFormat - (json ou csv)Obrigat\u00f3rio</li>\n</ul>\n<p>Json Body :</p>\n<pre>{\n       \"tokenEstrutura\":\"SOLICITE_SEU_TOKEN_AO_SUPORTE\",\n       \"tokenUsuario\":\"SOLICITE_SEU_TOKEN_AO_SUPORTE\",\n       \"dataHoraInicioCarga\":\"2022-04-01 00:00:00\",\n       \"dataHoraFimCarga\":\"2022-04-31 00:00:00\",\n       \"painelId\":\"SOLICITE_AO_SUPORTE\",\n       \"outputFormat\":\"csv\"}\n</pre>\n<p style=\"text-align: center\"><br></p></div></body></html>";
    }

    private String getJson(List<ProducaoExportacaoDTO> lista, Estrutura estrutura, ProducaoPainel painel) {
        JSONArray arr = new JSONArray();
        for (ProducaoExportacaoDTO ped : lista) {
            JSONObject j = new JSONObject();
            j.put("estruturaNome", (Object)estrutura.getNome());
            j.put("numeroLinha", (Object)ped.getNomeLinha());
            j.put("nomeColuna", (Object)ped.getNomeColuna());
            j.put("numeroPedido", (Object)this.getField(ped.getNumeroPedido()));
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                j.put("numeroPedidoVinculado", (Object)this.getField(ped.getNumeroPedidoVinculado()));
            }
            if (this.ets.isVivo(painel.getEstrutura())) {
                j.put("numeroPedidoOrigem", (Object)this.getField(ped.getNumeroPedidoOrigem()));
            }
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                j.put("loginOperadora", (Object)this.getField(ped.getLoginOperadora()));
            }
            j.put("clienteId", (Object)ped.getClienteId());
            j.put("nomeCliente", (Object)this.getField(ped.getNomeCliente()));
            j.put("cpfCnpj", (Object)this.getField(ped.getCpfCnpj()));
            j.put("pjOuPf", (Object)(ped.getCpfCnpj().length() == 14 ? "PJ" : "PF"));
            j.put("cidade", (Object)this.getField(ped.getCidade()));
            j.put("estado", (Object)this.getField(ped.getEstado()));
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                j.put("ddd", (Object)this.getDDD(ped));
            }
            j.put("estruturaUsuarioId", (Object)ped.getEstruturaUsuarioId());
            j.put("nomeUsuario", (Object)this.getField(ped.getNomeUsuario()));
            j.put("tagUsuario", (Object)this.getField(ped.getUsuarioTags()));
            j.put("nomeUsuarioAdm", (Object)this.getField(ped.getNomeUsuarioAdm()));
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                j.put("nomeConsultorOperadora", (Object)this.getField(ped.getNomeConsultorOperadora()));
            }
            j.put("equipeId", (Object)ped.getEquipeId());
            j.put("nomeEquipe", (Object)this.getField(ped.getNomeEquipe()));
            j.put("nomeEtapa", (Object)this.getField(ped.getNomeEtapa()));
            j.put("dataCadastro", (Object)this.getDate(ped.getDataCadastro()));
            j.put("dataHoraAtualizacao", (Object)this.getDateTime(ped.getDataHoraAtualizacao()));
            j.put("solicitacaoId", (Object)ped.getSolicitacaoId());
            j.put("solicitacao", (Object)PedidoItemSolicitacao.getStaticName((Long)ped.getPedidoItemSolicitacaoId()));
            j.put("itemId", (Object)ped.getItemId());
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                j.put("tipoNegociacao", (Object)this.getField(ped.getTipoNegociacao()));
                j.put("notasFiscais", (Object)this.getField(ped.getNotasFiscais()));
                j.put("revisao", (Object)this.getField(ped.getRevisao()));
                j.put("item", (Object)this.getField(ped.getItem()));
                j.put("numeroTelefoneItem", (Object)this.getField(ped.getNumeroTelefoneItem()));
            }
            j.put("nomeEtapaItem", (Object)this.getField(ped.getNomeEtapaItem()));
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                j.put("dataPortabilidade", (Object)this.getDate(ped.getDataPortabilidade()));
            }
            j.put("produtoId", (Object)ped.getProdutoId());
            j.put("produtoCategoriaId", (Object)ped.getProdutoCategoriaId());
            j.put("produtoCategoriaNome", (Object)ped.getNomeCategoria());
            j.put("nomeProduto", (Object)this.getField(ped.getNomeProduto()));
            j.put("valor", (Object)ped.getValor().toString().replace(".", ","));
            j.put("quantidade", ped.getSomaQuantidade() != false ? ped.getQuantidade() : 0);
            j.put("dataReferencia", (Object)this.getDate(ped.getDataReferencia()));
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                j.put("nomeOrigem", (Object)this.getField(ped.getNomeOrigem()));
                j.put("dataInstalacao", (Object)this.getDate(ped.getDataInstalacao()));
                j.put("periodoInstalacao", (Object)this.getField(ped.getPeriodo()));
                j.put("cidadeInstalacao", (Object)this.getField(ped.getCidadeInstalacao()));
                j.put("estadoInstalacao", (Object)this.getField(ped.getEstadoInstalacao()));
            }
            if (this.ets.isVivo(painel.getEstrutura())) {
                j.put("rpon", (Object)this.getField(ped.getRpon()));
                j.put("instancia", (Object)this.getField(ped.getInstancia()));
            }
            if (this.ets.isClaro(painel.getEstrutura())) {
                j.put("percDesconto", ped.getPercentualDesconto() == null ? Double.valueOf(0.0) : ped.getPercentualDesconto().toString().replace(".", ","));
                j.put("percTroca", ped.getPercentualTroca() == null ? Double.valueOf(0.0) : ped.getPercentualTroca().toString().replace(".", ","));
                j.put("cluster", (Object)this.getField(ped.getClusterOrigem()));
            }
            j.put("tagPedido", (Object)this.getField(ped.getTags()));
            arr.put((Object)j);
        }
        return arr.toString();
    }

    private String getCabecalho(Estrutura estrutura) {
        StringBuilder str = new StringBuilder();
        str.append("\"Nome Linha\"");
        str.append(";\"").append("Nome Coluna\"");
        str.append(";\"").append("N\u00famero Pedido\"");
        if (this.ets.isTelefonia(estrutura)) {
            str.append(";\"").append("Pedido Vinculado\"");
        }
        if (this.ets.isVivo(estrutura)) {
            str.append(";\"").append("Pedido Origem\"");
        }
        if (this.ets.isTelefonia(estrutura)) {
            str.append(";\"").append("Login Operadora\"");
        }
        str.append(";\"").append("Nome Cliente\"");
        str.append(";\"").append("Cidade\"");
        str.append(";\"").append("PJ ou PF\"");
        str.append(";\"").append("Estado\"");
        if (this.ets.isTelefonia(estrutura)) {
            str.append(";\"").append("DDD\"");
        }
        str.append(";\"").append("Usu\u00e1rio Propriet\u00e1rio\"");
        str.append(";\"").append("Usu\u00e1rio Tags\"");
        str.append(";\"").append("Usu\u00e1rio ADM\"");
        if (this.ets.isTelefonia(estrutura)) {
            str.append(";\"").append("Consultor na Operadora\"");
        }
        str.append(";\"").append("Nome Equipe\"");
        str.append(";\"").append("Nome Etapa\"");
        str.append(";\"").append("Data Cadastro\"");
        str.append(";\"").append("Data Atualizacao\"");
        str.append(";\"").append("Solicita\u00e7\u00e3o\"");
        if (this.ets.isTelefonia(estrutura)) {
            str.append(";\"").append("Tipo Negociacao\"");
            str.append(";\"").append("Notas Fiscais\"");
            str.append(";\"").append("Revis\u00e3o\"");
            str.append(";\"").append("Item\"");
            str.append(";\"").append("Numero\"");
        }
        str.append(";\"").append("Etapa Item\"");
        if (this.ets.isTelefonia(estrutura)) {
            str.append(";\"").append("Portabilidade\"");
        }
        str.append(";\"").append("PRoduto\"");
        if (this.ets.isTicket(estrutura)) {
            str.append(";\"").append("Numero\"");
            str.append(";\"").append("Valor Unitario\"");
            str.append(";\"").append("Valor Desconto\"");
            str.append(";\"").append("Quantidade\"");
            str.append(";\"").append("Valor\"");
        } else {
            str.append(";\"").append("Valor\"");
            str.append(";\"").append("Quantidade\"");
        }
        str.append(";\"").append("Data Referencia\"");
        if (this.ets.isTelefonia(estrutura)) {
            str.append(";\"").append("Origem\"");
            str.append(";\"").append("Data Instala\u00e7\u00e3o\"");
            str.append(";\"").append("Per\u00edodo\"");
            str.append(";\"").append("Cidade Instala\u00e7\u00e3o\"");
            str.append(";\"").append("Estado Instala\u00e7\u00e3o\"");
        }
        if (this.ets.isVivo(estrutura)) {
            str.append(";\"").append("Rpon\"");
            str.append(";\"").append("Inst\u00e2ncia\"");
        }
        if (this.ets.isClaro(estrutura)) {
            str.append(";\"").append("% Desconto\"");
            str.append(";\"").append("% Troca\"");
            str.append(";\"").append("Cluster\"");
        }
        str.append(";\"").append("Tags\"");
        str.append("\n");
        return str.toString();
    }

    public String getCsv(List<ProducaoExportacaoDTO> lista, Estrutura estrutura, EstruturaUsuario eu, ProducaoPainel painel) {
        StringBuilder str = new StringBuilder();
        str.append(this.getCabecalho(estrutura));
        for (ProducaoExportacaoDTO ped : lista) {
            str.append("\"").append(ped.getNomeLinha()).append("\"");
            str.append(";\"").append(ped.getNomeColuna()).append("\"");
            str.append(";\"").append(this.getField(ped.getNumeroPedido())).append("\"");
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                str.append(";\"").append(this.getField(ped.getNumeroPedidoVinculado())).append("\"");
            }
            if (this.ets.isVivo(painel.getEstrutura())) {
                str.append(";\"").append(this.getField(ped.getNumeroPedidoOrigem())).append("\"");
            }
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                str.append(";\"").append(this.getField(ped.getLoginOperadora())).append("\"");
            }
            str.append(";\"").append(this.getField(ped.getNomeCliente())).append("\"");
            str.append(";\"").append(this.getField(ped.getCpfCnpj())).append("\"");
            str.append(";\"").append(ped.getCpfCnpj().length() == 14 ? "PJ" : "PF").append("\"");
            str.append(";\"").append(this.getField(ped.getCidade())).append("\"");
            str.append(";\"").append(this.getField(ped.getEstado())).append("\"");
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                str.append(";\"").append(this.getDDD(ped)).append("\"");
            }
            str.append(";\"").append(this.getField(ped.getNomeUsuario())).append("\"");
            str.append(";\"").append(this.getField(ped.getUsuarioTags())).append("\"");
            str.append(";\"").append(this.getField(ped.getNomeUsuarioAdm())).append("\"");
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                str.append(";\"").append(this.getField(ped.getNomeConsultorOperadora())).append("\"");
            }
            str.append(";\"").append(this.getField(ped.getNomeEquipe())).append("\"");
            str.append(";\"").append(this.getField(ped.getNomeEtapa())).append("\"");
            str.append(";\"").append(this.getDate(ped.getDataCadastro())).append("\"");
            str.append(";\"").append(this.getDateTime(ped.getDataHoraAtualizacao())).append("\"");
            str.append(";\"").append(PedidoItemSolicitacao.getStaticName((Long)ped.getPedidoItemSolicitacaoId())).append("\"");
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                str.append(";\"").append(this.getField(ped.getTipoNegociacao())).append("\"");
                str.append(";\"").append(this.getField(ped.getNotasFiscais())).append("\"");
                str.append(";\"").append(this.getField(ped.getRevisao())).append("\"");
                str.append(";\"").append(this.getField(ped.getItem())).append("\"");
                str.append(";\"").append(this.getField(ped.getNumeroTelefoneItem())).append("\"");
            }
            str.append(";\"").append(this.getField(ped.getNomeEtapaItem())).append("\"");
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                str.append(";\"").append(this.getDate(ped.getDataPortabilidade())).append("\"");
            }
            str.append(";\"").append(this.getField(ped.getNomeProduto())).append("\"");
            if (this.ets.isTicket(painel.getEstrutura())) {
                str.append(";\"").append(this.getField(ped.getNumeroTelefoneItem())).append("\"");
                str.append(";\"").append(ped.getValorUnitario().toString().replace(".", ",")).append("\"");
                str.append(";\"").append(ped.getValorDesconto().toString().replace(".", ",")).append("\"");
                str.append(";\"").append(ped.getSomaQuantidade() != false ? ped.getQuantidade() : 0).append("\"");
                str.append(";\"").append(ped.getValor().toString().replace(".", ",")).append("\"");
            } else {
                str.append(";\"").append(ped.getValor().toString().replace(".", ",")).append("\"");
                str.append(";\"").append(ped.getSomaQuantidade() != false ? ped.getQuantidade() : 0).append("\"");
            }
            str.append(";\"").append(this.getDate(ped.getDataReferencia())).append("\"");
            if (this.ets.isTelefonia(painel.getEstrutura())) {
                str.append(";\"").append(this.getField(ped.getNomeOrigem())).append("\"");
                str.append(";\"").append(this.getDate(ped.getDataInstalacao())).append("\"");
                str.append(";\"").append(this.getField(ped.getPeriodo())).append("\"");
                str.append(";\"").append(this.getField(ped.getCidadeInstalacao())).append("\"");
                str.append(";\"").append(this.getField(ped.getEstadoInstalacao())).append("\"");
            }
            if (this.ets.isVivo(painel.getEstrutura())) {
                str.append(";\"").append(this.getField(ped.getRpon())).append("\"");
                str.append(";\"").append(this.getField(ped.getInstancia())).append("\"");
            }
            if (this.ets.isClaro(painel.getEstrutura())) {
                str.append(";\"").append(ped.getPercentualDesconto() == null ? Double.valueOf(0.0) : ped.getPercentualDesconto().toString().replace(".", ",")).append("\"");
                str.append(";\"").append(ped.getPercentualTroca() == null ? Double.valueOf(0.0) : ped.getPercentualTroca().toString().replace(".", ",")).append("\"");
                str.append(";\"").append(this.getField(ped.getClusterOrigem())).append("\"");
            }
            str.append(";\"").append(this.getField(ped.getTags())).append("\"");
            str.append("\n");
        }
        return str.toString();
    }
}

