/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.views;

import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.model.EstruturaSenhas;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaSenhasService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.producaopainel.dto.ProducaoReturnType;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.service.ProducaoPainelService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;

public class ProducaoPainelFilter
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ProducaoPainelService pps;
    private final EstruturaUsuario eu;
    private final EquipeService es;
    private final EstruturaSenhasService ess;
    private final UsuarioHierarquiaService hierarquiaService;
    private Button btnPesquisar;
    private DatePicker dataInicial;
    private DatePicker dataFinal;
    private ComboBox<ProducaoPainel> cbPainel;
    private ComboBox<HierarquiaDTO> cbUsuarioFilter;
    private MultiComboBox<EstruturaSenhas> cbSenhas;
    private MultiComboBox<Equipe> cbEquipe;
    private RadioButtonGroup<ProducaoReturnType> rbg;

    public ComboBox<HierarquiaDTO> getCbUsuarioFilter() {
        return this.cbUsuarioFilter;
    }

    public MultiComboBox<EstruturaSenhas> getCbSenhas() {
        return this.cbSenhas;
    }

    public MultiComboBox<Equipe> getCbEquipe() {
        return this.cbEquipe;
    }

    public DatePicker getDataInicial() {
        return this.dataInicial;
    }

    public DatePicker getDataFinal() {
        return this.dataFinal;
    }

    public ComboBox<ProducaoPainel> getCbPainel() {
        return this.cbPainel;
    }

    public RadioButtonGroup<ProducaoReturnType> getRbg() {
        return this.rbg;
    }

    public Button getBtnPesquisar() {
        return this.btnPesquisar;
    }

    public ProducaoPainelFilter(ProducaoPainelService pps, EquipeService es, EstruturaSenhasService ess, EstruturaUsuario eu, UsuarioHierarquiaService hierarquiaService) {
        this.pps = pps;
        this.hierarquiaService = hierarquiaService;
        this.ess = ess;
        this.eu = eu;
        this.es = es;
    }

    public HorizontalContainer createContent() {
        this.dataInicial = new DatePicker();
        this.dataInicial.setLabel("Inicial");
        this.dataInicial.setValue(LocalDate.now().withDayOfMonth(1));
        this.dataInicial.setLocale(UIUtils.getLocale());
        this.dataFinal = new DatePicker();
        this.dataFinal.setLabel("Final");
        this.dataFinal.setValue(LocalDate.now());
        this.dataFinal.setLocale(UIUtils.getLocale());
        List listPainel = this.pps.get(this.getEu());
        this.cbPainel = new ComboBox("Painel", (Collection)listPainel);
        this.cbPainel.setMinWidth("230px");
        this.cbPainel.setItemLabelGenerator(ProducaoPainel::getNome);
        if (listPainel.size() > 0) {
            this.cbPainel.setValue((Object)((ProducaoPainel)listPainel.get(0)));
        }
        this.rbg = new RadioButtonGroup();
        this.rbg.setLabel("Vis\u00e3o");
        if (this.isTicket() || this.isGeneric() || this.isPolo()) {
            this.rbg.setItems((Object[])new ProducaoReturnType[]{ProducaoReturnType.GERAL, ProducaoReturnType.EQUIPE, ProducaoReturnType.USUARIO, ProducaoReturnType.CIDADE, ProducaoReturnType.ESTADO, ProducaoReturnType.EXPORTACAO});
        } else {
            this.rbg.setItems((Object[])new ProducaoReturnType[]{ProducaoReturnType.GERAL, ProducaoReturnType.EQUIPE, ProducaoReturnType.USUARIO, ProducaoReturnType.CIDADE, ProducaoReturnType.ESTADO, ProducaoReturnType.DDD, ProducaoReturnType.LOGIN, ProducaoReturnType.EXPORTACAO});
        }
        this.rbg.setValue((Object)ProducaoReturnType.GERAL);
        UIUtils.setFontSize((FontSize)FontSize.XS, (Component[])new Component[]{this.rbg});
        this.cbUsuarioFilter = new ComboBox("Usu\u00e1rio", (Collection)this.hierarquiaService.getHierarquiaDto(this.getEu(), Boolean.FALSE));
        this.cbUsuarioFilter.setMinWidth("230px");
        this.cbUsuarioFilter.setItemLabelGenerator(HierarquiaDTO::getUsuarioELogin);
        this.cbSenhas = new MultiComboBox("Login", (Collection)this.ess.getAtivosByEstrutura(this.eu.getEstrutura()));
        this.cbSenhas.setItemLabelGenerator(EstruturaSenhas::getNomeAndSistema);
        this.cbSenhas.setVisible(!this.isTicket() && !this.isGeneric() && !this.isPolo());
        this.cbEquipe = new MultiComboBox("Equipe");
        if (this.hasPermission("EQUIPE_VISUALIZACAO_RESTRITA") && !this.isMaster()) {
            if (this.getEu().getEquipe() != null) {
                this.cbEquipe.setItems((Object[])new Equipe[]{this.getEu().getEquipe()});
            }
        } else {
            this.cbEquipe.setItems((Collection)this.es.getEquipes(this.getEstrutura()));
        }
        this.cbEquipe.setItemLabelGenerator(Equipe::getNome);
        this.btnPesquisar = UIUtils.createSmallButton((String)"Pesquisar", (VaadinIcon)VaadinIcon.SEARCH, (String)"");
        this.btnPesquisar.setDisableOnClick(true);
        HorizontalContainer card = new HorizontalContainer(new Component[0]);
        card.add(new Component[]{UIUtils.createHeader((String)"Pesquisar")});
        card.add(new Component[]{this.dataInicial, this.dataFinal, this.cbPainel, this.cbUsuarioFilter, this.cbEquipe, this.cbSenhas, this.btnPesquisar, this.rbg});
        return card;
    }
}

