/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.receitafederal.service;

import br.com.system.app.features.cep.model.CepLocalidade;
import br.com.system.app.features.cep.model.CepTipoLocalidadeEnum;
import br.com.system.app.features.cep.model.CepUf;
import br.com.system.app.features.cep.repository.CepLocalidadeRepository;
import br.com.system.app.features.cep.repository.CepUfRepository;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.cnae.model.Cnae;
import br.com.system.app.features.cnae.repository.CnaeRepository;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.model.MailingAtividade;
import br.com.system.app.features.mailing.model.MailingContato;
import br.com.system.app.features.mailing.model.MailingSocio;
import br.com.system.app.features.mailing.model.MailingSocioTipoEnum;
import br.com.system.app.features.mailing.model.MailingTipoContatoEnum;
import br.com.system.app.features.mailing.projection.MailingLimited;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoTags;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.recaptcha.SouveCaptcha;
import br.com.system.app.features.receitafederal.model.ReceitaAtividade;
import br.com.system.app.features.receitafederal.repository.ReceitaAtividadeRepository;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import br.com.system.commons.jsoup.Document;
import br.com.system.commons.regex.Recognizer;
import br.com.system.integreation.conexaoExterna.ExternalConnection;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReceitaFederalService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private CnaeRepository cnaeRepository;
    @Autowired
    private CepLocalidadeRepository cepLocalidadeRepository;
    @Autowired
    private CepUfRepository cepUfRepository;
    @Autowired
    private ReceitaAtividadeRepository receitaAtividadeRepository;
    @Autowired
    private ConfigurationsService configurationsService;
    @Autowired
    private MailingService mailingService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private PedidoService pedidoService;

    public Integer temLimiteAtividade(Estrutura estrutura) {
        Integer limite = this.configurationsService.get(ConfigurationEnum.LIMITE_DIARIO_RECEITA_ATIVIDADE).getIntValue();
        ReceitaAtividade ra = this.receitaAtividadeRepository.findFirstByEstruturaAndDataCriacao(estrutura, LocalDate.now());
        if (ra == null) {
            return limite;
        }
        return limite - ra.getQuantidade();
    }

    public void gravaLimiteAtividade(EstruturaUsuario eu, int totalLista) {
        ReceitaAtividade ra = this.receitaAtividadeRepository.findFirstByEstruturaAndDataCriacao(eu.getEstrutura(), LocalDate.now());
        if (ra == null) {
            ra = new ReceitaAtividade();
        }
        ra.setDataCriacao(LocalDate.now());
        ra.setEstrutura(eu.getEstrutura());
        ra.setEstruturaUsuario(eu);
        ra.setQuantidade(Integer.valueOf(ra.getQuantidade() == null ? totalLista : ra.getQuantidade() + totalLista));
        this.receitaAtividadeRepository.save((Object)ra);
    }

    public static void main(String[] args) {
        new ReceitaFederalService().getDadosReceita("43974636000147");
    }

    public void distribuirAtividade(List<MailingLimited> lista, EstruturaUsuario eu, PedidoTipoEnum pte, Set<PedidoTags> tags, Set<Long> listaEu, String descricao) {
        Object log = "Resultado";
        ArrayList<Long> u = new ArrayList<Long>(listaEu);
        this.mailingService.registerMailingView(lista, eu);
        int ind = 0;
        Object tagString = "";
        for (PedidoTags pt : tags) {
            tagString = (String)tagString + String.valueOf(pt) + ",";
        }
        tagString = StringUtil.normalizeTags((String)tagString);
        for (MailingLimited m : lista) {
            ind = ind >= u.size() ? 0 : ind;
            EstruturaUsuario euDistribuicao = this.eus.getById((Long)u.get(ind));
            Cliente cliente = this.clienteService.getAndCreateCliente(eu, m.getCnpj(), new ClienteContato[0]);
            if (m.getSituacao().equals("ATIVA") && this.clienteService.souResponsavel(cliente, euDistribuicao, pte, Boolean.valueOf(eu.haveRole("ATIVIDADE_CRIAR_MESMO_ENCARTEIRADO")))) {
                Pedido pedido = this.pedidoService.createPedidoByMailing(euDistribuicao, cliente, m, descricao, (String)tagString, pte);
                ++ind;
                log = (String)log + "CNPJ " + m.getCnpj() + " criado atividade " + pedido.getNumero() + "<br>";
                continue;
            }
            log = (String)log + "CNPJ " + m.getCnpj() + " erro ao criar " + (m.getSituacao().equals("ATIVA") ? " Voc\u00ea n\u00e3o \u00e9 respons\u00e1vel pelo cliente/n" : " Empresa inativa<br>");
        }
        this.gravaLimiteAtividade(eu, lista.size());
        this.notificacoesService.notify(eu, "Resultado cria\u00e7\u00e3o atividades", (String)log);
    }

    public Mailing getDadosReceita(String cnpj) {
        try {
            ExternalConnection conexao = new ExternalConnection();
            conexao.executeGet("https://servicos.receita.fazenda.gov.br/Servicos/cnpjreva/Cnpjreva_Solicitacao.asp?cnpj=" + cnpj);
            String recaptchaResponse = SouveCaptcha.souve((String)"af4fc5a3-1ac5-4e6d-819d-324d412a5e9d", (String)"https://servicos.receita.fazenda.gov.br/Servicos/cnpjreva/Cnpjreva_Solicitacao.asp");
            String html = conexao.addParameter("origem", "comprovante").addParameter("cnpj", cnpj).addParameter("h-captcha-response", recaptchaResponse).addParameter("search_type", "cnpj").executePost("https://servicos.receita.fazenda.gov.br/Servicos/cnpjreva/valida_recaptcha.asp").getReturnedHtml("ISO-8859-1");
            Document htmlSocios = conexao.executeGet("https://servicos.receita.fazenda.gov.br/Servicos/cnpjreva/Cnpjreva_qsa.asp").toJsoupDocumentExtended("ISO-8859-1");
            if (html.contains("No momento no podemos atender a sua solicitao. Por favor tente mais tarde")) {
                throw new BusinessException("Instabilidade nos servidores da receita federal, tente mais tarde");
            }
            return this.trataReceita(html, htmlSocios);
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao pegar dados da receita: " + cnpj + " " + e.getMessage());
        }
    }

    private Mailing trataReceita(String html, Document htmlSocios) {
        CepLocalidade loc;
        Mailing mailing = new Mailing();
        if (!html.contains("N\u00daMERO DE INSCRI\u00c7\u00c3O")) {
            return null;
        }
        mailing.setDataHoraAtualizacao(LocalDateTime.now());
        html = StringUtil.normalize((String)html);
        List retorno1 = this.getJsoup(html, "N\u00daMERO DE INSCRI\u00c7\u00c3O");
        String inscricao = (String)retorno1.get(0);
        if (inscricao.contains("MATRIZ")) {
            mailing.setMatrizFilial("MATRIZ");
        } else {
            mailing.setMatrizFilial("FILIAL");
        }
        mailing.setCpfCnpj(StringUtil.numbersOnly((String)inscricao));
        mailing.setDataAbertura(DateTimeUtil.toDate((String)((String)retorno1.get(1)), (FormatDate)FormatDate.DATE_BR));
        mailing.setNome((String)this.getJsoup(html, "NOME EMPRESARIAL").iterator().next());
        List retorno2 = this.getJsoup(html, "ESTABELECIMENTO");
        mailing.setNomeFantasia((String)retorno2.get(0));
        mailing.setPorte((String)retorno2.get(1));
        mailing.setNaturezaJuridica((String)this.getJsoup(html, "NATUREZA JUR\u00cdDICA").iterator().next());
        List retorno3 = this.getJsoup(html, "LOGRADOURO");
        mailing.setLogradouro(((String)retorno3.get(0)).replace("*", ""));
        mailing.setNumero(((String)retorno3.get(1)).replace("*", ""));
        mailing.setComplemento(((String)retorno3.get(2)).replace("*", ""));
        List retorno4 = this.getJsoup(html, "CEP");
        mailing.setCep(StringUtil.numbersOnly((String)((String)retorno4.get(0))));
        mailing.setBairro(((String)retorno4.get(1)).replace("*", ""));
        mailing.setCidade(((String)retorno4.get(2)).replace("*", ""));
        mailing.setEstado(((String)retorno4.get(3)).replace("*", ""));
        CepUf cepUf = this.cepUfRepository.findBySigla(mailing.getEstado());
        if (cepUf != null && (loc = this.cepLocalidadeRepository.findByUfAndNome(cepUf, mailing.getCidade().replaceAll("-", ""), CepTipoLocalidadeEnum.MUNICIPIO)) != null) {
            mailing.setDdd(Integer.valueOf(StringUtil.toInt((String)loc.getDdd())));
        }
        List retorno6 = this.getJsoup(html, "SITUA\u00c7\u00c3O CADASTRAL");
        mailing.setSituacao((String)retorno6.get(0));
        mailing.setDataSituacao(DateTimeUtil.toDate((String)((String)retorno6.get(1)), (FormatDate)FormatDate.DATE_BR));
        mailing.setMotivoSituacaoEspecial((String)this.getJsoup(html, "MOTIVO DE SITUA\u00c7\u00c3O CADASTRAL").get(0));
        List retorno7 = this.getJsoup(html, "SITUA\u00c7\u00c3O ESPECIAL");
        mailing.setSituacaoEspecial((String)retorno7.get(0));
        if (((String)retorno7.get(1)).contains("/") && ((String)retorno7.get(1)).length() >= 8) {
            mailing.setDataSituacaoEspecial(DateTimeUtil.toDate((String)((String)retorno7.get(1)), (FormatDate)FormatDate.DATE_BR));
        }
        this.setQsa(htmlSocios, mailing);
        this.setContatos(html, mailing);
        this.setAtividades(html, mailing);
        return mailing;
    }

    private List<String> getJsoup(String html, String campo) {
        return this.getJsoup(html, campo, "Inicio Linha ", "Fim Linha ");
    }

    private List<String> getJsoup(String html, String campo, String prefixoInicial, String prefixoFinal) {
        campo = StringUtil.normalize((String)campo);
        ArrayList<String> retorno = new ArrayList<String>();
        Elements elements = Jsoup.parse((String)html.substring(html.indexOf(prefixoInicial + campo), html.indexOf(prefixoFinal + campo))).select("table").first().select("tr");
        for (Element element : elements) {
            Elements tds = element.select("td");
            for (Element td : tds) {
                Elements font = td.select("font");
                if (font.size() == 2) {
                    retorno.add(((Element)font.get(1)).text());
                    continue;
                }
                if (font.size() <= 2) continue;
                for (int i = 1; i < font.size(); ++i) {
                    retorno.add(((Element)font.get(i)).text());
                }
            }
        }
        return retorno;
    }

    private void setAtividades(String html, Mailing mailing) {
        HashSet<MailingAtividade> atividades = new HashSet<MailingAtividade>();
        String atividadeEconomica = (String)this.getJsoup(html, "ATIVIDADE ECONOMICA").iterator().next();
        String codigo = StringUtil.numbersOnly((String)atividadeEconomica.split(" - ")[0]);
        Cnae cnaePrincipal = this.cnaeRepository.findByCodigo(codigo);
        if (cnaePrincipal != null) {
            MailingAtividade atv = new MailingAtividade();
            atv.setCnae(cnaePrincipal);
            atv.setMailing(mailing);
            atv.setPrincipal(Boolean.TRUE);
            atividades.add(atv);
        }
        List aeSecundarias = this.getJsoup(html, "ATIVIDADE ECONOMICA SECUNDARIA");
        for (String aeSecundaria : aeSecundarias) {
            Cnae cnaeSecundario;
            String codigoSec = StringUtil.numbersOnly((String)aeSecundaria.split(" - ")[0]);
            if (codigoSec.isEmpty() || (cnaeSecundario = this.cnaeRepository.findByCodigo(codigoSec)) == null) continue;
            MailingAtividade atvSec = new MailingAtividade();
            atvSec.setCnae(cnaeSecundario);
            atvSec.setMailing(mailing);
            atvSec.setPrincipal(Boolean.FALSE);
            atividades.add(atvSec);
        }
        mailing.setAtividades(atividades);
    }

    private void setContatos(String html, Mailing mailing) {
        HashSet<MailingContato> contatos = new HashSet<MailingContato>();
        List retorno5 = this.getJsoup(html, "Linha de Contato", "Inicio de ", "Fim de ");
        contatos.add(new MailingContato(MailingTipoContatoEnum.EMAIL, (String)retorno5.get(0)));
        contatos.add(new MailingContato(MailingTipoContatoEnum.TELEFONE, (String)retorno5.get(1)));
        mailing.setContatos(contatos);
    }

    private void setQsa(Document jsoupSocios, Mailing mailing) {
        HashSet<MailingSocio> socios = new HashSet<MailingSocio>();
        Element jsoupCapital = jsoupSocios.getElementById("capital");
        jsoupCapital.getElementsByClass("row").forEach(item -> {
            if (item.toString().contains("CAPITAL SOCIAL")) {
                try {
                    String val = item.getElementsByClass("col-md-9").text();
                    mailing.setCapitalSocial(Recognizer.getDecimal((String)val));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        try {
            String[] arr;
            String html = jsoupSocios.toString();
            html = html.substring(html.indexOf("<!-- h\u00e1 QSA -->"));
            for (String strSocio : arr = html.split("<!-- quadro de s\u00f3cios -->")) {
                Document jSocio = new Document(Jsoup.parse((String)strSocio));
                String nome = jSocio.getElementsByClass("col-md-9").text();
                String qualificacao = jSocio.getElementsByClass("col-md-5").text();
                if (nome.isEmpty()) continue;
                MailingSocio ms = new MailingSocio();
                ms.setMailing(mailing);
                ms.setMailingSocioTipo(MailingSocioTipoEnum.FISICA);
                ms.setNome(nome);
                ms.setQualificacao(Integer.valueOf(StringUtil.toInt((String)qualificacao.split("-")[0])));
                socios.add(ms);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        mailing.setSocios(socios);
    }
}

