/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.receitafederal.view;

import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.mailing.projection.MailingLimited;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.service.PedidoTagsService;
import br.com.system.app.features.receitafederal.service.ReceitaFederalService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.views.HierarquiaView;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ReceitaAtividadeView
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final EstruturaUsuarioService eus;
    private final List<MailingLimited> lista;
    private final EstruturaUsuario eu;
    private final ReceitaFederalService receitaFederalService;
    private final PedidoTagsService pedidoTagsService;
    private final String descricao;
    private final UsuarioHierarquiaService hierarquiaService;
    private HierarquiaView h;

    public ReceitaAtividadeView(List<MailingLimited> lista, EstruturaUsuario eu, EstruturaUsuarioService eus, String descricao, ReceitaFederalService receitaFederalService, UsuarioHierarquiaService hierarquiaService, PedidoTagsService pedidoTagsService) {
        this.pedidoTagsService = pedidoTagsService;
        this.hierarquiaService = hierarquiaService;
        this.receitaFederalService = receitaFederalService;
        this.lista = lista;
        this.eus = eus;
        this.eu = eu;
        this.descricao = descricao;
        this.create();
    }

    private void create() {
        this.setWidth("650px");
        MultiComboBox tags = new MultiComboBox("Tags");
        RadioButtonGroup rbTipo = new RadioButtonGroup();
        rbTipo.addValueChangeListener(arg_0 -> this.lambda$create$348b4665$1((MultiSelectComboBox)tags, rbTipo, arg_0));
        rbTipo.setItems((Object[])PedidoTipoEnum.values());
        rbTipo.setValue((Object)PedidoTipoEnum.COMERCIAL);
        UIUtils.setFontSize((FontSize)FontSize.XXS, (Component[])new Component[]{rbTipo});
        Span label = UIUtils.createSmallSpan((String)("Total clientes selecionados: " + this.lista.size()));
        this.h = new HierarquiaView(this.eu, this.eus, this.hierarquiaService);
        this.h.setMultiple(Boolean.TRUE);
        this.h.getBtnFechar().addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.h.getBtnConfirmar().setText("Distribuir");
        this.h.getBtnConfirmar().setDisableOnClick(true);
        this.h.getBtnConfirmar().addClickListener(arg_0 -> this.lambda$create$b40f499c$1(rbTipo, (MultiSelectComboBox)tags, arg_0));
        this.add(new Component[]{new VerticalContainer(new Component[]{label, rbTipo, tags, this.h})});
        this.open();
    }

    private /* synthetic */ void lambda$create$b40f499c$1(RadioButtonGroup rbTipo, MultiSelectComboBox tags, ClickEvent e) {
        this.h.getBtnConfirmar().setEnabled(true);
        if (this.h.getValues().size() <= 0) {
            UIUtils.showNotification((String)"Selecione pelo menos 1 usu\u00e1rio");
            return;
        }
        if (this.lista.size() < this.h.getUsuarioId().size()) {
            UIUtils.showNotification((String)"H\u00e1 mais usu\u00e1rios que clientes, imposs\u00edvel distribuir.");
            return;
        }
        if (this.lista.size() > 1000) {
            UIUtils.showNotification((String)"Limite de 1000 ultrapassado");
            return;
        }
        this.receitaFederalService.distribuirAtividade(this.lista, this.eu, (PedidoTipoEnum)rbTipo.getValue(), tags.getValue(), this.h.getEstruturaUsuarioId(), this.descricao);
        UIUtils.showProcessNotification((String)"Processo finalizado, voce pode conferir em notificacoes");
        this.close();
    }

    private /* synthetic */ void lambda$create$348b4665$1(MultiSelectComboBox tags, RadioButtonGroup rbTipo, AbstractField.ComponentValueChangeEvent e) {
        tags.setItems((Collection)this.pedidoTagsService.getTags(this.eu.getEstrutura(), (PedidoTipoEnum)rbTipo.getValue()));
    }
}

