/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.receitafederal.view;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.mailing.model.Mailing;
import br.com.system.app.features.mailing.projection.MailingLimited;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.receitafederal.view.ReceitaDialogView;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;

public class ReceitaGridView
extends ViewFrame
implements SecurityContext {
    private final MailingService mailingService;
    private static final long serialVersionUID = 1L;
    private Grid<MailingLimited> grid;
    private Span labelRowCont;
    private Button btnOportunidade;
    private Button btnProspectBi;
    private Button btnEnriquecimento;
    private Button btnAtividade;
    private Button btnSincronia;
    private Button btnContar;
    private final Button btnNextPage;
    private final Button btnPrevPage;

    public ReceitaGridView(MailingService mailingService) {
        this.mailingService = mailingService;
        this.btnNextPage = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.STEP_FORWARD, (String)"Proxima pagina");
        this.btnPrevPage = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.STEP_BACKWARD, (String)"Pagina Anterior");
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public Button getBtnNextPage() {
        return this.btnNextPage;
    }

    public Button getBtnPrevPage() {
        return this.btnPrevPage;
    }

    public Button getBtnContar() {
        return this.btnContar;
    }

    public Button getBtnOportunidade() {
        return this.btnOportunidade;
    }

    public Button getBtnProspectBi() {
        return this.btnProspectBi;
    }

    public Button getBtnEnriquecimento() {
        return this.btnEnriquecimento;
    }

    public Button getBtnAtividade() {
        return this.btnAtividade;
    }

    public Span getLabelRowCont() {
        return this.labelRowCont;
    }

    public Button getBtnSincronia() {
        return this.btnSincronia;
    }

    public Grid<MailingLimited> getGrid() {
        return this.grid;
    }

    public VerticalLayout getView() {
        VerticalLayout lay = new VerticalLayout();
        lay.setHeight("100%");
        lay.setWidth("100%");
        HorizontalContainer h = new HorizontalContainer(new Component[]{this.labelRowCont, this.btnContar, this.btnSincronia, this.btnEnriquecimento, this.btnOportunidade, this.btnAtividade, this.btnProspectBi, this.btnPrevPage, this.btnNextPage});
        lay.add(new Component[]{h});
        lay.add(new Component[]{this.grid});
        return lay;
    }

    public ReceitaGridView create() {
        this.btnContar = UIUtils.createSmallButton((String)"CONTAR REGISTROS", (VaadinIcon)VaadinIcon.ABACUS, (String)"Contar numero de registros");
        this.btnContar.setVisible(false);
        this.btnContar.setEnabled(false);
        this.btnPrevPage.setEnabled(false);
        this.btnNextPage.setEnabled(false);
        this.labelRowCont = new Span();
        this.btnSincronia = UIUtils.createSmallButton((String)"RECEITA", (VaadinIcon)VaadinIcon.REFRESH, (String)"Sincronizar com a receita federal");
        this.btnSincronia.setEnabled(false);
        this.btnOportunidade = UIUtils.createSmallButton((String)"OPORTUNIDADE", (String)"Processar oportunidade");
        this.btnOportunidade.setVisible(this.hasPermission("OPORTUNIDADE_VIEW") && (this.isVivo() || this.isClaro() || this.isTim() || this.isConsultoria() || this.isOi()));
        this.btnOportunidade.setEnabled(false);
        this.btnProspectBi = UIUtils.createSmallButton((String)"PROSPECT BI", (String)"Gerar arquivo para Prospect BI");
        this.btnProspectBi.setVisible(this.isVivo() && this.hasPermission("PROSPECT_BI_GENERATE"));
        this.btnProspectBi.setEnabled(false);
        this.btnEnriquecimento = UIUtils.createSmallButton((String)"ENRIQUECIMENTO", (String)"Criar campanha de Enriquecimento de base");
        this.btnEnriquecimento.setEnabled(false);
        this.btnAtividade = UIUtils.createSmallButton((String)"ATIVIDADE", (String)"Criar nova atividade");
        this.btnAtividade.setVisible(this.hasPermission("IMPORTACAO_ATIVIDADE_VIEW"));
        this.btnAtividade.setEnabled(false);
        this.grid = new Grid(MailingLimited.class);
        this.grid.setMinHeight("600px");
        this.grid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_ROW_STRIPES, GridVariant.LUMO_COLUMN_BORDERS, GridVariant.MATERIAL_COLUMN_DIVIDERS, GridVariant.LUMO_COMPACT});
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.grid.setColumns(new String[0]);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)m -> {
            Button btn = UIUtils.createSmallButton((String)"Ver", (String)"Ver dados do cliente");
            btn.addClickListener((ComponentEventListener & Serializable)e -> {
                Mailing mailing = this.mailingService.buscarID(m.getId());
                this.mailingService.registerMailingView(mailing, this.getEu());
                this.grid.getDataProvider().refreshItem(m);
                ReceitaDialogView dialog = new ReceitaDialogView();
                dialog.setContent(mailing);
                dialog.open();
            });
            return btn;
        })).setFlexGrow(0).setWidth("80px");
        this.grid.addColumn("cnpj").setSortable(false).setFlexGrow(0).setWidth("180px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getNome());
            return label;
        })).setKey("nome").setHeader("Nome Cliente").setWidth("300px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)m -> m.getSituacao())).setHeader("Situa\u00e7\u00e3o").setSortable(false).setFlexGrow(0).setWidth("150px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getCidade());
            return label;
        })).setKey("cidade").setHeader("Cidade").setWidth("250px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getBairro());
            return label;
        })).setKey("bairro").setHeader("Bairro").setWidth("150px");
        this.grid.addColumn("estado").setSortable(false).setHeader("UF").setFlexGrow(0).setWidth("40px");
        this.grid.addColumn("mei").setSortable(false).setHeader("MEI").setFlexGrow(0).setWidth("60px");
        this.grid.addColumn("porte").setSortable(false).setFlexGrow(0).setWidth("80px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)m -> UIUtils.formatCurrency((Double)m.getCapitalSocial()))).setHeader("Capital").setSortable(false).setFlexGrow(0).setWidth("150px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)m -> m.getDataAbertura() == null ? "" : m.getDataAbertura().format(FormatDate.DATE_BR.toDTF()))).setHeader("Abertura").setSortable(false).setFlexGrow(0).setWidth("150px");
        this.grid.setWidthFull();
        this.grid.setHeightFull();
        this.grid.setPageSize(60);
        return this;
    }
}

