/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.receitafederal.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.mailing.service.MailingReceitaService;
import br.com.system.app.features.receitafederal.model.ReceitaSincroniaDTO;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="receita-federal-sincronia", layout=MainLayout.class)
@PageTitle(value="Sincronia manual Base Receita Federal")
@RolesAllowed(value={"MASTER"})
public class ReceitaSincroniaView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final MailingReceitaService mailingReceitaService;
    private TextArea taLog;
    private Integer ind;
    private List<String> lista;
    private final StringBuilder log = new StringBuilder();

    @Autowired
    public ReceitaSincroniaView(MailingReceitaService mailingReceitaService) {
        this.mailingReceitaService = mailingReceitaService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        }
    }

    private Component createContent() {
        VerticalLayout main = new VerticalLayout();
        TextArea ta = new TextArea("Lista de CNPJS");
        ta.setWidth("150px");
        ta.setHeight("500px");
        this.taLog = new TextArea("LOG");
        this.taLog.setReadOnly(true);
        this.taLog.setWidth("700px");
        this.taLog.setHeight("500px");
        Button btn = UIUtils.createSmallButton((String)"Sincronizar");
        btn.addClickListener((ComponentEventListener & Serializable)e -> {
            this.log.setLength(0);
            this.ind = 0;
            this.lista = new ArrayList();
            for (String s : ta.getValue().split("\n")) {
                if (!ValidationUtil.isValidCNPJ((String)(s = StringUtil.numbersOnly((String)s))) || this.lista.contains(s)) continue;
                this.lista.add(s);
            }
            if (this.lista.size() <= 0) {
                this.showNotification("Nenhum cnpj valido");
                return;
            }
            this.log.append("Total CNPJS: ").append(this.lista.size()).append("\nIniciando processo...\n");
            this.mailingReceitaService.forcarReceita((String)this.lista.get(0), this.getEu(), arg_0 -> this.listener(arg_0));
        });
        main.add(new Component[]{new HorizontalContainer(new Component[]{ta, this.taLog}), btn});
        return main;
    }

    private void listener(ReceitaSincroniaDTO d) {
        if (!this.getUI().isPresent()) {
            return;
        }
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            Integer n = this.ind;
            this.ind = this.ind + 1;
            if (d.getErro() != null) {
                this.log.append(this.ind).append(" de ").append(this.lista.size()).append(" ").append(d.getCpfCnpj()).append(" ERRO: ").append(d.getErro()).append("\n");
            } else {
                this.log.append(this.ind).append(" de ").append(this.lista.size()).append(" ").append(d.getCpfCnpj()).append(" Sincronizado\n");
            }
            this.taLog.setValue(this.log.toString());
            this.taLog.getElement().executeJs("$0.scrollTo(0,$0.scrollHeight);", new Serializable[]{this.taLog.getElement()});
            if (this.ind > this.lista.size() - 1) {
                this.log.append("Finalizado");
                return;
            }
            this.mailingReceitaService.forcarReceita((String)this.lista.get(this.ind), this.getEu(), arg_0 -> this.listener(arg_0));
            this.taLog.getElement().executeJs("$0.scrollTo(0,$0.scrollHeight);", new Serializable[]{this.taLog.getElement()});
        });
    }
}

