/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.trescx.repository;

import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.trescx.dto.TrescxLogDTO;
import br.com.system.app.features.trescx.dto.TrescxLogResumoDTO;
import br.com.system.app.features.trescx.repository.TrescxLogRepositoryQuery;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class TrescxLogRepositoryImpl
implements TrescxLogRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;

    @Transactional(readOnly=true)
    public List<TrescxLogResumoDTO> getResumo(Set<Long> hierarquia, LocalDateTime di, LocalDateTime df) {
        String sql = "select (select uuid_short()) as id,usuario.login login_usuario,count(*) quantidade, sum(trescx_log.talking) talking,sum(trescx_log.ring) ring,sum(trescx_log.total) tempo_total, trescx_log.ramal,sum(if(trescx_log.talking is not null,1,0)) quantos_falados from trescx_log,estrutura_usuario,usuario where trescx_log.estrutura_usuario_id=estrutura_usuario.id and estrutura_usuario.usuario_id=usuario.id  and trescx_log.estrutura_usuario_id in :hierarquia and trescx_log.data_hora_inicio >=:inicio and trescx_log.data_hora_inicio <=:fim group by usuario.id";
        Query query = this.manager.createNativeQuery(sql, TrescxLogResumoDTO.class);
        query.setParameter("hierarquia", hierarquia);
        query.setParameter("inicio", (Object)di);
        query.setParameter("fim", (Object)df);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<TrescxLogDTO> filter(Set<Long> hierarquia, LocalDateTime di, LocalDateTime df, HierarquiaDTO usuario, String destino, LocalTime minimoFalado, Pageable pageable) {
        Query query = this.query(hierarquia, di, df, usuario, destino, minimoFalado, pageable, false);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public Long count(Set<Long> hierarquia, LocalDateTime di, LocalDateTime df, HierarquiaDTO usuario, String destino, LocalTime minimoFalado) {
        Query query = this.query(hierarquia, di, df, usuario, destino, minimoFalado, null, true);
        return (Long)query.getSingleResult();
    }

    private Query query(Set<Long> hierarquia, LocalDateTime di, LocalDateTime df, HierarquiaDTO usuario, String destino, LocalTime minimoFalado, Pageable pageable, boolean count) {
        Object sql = count ? "select count(*) as total" : "select (select uuid_short()) as id,usuario.login login_usuario, trescx_log.ramal, trescx_log.destino,trescx_log.status,trescx_log.data_hora_inicio inicio, trescx_log.data_hora_fim fim,trescx_log.talking,trescx_log.ring,trescx_log.total, trescx_chamada.cpf_cnpj,trescx_chamada.pedido_id,trescx_log.hash_gravacao";
        sql = (String)sql + " from trescx_log join estrutura_usuario on (estrutura_usuario.id=trescx_log.estrutura_usuario_id) join usuario on (estrutura_usuario.usuario_id=usuario.id) left join trescx_chamada on (trescx_log.id=trescx_chamada.trescx_log_id and trescx_log.estrutura_usuario_id=trescx_chamada.estrutura_usuario_id) where trescx_log.estrutura_usuario_id in :hierarquia and trescx_log.data_hora_inicio >=:inicio and trescx_log.data_hora_inicio <=:fim";
        if (minimoFalado != null) {
            sql = (String)sql + " and trescx_log.talking>=:minimofalado";
        }
        if (usuario != null) {
            sql = (String)sql + " and trescx_log.estrutura_usuario_id=:euId";
        }
        if (destino != null && !destino.isEmpty()) {
            sql = (String)sql + " and trescx_log.destino like :destino";
        }
        if (!count) {
            sql = (String)sql + " group by trescx_log.id";
        }
        if (pageable != null) {
            sql = (String)sql + " order by trescx_log.data_hora_inicio desc";
            sql = (String)sql + " limit :limit offset :offset";
        }
        Query query = count ? this.manager.createNativeQuery((String)sql) : this.manager.createNativeQuery((String)sql, TrescxLogDTO.class);
        if (minimoFalado != null) {
            query.setParameter("minimofalado", (Object)minimoFalado);
        }
        query.setParameter("hierarquia", hierarquia);
        query.setParameter("inicio", (Object)di);
        query.setParameter("fim", (Object)df);
        if (usuario != null) {
            query.setParameter("euId", (Object)usuario.getEstruturaUsuarioId());
        }
        if (destino != null && !destino.isEmpty()) {
            query.setParameter("destino", (Object)("%" + destino + "%"));
        }
        if (pageable != null) {
            query.setParameter("limit", (Object)pageable.getPageSize());
            query.setParameter("offset", (Object)pageable.getOffset());
        }
        return query;
    }
}

