/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.service;

import br.com.system.app.features.equipe.service.EquipeLogService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.kanbanpedidos.model.KanbanPedidos;
import br.com.system.app.features.kanbanpedidos.service.KanbanPedidosService;
import br.com.system.app.features.usuario.dto.UsuarioCopyTypeEnum;
import br.com.system.app.features.usuario.service.HierarquiaLogService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsuarioCopyService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;
    @Autowired
    private KanbanPedidosService kanbanPedidosService;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;
    @Autowired
    private EquipeLogService equipeLogService;
    @Autowired
    private HierarquiaLogService hierarquiaLogService;

    @Transactional
    public void copiar(EstruturaUsuario euContext, EstruturaUsuario eu, EstruturaUsuario euModelo, UsuarioCopyTypeEnum tipo) {
        HashSet<UsuarioCopyTypeEnum> setType = new HashSet<UsuarioCopyTypeEnum>();
        setType.add(tipo);
        this.copiar(euContext, eu, euModelo, setType);
    }

    @Transactional
    public void copiar(EstruturaUsuario euContext, EstruturaUsuario eu, EstruturaUsuario euModelo, Set<UsuarioCopyTypeEnum> tipo) {
        if (eu == null || euModelo == null) {
            return;
        }
        if (!eu.getEstrutura().equals((Object)euModelo.getEstrutura())) {
            return;
        }
        if (tipo.contains(UsuarioCopyTypeEnum.PERMISSOES) || tipo.contains(UsuarioCopyTypeEnum.TUDO)) {
            eu.setRules(euModelo.getRules());
        }
        if (tipo.contains(UsuarioCopyTypeEnum.EQUIPE) || tipo.contains(UsuarioCopyTypeEnum.TUDO)) {
            eu.setEquipe(euModelo.getEquipe());
            StringBuilder log = new StringBuilder();
            log.append("Usu\u00e1rio ").append(euContext.getUsuario().getNome()).append(" alterou a equipe de ").append(eu.getUsuario().getNome()).append(" <BR>para ").append(euModelo.getEquipe() == null ? " branco " : euModelo.getEquipe().getNome()).append(" copiando do usu\u00e1rio ").append(euModelo.getUsuario().getNome()).append(" <BR>via cadastro de usu\u00e1rios");
            this.equipeLogService.save(euContext, log.toString());
        }
        this.estruturaUsuarioService.save(eu);
        if (tipo.contains(UsuarioCopyTypeEnum.HIERARQUIA) || tipo.contains(UsuarioCopyTypeEnum.TUDO)) {
            Set hModelo = this.hierarquiaService.getHierarquia(euModelo);
            hModelo.remove(euModelo.getId());
            hModelo.add(eu.getId());
            this.hierarquiaService.setHierarquia(eu, hModelo);
            this.hierarquiaService.insertHierarquia(eu, euModelo);
            StringBuilder log = new StringBuilder();
            log.append("Usu\u00e1rio ").append(euContext.getUsuario().getNome()).append(" alterou a hierarquia de ").append(eu.getUsuario().getNome()).append(" <BR>copiando do usu\u00e1rio ").append(euModelo.getUsuario().getNome()).append(" <BR>via cadastro de usu\u00e1rios");
            this.hierarquiaLogService.save(euContext, log.toString());
        }
        if (tipo.contains(UsuarioCopyTypeEnum.KANBAN) || tipo.contains(UsuarioCopyTypeEnum.TUDO)) {
            List kanbanList = this.kanbanPedidosService.getAllKanban(euModelo);
            if (!kanbanList.isEmpty()) {
                this.kanbanPedidosService.deleteByEstruturaUsuario(eu);
            }
            for (KanbanPedidos kp : kanbanList) {
                if (this.kanbanPedidosService.getKanban(eu, kp.getPedidoEtapa()) != null) continue;
                KanbanPedidos kpNew = new KanbanPedidos();
                kpNew.setEstruturaUsuario(eu);
                kpNew.setPedidoEtapa(kp.getPedidoEtapa());
                kpNew.setPosition(kp.getPosition());
                kpNew.setNome(kp.getNome());
                kpNew.setBackgroundColor(kp.getBackgroundColor());
                this.kanbanPedidosService.save(kpNew);
            }
        }
    }
}

