/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.views;

import br.com.system.app.MainLayout;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.service.HierarquiaLogService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.views.HierarquiaLogView;
import br.com.system.app.features.usuario.views.HierarquiaView;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

@Route(value="hierarquia-change", layout=MainLayout.class)
@PageTitle(value="Altera\u00e7\u00f5es na hierarquia")
@RolesAllowed(value={"HIERARQUIA_CHANGE_VIEW"})
public class HierarquiaChangeView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final EstruturaUsuarioService estruturaUsuarioService;
    private final UsuarioHierarquiaService usuarioHierarquiaService;
    private final HierarquiaLogService hierarquiaLogService;
    private final HierarquiaLogView hierarquiaLogView;
    private HierarquiaView hierarquiaIn;
    private HierarquiaView hierarquiaOut;
    private EstruturaUsuario euSelect;
    private final DownloadDialog dd = new DownloadDialog();

    public HierarquiaChangeView(EstruturaUsuarioService estruturaUsuarioService, UsuarioHierarquiaService usuarioHierarquiaService, HierarquiaLogService hierarquiaLogService, HierarquiaLogView hierarquiaLogView) {
        this.estruturaUsuarioService = estruturaUsuarioService;
        this.hierarquiaLogView = hierarquiaLogView;
        this.hierarquiaLogService = hierarquiaLogService;
        this.usuarioHierarquiaService = usuarioHierarquiaService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        }
    }

    private Component createContent() {
        List usuariosAtivos = this.estruturaUsuarioService.getAtivosByEstrutura(this.getEstrutura());
        Button btnLog = UIUtils.createSmallButton((String)"Ver Logs");
        btnLog.setEnabled(this.hasPermission("VER_LOG_HIERARQUIA"));
        btnLog.addClickListener((ComponentEventListener & Serializable)e -> this.hierarquiaLogView.create(this.getEstrutura()));
        ComboBox cbEstaNaHierarquia = new ComboBox("Quem tem vis\u00e3o deste usuario?");
        cbEstaNaHierarquia.setItems((Collection)usuariosAtivos);
        cbEstaNaHierarquia.setWidth("500px");
        cbEstaNaHierarquia.setItemLabelGenerator(HierarquiaDTO::getUsuarioELogin);
        cbEstaNaHierarquia.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (cbEstaNaHierarquia.getValue() == null) {
                return;
            }
            this.mostraHierarquia((HierarquiaDTO)cbEstaNaHierarquia.getValue());
        });
        ComboBox cb = new ComboBox("Usu\u00e1rio");
        cb.setItems((Collection)usuariosAtivos);
        cb.setWidth("500px");
        cb.setItemLabelGenerator(HierarquiaDTO::getUsuarioELogin);
        cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.euSelect = cb.getValue() == null ? null : this.estruturaUsuarioService.getById(((HierarquiaDTO)cb.getValue()).getEstruturaUsuarioId());
            this.hierarquiaIn.setEuSelect(this.euSelect);
            this.hierarquiaIn.getPesquisaBtn().setEnabled(true);
            this.hierarquiaOut.setEuSelect(this.euSelect);
            this.hierarquiaOut.getPesquisaBtn().setEnabled(true);
        });
        this.hierarquiaIn = new HierarquiaView(null, this.estruturaUsuarioService, this.usuarioHierarquiaService, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
        this.hierarquiaIn.setWidth("500px");
        this.hierarquiaIn.getPesquisaBtn().setEnabled(false);
        this.hierarquiaIn.getBtnFechar().setVisible(false);
        this.hierarquiaIn.getBtnConfirmar().setVisible(false);
        this.hierarquiaIn.getHeader().setText("Hierarquia Atual");
        this.hierarquiaIn.setMultiple(Boolean.TRUE);
        this.hierarquiaOut = new HierarquiaView(null, this.estruturaUsuarioService, this.usuarioHierarquiaService, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        this.hierarquiaOut.setWidth("500px");
        this.hierarquiaOut.getPesquisaBtn().setEnabled(false);
        this.hierarquiaOut.getBtnFechar().setVisible(false);
        this.hierarquiaOut.getBtnConfirmar().setVisible(false);
        this.hierarquiaOut.getHeader().setText("Usu\u00e1rios dispon\u00edveis");
        this.hierarquiaOut.setMultiple(Boolean.TRUE);
        Button btnIncluir = UIUtils.createSmallButton((String)"Incluir", (VaadinIcon)VaadinIcon.PLUS);
        btnIncluir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.euSelect == null) {
                this.showNotification("Selecione o usu\u00e1rio para alterar a hierarquia");
            }
            if (this.hierarquiaOut.getValues().size() <= 0) {
                this.showNotification("Selecione um usu\u00e1rio para incluir");
                return;
            }
            if (cb.getValue() == null) {
                this.showNotification("Selecione o usuario da hierarquia");
                return;
            }
            StringBuilder s = new StringBuilder();
            s.append("<b>Usu\u00e1rio ").append(this.getUsuario().getNome()).append(" incluiu no usu\u00e1rio ").append(((HierarquiaDTO)cb.getValue()).getUsuarioNome()).append("</b><BR><BR>");
            Set dto = this.hierarquiaOut.getValues();
            for (HierarquiaDTO d : dto) {
                s.append(d.getUsuarioNome()).append("<BR>");
            }
            s.append("<BR>");
            this.hierarquiaLogService.save(this.getEu(), s.toString());
            this.hierarquiaIn.clearFilter();
            Set h = this.hierarquiaIn.getDataProviderIds();
            h.addAll(this.hierarquiaOut.getEstruturaUsuarioId());
            this.usuarioHierarquiaService.setHierarquia(this.euSelect, h);
            this.hierarquiaIn.loadData();
            this.hierarquiaOut.loadData();
        });
        Button btnExcluir = UIUtils.createSmallButton((String)"Excluir", (VaadinIcon)VaadinIcon.TRASH);
        btnExcluir.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cb.getValue() == null) {
                this.showNotification("Selecione o usu\u00e1rio para alterar a hierarquia");
            }
            if (this.hierarquiaIn.getValues().size() <= 0) {
                this.showNotification("Selecione um usu\u00e1rio para incluir");
                return;
            }
            StringBuilder s = new StringBuilder();
            s.append("<b>Usu\u00e1rio ").append(this.getUsuario().getNome()).append(" excluiu do usu\u00e1rio ").append(((HierarquiaDTO)cb.getValue()).getUsuarioNome()).append("</b><BR><BR>");
            Set dto = this.hierarquiaIn.getValues();
            for (HierarquiaDTO d : dto) {
                s.append(d.getUsuarioNome()).append("<BR>");
            }
            s.append("<BR>");
            this.hierarquiaLogService.save(this.getEu(), s.toString());
            Set excluir = this.hierarquiaIn.getEstruturaUsuarioId();
            this.hierarquiaIn.clearFilter();
            Set h = this.hierarquiaIn.getDataProviderIds();
            h.removeAll(excluir);
            this.usuarioHierarquiaService.setHierarquia(this.euSelect, h);
            this.hierarquiaIn.loadData();
            this.hierarquiaOut.loadData();
        });
        VerticalContainer main = new VerticalContainer(new Component[0]);
        main.setId("main");
        VerticalContainer middle = new VerticalContainer(new Component[]{btnIncluir, btnExcluir}).setVerticalAlign(FlexComponent.Alignment.CENTER);
        middle.setWidth("100px");
        HorizontalContainer cont = new HorizontalContainer(new Component[0]);
        cont.setId("cont");
        cont.add(new Component[]{this.hierarquiaIn, middle, this.hierarquiaOut});
        cont.setHeightFull();
        main.add(new Component[]{new HorizontalContainer(new Component[]{cb, btnLog, cbEstaNaHierarquia}).setNoWrap(), cont});
        return main;
    }

    private void mostraHierarquia(HierarquiaDTO usuarioPesquisa) {
        List usuarioNaHierarquia = this.usuarioHierarquiaService.getUsuarioNaHierarquia(usuarioPesquisa.getEstruturaUsuarioId());
        InputStream is = null;
        XSSFWorkbook xls = null;
        try {
            is = StorageUtil.getObjectModelo((String)"ExportacaoVisaoHierarquia-v1.xlsx");
            xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheet("Exportacao");
            int i = 1;
            for (HierarquiaDTO dto : usuarioNaHierarquia) {
                aba.createRow(i);
                int col = 0;
                aba.getRow(i).createCell(col).setCellValue(dto.getUsuarioNome());
                aba.getRow(i).createCell(++col).setCellValue(dto.getLogin());
                aba.getRow(i).createCell(++col).setCellValue(dto.getEquipeNome());
                aba.getRow(i).createCell(++col).setCellValue(dto.isAtivo());
                aba.getRow(i).createCell(++col).setCellValue(dto.getPerfil());
                ++i;
            }
            String nomeArquivo = HashUtil.getUUI() + ".xlsx";
            InputStream isOutput = InputStreamUtil.workbookToInputStream((Workbook)xls);
            String hash = StorageUtil.uploadObjectInputStream((String)nomeArquivo, (String)ContentType.MULTIPART_FORM_DATA.toString(), (InputStream)isOutput);
            this.dd.open(hash, "ExportacaoUsuariosNaHierarquia.xlsx");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("Erro ao buscar hierarquia");
        }
        finally {
            try {
                xls.close();
                is.close();
                xls = null;
                is.close();
            }
            catch (Exception exception) {}
        }
    }
}

