/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.util.service;

import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.util.ExcellUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.XLSUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExcelAgrupadorService
implements Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - void declaration
     */
    public String processar(InputStream is, String agrupador, Set<String> colsAgrupar, List<String> colsContatenar, String separador) {
        separador = separador == null || separador.isEmpty() ? "\n" : separador;
        String hashFileName = HashUtil.getUUI() + ".xlsx";
        Integer indexAgrupador = XLSUtil.getIndexByName((String)agrupador);
        HashMap<String, HashMap> hm = new HashMap<String, HashMap>();
        try {
            String obj;
            XSSFWorkbook xls = new XSSFWorkbook(is);
            Sheet aba = xls.getSheetAt(0);
            Sheet aba2 = xls.createSheet("Resultado");
            for (int i = 1; i <= aba.getLastRowNum(); ++i) {
                try {
                    Row row = aba.getRow(i);
                    Cell cellN = row.getCell(indexAgrupador.intValue());
                    if (!hm.containsKey(ExcellUtil.getValueString((Cell)cellN))) {
                        void var16_21;
                        HashMap<Integer, String> colunas = new HashMap<Integer, String>();
                        boolean bl = false;
                        while (var16_21 < row.getLastCellNum()) {
                            try {
                                Cell cell = row.getCell((int)var16_21);
                                colunas.put((int)var16_21, ExcellUtil.getValueString((Cell)cell));
                            }
                            catch (Exception cell) {
                                // empty catch block
                            }
                            ++var16_21;
                        }
                        hm.put(cellN.getStringCellValue(), colunas);
                        continue;
                    }
                    HashMap cols = (HashMap)hm.get(cellN.getStringCellValue());
                    for (String s : colsAgrupar) {
                        Object conteudo = (String)cols.get(XLSUtil.getIndexByName((String)s));
                        Cell cellC = row.getCell(XLSUtil.getIndexByName((String)s).intValue());
                        conteudo = (String)conteudo + separador + ExcellUtil.getValueString((Cell)cellC);
                        cols.put(XLSUtil.getIndexByName((String)s), conteudo);
                    }
                    hm.put(cellN.getStringCellValue(), cols);
                    continue;
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(ExcelAgrupadorService.class).error(e.getMessage());
                }
            }
            Row rowHeadOrigin = aba.getRow(0);
            Row rowHead = aba2.createRow(0);
            for (int x = 0; x < rowHeadOrigin.getLastCellNum(); ++x) {
                Cell cell = rowHeadOrigin.getCell(x);
                rowHead.createCell(x).setCellValue(ExcellUtil.getValueString((Cell)cell));
            }
            rowHead.createCell((int)rowHeadOrigin.getLastCellNum()).setCellValue("Colunas concatenadas");
            int indRow = 1;
            for (Map.Entry entry : hm.entrySet()) {
                Row row = aba2.createRow(indRow);
                int indCell = 0;
                for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                    Cell cell = row.createCell(indCell);
                    cell.setCellValue((String)entry2.getValue());
                    ++indCell;
                }
                Object concat = "";
                for (String string : colsContatenar) {
                    try {
                        if (!((String)concat).isEmpty()) {
                            concat = (String)concat + separador;
                        }
                        concat = (String)concat + rowHeadOrigin.getCell(XLSUtil.getIndexByName((String)string).intValue()).getStringCellValue() + " " + row.getCell(XLSUtil.getIndexByName((String)string).intValue()).getStringCellValue();
                    }
                    catch (Exception exception) {}
                }
                row.createCell(indCell).setCellValue((String)concat);
                ++indRow;
            }
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                xls.write((OutputStream)byteArrayOutputStream);
                obj = StorageUtil.uploadObjectByteArray((String)hashFileName, (String)ContentType.MULTIPART_FORM_DATA.toString(), (byte[])byteArrayOutputStream.toByteArray());
            }
            aba = null;
            xls.close();
            return obj;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }
}

