/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.vivo.service;

import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.mailing.service.MailingService;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoTipoNegociacaoEnum;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.shared.model.StatusProcessoEnum;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.vivo.model.VivoProspectBiEstrutura;
import br.com.system.app.features.vivo.model.VivoProspectBiFile;
import br.com.system.app.features.vivo.model.VivoProspectBiItens;
import br.com.system.app.features.vivo.repository.VivoProspectBiEstruturaRepository;
import br.com.system.app.features.vivo.repository.VivoProspectBiFileRepository;
import br.com.system.app.features.vivo.repository.VivoProspectBiItensRepository;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class VivoProspectBiUploadService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private VivoProspectBiEstruturaRepository repository;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private VivoProspectBiFileRepository fileRepository;
    @Autowired
    private VivoProspectBiItensRepository itensRepository;
    @Autowired
    private MailingService mailingService;

    @Async(value="asyncDefault")
    public void upload(EstruturaUsuario eu, InputStream is, String filename) {
        Thread.currentThread().setName("asyncDefault-vivo-prospect-bi-upload");
        VivoProspectBiFile file = new VivoProspectBiFile();
        try {
            String[] linhas = InputStreamUtil.toString((InputStream)is, (Charset)StringUtil.ISO_8859_15).split("\n");
            file.setDataHora(LocalDateTime.now());
            file.setEstruturaUsuario(eu);
            file.setStatusProcesso(StatusProcessoEnum.PROCESSANDO);
            if (linhas.length > 0 && linhas[0].toUpperCase().contains("DOCUMENTO")) {
                file.setTotalRegistros(Integer.valueOf(linhas.length - 1));
            } else {
                file.setTotalRegistros(Integer.valueOf(linhas.length));
            }
            file.setFileName(filename);
            file = (VivoProspectBiFile)this.fileRepository.save((Object)file);
            List users = this.eus.getByUserTag(eu.getEstrutura(), "#leadProspectBi");
            if (users.size() <= 0) {
                users.add(this.eus.getMasterEstrutura(eu.getEstrutura()));
            }
            Integer indUser = 0;
            StringBuilder strArq = new StringBuilder();
            for (String linha : linhas) {
                try {
                    String[] cmp = linha.split(";");
                    strArq.append(linha).append("\n");
                    String cnpj = StringUtil.normalizeCpfCnpj((String)cmp[1]);
                    if (!ValidationUtil.isValidCnpjAndCpf((String)cnpj)) continue;
                    Integer flagAnterior = null;
                    VivoProspectBiEstrutura vpb = this.repository.findByEstruturaAndCpfCnpj(eu.getEstrutura(), cnpj);
                    if (vpb == null) {
                        vpb = new VivoProspectBiEstrutura();
                        vpb.setCpfCnpj(cnpj);
                        vpb.setEstrutura(eu.getEstrutura());
                    } else {
                        flagAnterior = vpb.getFlagDisp();
                    }
                    vpb.setDataHora(LocalDateTime.now());
                    vpb.setEnriquecimento("CEP: " + cmp[2] + " Numero: " + cmp[3] + " " + cmp[5]);
                    vpb.setFlagDisp(Integer.valueOf(cmp[6]));
                    vpb = (VivoProspectBiEstrutura)this.repository.save((Object)vpb);
                    VivoProspectBiItens item = new VivoProspectBiItens();
                    item.setCpfCnpj(cnpj);
                    item.setEnriquecimento(vpb.getEnriquecimento());
                    item.setFlagDisp(vpb.getFlagDisp());
                    item.setVivoProspectBiFile(file);
                    this.itensRepository.save((Object)item);
                    this.alertar(vpb, users, indUser, flagAnterior);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(VivoProspectBiUploadService.class).error(e.getMessage());
                }
            }
            String url = StorageUtil.uploadObjectByteArray((String)(HashUtil.getUUI() + ".csv"), (byte[])strArq.toString().getBytes());
            file.setUrlFile(url);
            file.setStatusProcesso(StatusProcessoEnum.FINALIZADO);
        }
        catch (Exception e) {
            file.setStatusProcesso(StatusProcessoEnum.FINALIZADO_COM_ERRO);
            file.setObservacao(e.getMessage());
        }
        this.fileRepository.save((Object)file);
    }

    private void alertar(VivoProspectBiEstrutura vpbe, List<EstruturaUsuario> users, Integer indUser, Integer flagAnterior) {
        if (vpbe.getFlagDisp() == 3 && flagAnterior != null && flagAnterior != 3) {
            this.criarAtividade(users.get(indUser), vpbe);
            Integer n = indUser;
            indUser = indUser + 1;
            if (indUser >= users.size() - 1) {
                indUser = 0;
            }
        }
    }

    private void criarAtividade(EstruturaUsuario eu, VivoProspectBiEstrutura vpbe) {
        if (!this.mailingService.isAtiva(vpbe.getCpfCnpj()).booleanValue()) {
            return;
        }
        Pedido pedido = new Pedido();
        pedido.setCliente(this.clienteService.getAndCreateCliente(eu, vpbe.getCpfCnpj(), new ClienteContato[0]));
        pedido.setComplementos(this.getCompl(vpbe));
        pedido.setEstruturaUsuario(eu);
        pedido.setTipoNegociacao(PedidoTipoNegociacaoEnum.NOVO);
        pedido.setPedidoTipo(PedidoTipoEnum.COMERCIAL);
        pedido.setTags("#leadProspectBi");
        this.pedidoService.salvar(pedido);
    }

    private String getCompl(VivoProspectBiEstrutura vpbe) {
        StringBuilder s = new StringBuilder();
        s.append("Lead Prospect BI<BR>").append("Criamos esta lead porque no dia ").append(vpbe.getDataHora().format(FormatDate.DATE_BR.toDTF())).append(" este cliente estava sem cobertura e hoje ").append(LocalDate.now()).append(" consta cobertura com flag 3 <BR><BR>").append("Acesse o cadastro do cliente para visualizar os contatos. <BR><BR>").append("Caso necess\u00e1rio utilize nossa ferramenta de enriquecimento.<BR><BR>").append("N\u00f3s trabalhamos muito para ajudar voc\u00ea a vender mais.<BR>Aproveite a LEAD e boas vendas!!");
        return s.toString();
    }
}

