/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.InformationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.whatsapp.WhatsAppCadastroView;
import br.com.system.app.features.whatsapp.WhatsAppRespostaDialog;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.service.WhatsAppBloqueioService;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppCreateService;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.app.features.whatsapp.service.WhatsAppRespostaService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.ValidationUtil;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class WhatsAppAtendimentoCreate
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    @Autowired
    private WhatsAppHaveService whatsAppHaveService;
    @Autowired
    private WhatsAppCreateService whatsAppCreateService;
    @Autowired
    private WhatsAppCadastroView whatsAppCadastroView;
    @Autowired
    private WhatsAppBloqueioService whatsAppBloqueioService;
    @Autowired
    private WhatsAppRespostaService respostaService;
    private final TextField fieldTelefone = new TextField("Telefone");
    private final TextField fieldCnpj = new TextField("Cnpj");
    private final TextField fieldNome = new TextField("Nome Contato");
    private final Grid<WhatsApp> grid = new Grid(WhatsApp.class);
    private final TextArea txtMensagem = new TextArea("Mensagem");
    private WhatsApp whatsapp;
    private Pedido pedido;
    private EstruturaUsuario eu;
    private Registration registrationCadastro;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.clear();
    }

    private void clear() {
        if (this.registrationCadastro != null) {
            this.registrationCadastro.remove();
        }
    }

    public void create(EstruturaUsuario eu) {
        this.create(null, null, eu);
    }

    public void create(WhatsApp w, EstruturaUsuario eu) {
        this.create(w, null, eu);
    }

    public void create(WhatsApp w, Pedido pedido, EstruturaUsuario eu) {
        try {
            this.eu = eu;
            this.pedido = pedido;
            this.whatsapp = w;
            this.clear();
            this.removeAll();
            this.fieldTelefone.setVisible(this.whatsapp == null);
            this.fieldCnpj.setVisible(this.whatsapp == null);
            this.fieldNome.setVisible(this.whatsapp == null);
            this.grid.setVisible(this.whatsapp == null);
            this.grid.setHeight("250px");
            this.txtMensagem.setWidthFull();
            this.txtMensagem.setHeight("250px");
            WhatsAppRespostaDialog respostaDialog = new WhatsAppRespostaDialog(this.respostaService);
            Button btnResp = UIUtils.createSmallButton((String)"Respostas Prontas", (VaadinIcon)VaadinIcon.FONT);
            btnResp.addClickListener((ComponentEventListener & Serializable)e -> {
                respostaDialog.show();
                respostaDialog.addOpenedChangeListener((ComponentEventListener & Serializable)cl -> {
                    if (!cl.isOpened()) {
                        this.txtMensagem.setValue(respostaDialog.getMensagem());
                    }
                });
            });
            this.setWidth("900px");
            if (this.whatsapp == null) {
                this.add(new com.vaadin.flow.component.Component[]{this.filtros()});
            }
            this.add(new com.vaadin.flow.component.Component[]{this.grid()});
            this.add(new com.vaadin.flow.component.Component[]{this.txtMensagem});
            this.add(new com.vaadin.flow.component.Component[]{btnResp});
            this.add(new com.vaadin.flow.component.Component[]{this.footer()});
            this.open();
            if (pedido != null) {
                this.fieldCnpj.setValue(pedido.getCliente().getCpfCnpj());
                this.povoa();
            }
        }
        catch (Exception e2) {
            UIUtils.showError((String)e2.getMessage());
        }
    }

    private Grid<WhatsApp> grid() {
        this.grid.setColumns(new String[0]);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNumero()))).setHeader("Telefone").setFlexGrow(0).setWidth("150px");
        if (this.isNeoCrm()) {
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getLogin()))).setHeader("Login").setFlexGrow(0).setWidth("150px");
        }
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNome()))).setHeader("Nome Contato").setFlexGrow(0).setWidth("250px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getCpfCnpj()))).setHeader("Cnpj(s)").setFlexGrow(0).setWidth("300px");
        return this.grid;
    }

    private HorizontalContainer filtros() {
        Button btnF = UIUtils.createSmallButton((String)"Pesquisar", (VaadinIcon)VaadinIcon.SEARCH);
        btnF.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.fieldTelefone.getValue() != null && this.fieldTelefone.getValue().length() > 11 && this.fieldTelefone.getValue().startsWith("55")) {
                this.fieldTelefone.setValue(this.fieldTelefone.getValue().substring(2));
            }
            this.grid.setItems(new ArrayList());
            if (this.fieldTelefone.getValue() == null && this.fieldCnpj.getValue().isEmpty() && this.fieldNome.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Informe pelo menos um telefone ou um Cnpj ou um nome");
                return;
            }
            if (this.fieldTelefone.getValue() != null && !this.fieldTelefone.getValue().isEmpty() && this.fieldCnpj.getValue() != null && !this.fieldCnpj.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Informe um telefone OU um Cnpj");
                return;
            }
            this.povoa();
        });
        Button btnCadastro = UIUtils.createSmallButton((String)"Cadastrar Novo");
        btnCadastro.setVisible(this.whatsapp == null);
        btnCadastro.setEnabled(this.hasPermission("ATENDIMENTO_CREATE"));
        btnCadastro.addClickListener((ComponentEventListener & Serializable)e -> {
            this.whatsAppCadastroView.create(null, this.pedido == null ? null : this.pedido.getCliente().getCpfCnpj());
            this.registrationCadastro = this.whatsAppCadastroView.addOpenedChangeListener((ComponentEventListener & Serializable)wcv -> {
                if (!wcv.isOpened()) {
                    this.povoa();
                }
            });
        });
        Button btnPencil = UIUtils.createSmallButton((String)"Editar", (VaadinIcon)VaadinIcon.PENCIL);
        btnPencil.setVisible(this.whatsapp == null);
        btnPencil.setEnabled(this.hasPermission("ATENDIMENTO_CREATE"));
        btnPencil.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.grid.getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione um cadastro para editar");
                return;
            }
            this.whatsAppCadastroView.create((WhatsApp)this.grid.getSelectedItems().iterator().next(), this.pedido == null || this.pedido.getCliente() == null ? null : this.pedido.getCliente().getCpfCnpj());
        });
        HorizontalContainer h = new HorizontalContainer(new com.vaadin.flow.component.Component[0]);
        h.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Criar Atendimento")});
        h.add(new com.vaadin.flow.component.Component[]{this.fieldTelefone, this.fieldCnpj, this.fieldNome, btnF, btnPencil, btnCadastro});
        return h;
    }

    private void povoa() {
        if (this.fieldTelefone.getValue() != null && !this.fieldTelefone.getValue().isEmpty()) {
            WhatsAppHave have = this.whatsAppHaveService.getHave(this.fieldTelefone.getValue());
            if (have != null && have.getHave().booleanValue()) {
                WhatsAppConta wc;
                if (this.eu.getUsuario().getWhatsappConta() != null) {
                    wc = this.eu.getUsuario().getWhatsappConta();
                } else {
                    List contas = this.whatsappContaService.getContaByEstruturaAndAtendimentoAndMarketing(this.eu.getEstrutura(), true, false);
                    if (contas.isEmpty()) {
                        UIUtils.showNotification((String)"Esta estrutura nao tem whatsapp instalado");
                        return;
                    }
                    wc = (WhatsAppConta)contas.get(0);
                }
                WhatsApp itens = this.whatsAppService.getAtendimentoByNumero(wc, have.getNumeroWhats());
                if (itens != null) {
                    this.grid.setItems((Object[])new WhatsApp[]{itens});
                }
            } else {
                UIUtils.showNotification((String)"Este n\u00famero n\u00e3o tem whats");
            }
            have = null;
        } else if (this.fieldNome.getValue() != null && !this.fieldNome.getValue().isEmpty()) {
            this.grid.setItems((Collection)this.whatsAppService.getByNomeContato(this.getEstrutura(), this.fieldNome.getValue()));
        } else if (this.fieldCnpj.getValue() != null && !this.fieldCnpj.getValue().isEmpty()) {
            if (!ValidationUtil.isValidCnpjAndCpf((String)this.fieldCnpj.getValue())) {
                UIUtils.showNotification((String)"CNPJ inv\u00e1lido");
                return;
            }
            List lista = this.whatsAppService.getByCpfCnpj(this.fieldCnpj.getValue(), this.getEstrutura());
            this.grid.setItems((Collection)(lista == null ? new ArrayList() : lista));
        } else {
            this.grid.setItems(new ArrayList());
        }
    }

    private FooterContainer footer() {
        Button btnC = UIUtils.createSmallButton((String)"Criar", (VaadinIcon)VaadinIcon.MAGIC);
        btnC.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.whatsapp == null && this.grid.getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione um item para criar o atendimento");
                return;
            }
            if (this.whatsapp == null) {
                this.whatsapp = this.whatsAppService.getById(((WhatsApp)this.grid.getSelectedItems().iterator().next()).getId());
            }
            if (this.whatsAppBloqueioService.isBloqueado(this.getEstrutura(), this.whatsapp.getNumero())) {
                UIUtils.showNotification((String)("Este n\u00famero " + this.whatsapp.getNumero() + " est\u00e1 bloqueado, imposs\u00edvel criar atendimento"));
                return;
            }
            if (this.txtMensagem.getValue() == null || this.txtMensagem.getValue().isEmpty()) {
                ConfirmationDialog cd = new ConfirmationDialog("Criar Atendimento sem enviar mensagem", "Voc\u00ea est\u00e1 criando um atendimento sem enviar nenhuma mensagem. Confirma?");
                cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                    this.criarChamado();
                    cd.close();
                });
            } else {
                this.criarChamado();
            }
        });
        Button btnF = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnF.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        return new FooterContainer(new com.vaadin.flow.component.Component[]{btnF, btnC});
    }

    private void criarChamado() {
        if (this.getUsuario().getWhatsappConta() != null) {
            this.whatsapp.setWhatsappConta(this.getUsuario().getWhatsappConta());
        }
        if (ValidationUtil.isValidCnpjAndCpf((String)this.whatsapp.getCpfCnpj())) {
            this.criar(this.whatsapp, this.getEu(), this.whatsapp.getCpfCnpj(), this.txtMensagem.getValue());
        } else {
            if (this.whatsapp.getCpfCnpj() == null) {
                this.criar(this.whatsapp, this.getEu(), null, this.txtMensagem.getValue());
                return;
            }
            Object[] arrC = this.whatsapp.getCpfCnpj().split(",");
            if (arrC.length == 1) {
                this.criar(this.whatsapp, this.getEu(), arrC[0], this.txtMensagem.getValue());
            } else {
                Dialog d = new Dialog();
                ComboBox cnpjs = new ComboBox("Escolha o CNPJ", arrC);
                Button bf = UIUtils.createSmallButton((String)"Fechar");
                bf.addClickListener((ComponentEventListener & Serializable)buceta -> d.close());
                Button bc = UIUtils.createSmallButton((String)"Confirmar");
                bc.addClickListener((ComponentEventListener & Serializable)kct -> {
                    if (cnpjs.getValue() == null) {
                        UIUtils.showNotification((String)"Escolha um CNPJ");
                        return;
                    }
                    this.criar(this.whatsapp, this.getEu(), (String)cnpjs.getValue(), this.txtMensagem.getValue());
                    d.close();
                });
                d.add(new com.vaadin.flow.component.Component[]{cnpjs, new FooterContainer(new com.vaadin.flow.component.Component[]{bf, bc})});
                d.open();
            }
        }
    }

    private void criar(WhatsApp w, EstruturaUsuario eu, String cpfCnpj, String msg) {
        try {
            this.whatsAppCreateService.criar(w, eu, cpfCnpj, msg, this.pedido);
            this.close();
            UIUtils.showNotification((String)"Atendimento criado com sucesso");
        }
        catch (Exception e) {
            InformationDialog.show((String)"Imposs\u00edvel abrir atendimento", (String)e.getMessage());
        }
    }
}

