/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.whatsapp.WhatsAppConversasDialog;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class WhatsAppAtendimentoDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppAtendimentoService service;
    @Autowired
    private WhatsAppConversasDialog conversasDialog;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void show(WhatsApp w, String cnpj) {
        this.removeAll();
        this.setWidth("800px");
        VerticalContainer main = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        main.setWidthFull();
        main.setHeightFull();
        main.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"CONVERSAS")});
        List lista = this.service.getByWhatsapp(w, cnpj);
        Grid grid = new Grid(WhatsAppAtendimento.class);
        grid.setItems((Collection)lista);
        grid.setColumns(new String[0]);
        grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.isFechado() ? "Fechado" : "Aberto")).setHeader("Status").setFlexGrow(0).setWidth("100px");
        grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> UIUtils.formatDateTime((LocalDateTime)p.getDataHoraInicio()))).setHeader("Inicio").setFlexGrow(0).setWidth("180px").setResizable(true);
        grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHoraFim() == null ? "" : UIUtils.formatDateTime((LocalDateTime)p.getDataHoraFim()))).setHeader("Fim").setFlexGrow(0).setWidth("180px").setResizable(true);
        grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Span label = UIUtils.createBreakWrapSpan((String)eg.getAtendente().getUsuario().getNome());
            return label;
        })).setHeader("Usu\u00e1rio").setWidth("250px").setResizable(true);
        Button bClose = UIUtils.createSmallButton((String)"Fechar");
        bClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        grid.addItemClickListener((ComponentEventListener & Serializable)e -> this.conversasDialog.show((WhatsAppAtendimento)e.getItem()));
        main.add(new com.vaadin.flow.component.Component[]{grid, new FooterContainer(new com.vaadin.flow.component.Component[]{bClose})});
        this.add(new com.vaadin.flow.component.Component[]{main});
        this.open();
    }
}

