/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.waha.WahaQrcodeView;
import br.com.system.app.features.waha.service.WahaService;
import br.com.system.app.features.whatsapp.WhatsAppContaFormView;
import br.com.system.app.features.whatsapp.dto.WhatsAppFornecedorEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="cadastro-contas-whatsapp", layout=MainLayout.class)
@PageTitle(value="Cadastro de contas de Whatsapp")
@RolesAllowed(value={"WHATSAPP_CONTA_VIEW"})
public class WhatsAppContaView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final WhatsAppContaService wcs;
    private final WhatsAppContaFormView formView;
    private final WahaService wahaService;
    private GridCrud<WhatsAppConta> crud;

    @Autowired
    public WhatsAppContaView(WhatsAppContaService wcs, WhatsAppContaFormView formView, WahaService wahaService) {
        this.wcs = wcs;
        this.wahaService = wahaService;
        this.formView = formView;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        Button btnAdd = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PLUS, (String)"Adicionar nova conta");
        btnAdd.setVisible(this.isMaster());
        btnAdd.addClickListener((ComponentEventListener & Serializable)e -> {
            this.formView.create(new WhatsAppConta());
            this.formView.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                if (!close.isOpened()) {
                    this.crud.refreshGrid();
                }
            });
        });
        Button btnEdit = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.PENCIL, (String)"Editar conta");
        btnEdit.setVisible(this.isMaster());
        btnEdit.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().isEmpty()) {
                this.showNotification("Selecione uma conta para editar");
                return;
            }
            this.formView.create((WhatsAppConta)this.crud.getGrid().getSelectedItems().iterator().next());
            this.formView.addOpenedChangeListener((ComponentEventListener & Serializable)close -> {
                if (!close.isOpened()) {
                    this.crud.refreshGrid();
                }
            });
        });
        Button btnQrcode = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.QRCODE, (String)"Ler QRCODE");
        btnQrcode.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.crud.getGrid().getSelectedItems().isEmpty()) {
                this.showNotification("Selecione uma conta para CONECTAR");
                return;
            }
            WhatsAppConta conta = (WhatsAppConta)this.crud.getGrid().getSelectedItems().iterator().next();
            if (!conta.getFornecedor().equals((Object)WhatsAppFornecedorEnum.NEO)) {
                this.showNotification("Apenas contas NEO podem ser conectadas");
                return;
            }
            try {
                String statusSession = this.wahaService.getStatusSession(conta.getMooseId());
                if (!statusSession.equals("SCAN_QR_CODE")) {
                    this.showNotification("O numero esta no status " + statusSession + " primeiro precisa inicializa-lo e aguardar aparecer o status SCAN_QR_CODE");
                    return;
                }
                WahaQrcodeView qrcode = new WahaQrcodeView(this.getUsuario(), conta, this.wahaService);
                qrcode.addOpenedChangeListener((ComponentEventListener & Serializable)qr -> {
                    if (!qr.isOpened()) {
                        this.crud.refreshGrid();
                    }
                });
            }
            catch (Exception ex) {
                this.showNotification(ex.getMessage());
            }
        });
        Button btnConnect = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.SIGN_IN, (String)"Conectar");
        btnConnect.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Conectar Instancia", "Confirma a conex\u00e3o desta instancia?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cnace -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                cd.close();
                if (this.crud.getGrid().getSelectedItems().isEmpty()) {
                    this.showNotification("Selecione uma conta para CONECTAR");
                    return;
                }
                WhatsAppConta conta = (WhatsAppConta)this.crud.getGrid().getSelectedItems().iterator().next();
                if (!conta.getFornecedor().equals((Object)WhatsAppFornecedorEnum.NEO)) {
                    this.showNotification("Apenas contas NEO podem ser conectadas");
                    return;
                }
                try {
                    String statusSession = this.wahaService.getStatusSession(conta.getMooseId());
                    if (statusSession == null) {
                        this.wahaService.saveSession(conta, this.getEu(), conta.getUrlWebhook());
                        this.crud.refreshGrid();
                        this.showNotification("Conta inexiste, criando, aguarde alguns instantes para inicializar");
                        return;
                    }
                    if (statusSession.equals("WORKING")) {
                        this.showNotification("Numero ja esta ativo e funcional. Caso haja algum problema, desconecte e conecte novamente");
                        return;
                    }
                    if (statusSession.equals("STOPPED")) {
                        this.wahaService.changeStatusSession(conta.getMooseId(), "start");
                        this.crud.refreshGrid();
                        this.showNotification("Numero esta sendo iniciado, aguarde alguns instantes e depois Leia o QRCODE");
                        return;
                    }
                    if (statusSession.equals("SCAN_QR_CODE")) {
                        this.showNotification("Numero ja esta inicializado, clique em LER QRCODE");
                    } else {
                        this.showNotification("Para ler o QRCODE o status deve ser SCAN_QR_CODE, se estiver STTOPED, por favor clique em iniciar, se estiver inicializando, aguarde mais alguns instantes e clique em LER QRCODE");
                    }
                }
                catch (Exception ex) {
                    this.showNotification("Erro ao conectar " + ex.getMessage());
                }
                this.crud.refreshGrid();
            });
        });
        Button btnDisconnect = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.SIGN_OUT, (String)"Desconectar");
        btnDisconnect.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Desconexao Instancia", "Confirma a Desconex\u00e3o desta instancia?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cnace -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                cd.close();
                if (this.crud.getGrid().getSelectedItems().isEmpty()) {
                    this.showNotification("Selecione uma conta para DESCONECTAR");
                    return;
                }
                WhatsAppConta conta = (WhatsAppConta)this.crud.getGrid().getSelectedItems().iterator().next();
                if (!conta.getFornecedor().equals((Object)WhatsAppFornecedorEnum.NEO)) {
                    this.showNotification("Apenas contas NEO podem ser desconectadas");
                    return;
                }
                try {
                    this.wahaService.changeStatusSession(conta.getMooseId(), "stop");
                    this.showNotification("Desconectada com sucesso");
                }
                catch (Exception ex) {
                    this.showNotification(ex.getMessage());
                }
                this.crud.refreshGrid();
            });
        });
        this.crud = new GridCrud(WhatsAppConta.class);
        this.crud.getCrudLayout().addToolbarComponent((Component)new HorizontalContainer(new Component[]{btnAdd, btnEdit, btnConnect, btnQrcode, btnDisconnect}));
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNumero()))).setHeader("N\u00famero").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)(p.isAtivo() ? "ATIVO" : "INATIVO")))).setHeader("Ativo").setFlexGrow(0).setWidth("120px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getTemplateName()))).setHeader("Template Name").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getMooseId()))).setHeader("Token").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getFornecedor().name()))).setHeader("Fornecedor").setFlexGrow(0).setWidth("200px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            try {
                if (p.getFornecedor().equals((Object)WhatsAppFornecedorEnum.NEO)) {
                    String status = this.wahaService.getStatusSession(p.getMooseId());
                    Span span = UIUtils.createBreakWrapSpan((String)status);
                    if (status.equals("STOPPED")) {
                        span.getStyle().set("color", Color.WHITE.getValue());
                        span.getStyle().set("background-color", Color.RED.getValue());
                    } else if (status.equals("STARTING")) {
                        span.getStyle().set("color", Color.WHITE.getValue());
                        span.getStyle().set("background-color", Color.BLUE.getValue());
                    } else if (status.equals("WORKING")) {
                        span.getStyle().set("color", Color.WHITE.getValue());
                        span.getStyle().set("background-color", Color.GREEN.getValue());
                    } else if (status.equals("SCAN_QR_CODE")) {
                        span.getStyle().set("color", Color.WHITE.getValue());
                        span.getStyle().set("background-color", Color.ORANGE.getValue());
                    }
                    return span;
                }
                return new Span();
            }
            catch (Exception ex) {
                return new Div();
            }
        })).setHeader("Status").setFlexGrow(0).setWidth("160px");
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }
}

