/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.MainLayout;
import br.com.system.app.components.Card;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.creditos.CreditosCompraView;
import br.com.system.app.features.creditos.CreditosExtratoView;
import br.com.system.app.features.creditos.CreditosTransferView;
import br.com.system.app.features.creditos.service.CreditosService;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.shared.handle.HandlerExcel;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.features.whatsapp.model.WhatsAppHaveFile;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveExportService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.SleepUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import elemental.json.Json;
import elemental.json.JsonValue;
import jakarta.annotation.security.PermitAll;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="whatsapp-have", layout=MainLayout.class)
@PageTitle(value="Consulta se n\u00famero tem ou n\u00e3o Whatsapp")
@PermitAll
public class WhatsAppHaveView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final WhatsAppHaveExportService whatsAppHaveExportService;
    private final UsuarioHierarquiaService hierarquiaService;
    private final UsuarioService usuarioService;
    private final CreditosService creditosService;
    private final EstruturaUsuarioService eus;
    private final CreditosCompraView creditosCompraView;
    private final TextField saldo = new TextField("Seus cr\u00e9ditos");
    private final GridCrud<WhatsAppHaveFile> crud = new GridCrud(WhatsAppHaveFile.class);
    private final HandlerExcel handlerExcel = new HandlerExcel();
    private String nomeArquivo = "";
    private TempFileMultiBuffer mBuffer;
    private ListField txtTelefones;
    private DownloadDialog dd;
    private TextArea taForce;
    private Button btnForcar;

    @Autowired
    public WhatsAppHaveView(WhatsAppHaveExportService whatsAppHaveExportService, UsuarioHierarquiaService hierarquiaService, UsuarioService usuarioService, CreditosService creditosService, EstruturaUsuarioService eus, CreditosCompraView creditosCompraView) {
        this.creditosCompraView = creditosCompraView;
        this.hierarquiaService = hierarquiaService;
        this.whatsAppHaveExportService = whatsAppHaveExportService;
        this.eus = eus;
        this.creditosService = creditosService;
        this.usuarioService = usuarioService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.dd = new DownloadDialog();
        this.saldo.setReadOnly(true);
        Button btnAtualizarSaldo = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.REFRESH, (String)"Atualizar Saldo");
        btnAtualizarSaldo.addClickListener((ComponentEventListener & Serializable)e -> this.atualizarSaldo());
        Button btnExtrato = UIUtils.createSmallButton((String)"Extrato");
        btnExtrato.addClickListener((ComponentEventListener & Serializable)e -> {
            CreditosExtratoView cv = new CreditosExtratoView(this.creditosService);
            cv.create();
            cv.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> {
                cv.close();
                this.atualizarSaldo();
            });
        });
        Button btnComprarCreditos = UIUtils.createSmallButton((String)"Comprar Cr\u00e9ditos");
        btnComprarCreditos.addClickListener((ComponentEventListener & Serializable)e -> {
            this.creditosCompraView.create(this.getEu());
            this.creditosCompraView.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> {
                this.creditosCompraView.close();
                this.atualizarSaldo();
            });
        });
        Button btnTransferir = UIUtils.createSmallButton((String)"Transferir Cr\u00e9ditos");
        btnTransferir.addClickListener((ComponentEventListener & Serializable)e -> {
            CreditosTransferView ctv = new CreditosTransferView(this.getEu(), this.creditosService, this.eus, this.hierarquiaService);
            ctv.create();
            ctv.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> {
                ctv.close();
                this.atualizarSaldo();
            });
        });
        this.taForce = new TextArea();
        this.taForce.setHeight("400px");
        this.btnForcar = UIUtils.createSmallButton((String)"Forcar");
        this.btnForcar.addClickListener((ComponentEventListener & Serializable)e -> {
            String[] arr;
            if (this.taForce.getValue() == null) {
                this.showNotification("Informe pelo menos um numero para forcar");
                return;
            }
            for (String tel : arr = this.taForce.getValue().split("\n")) {
                this.whatsAppHaveExportService.have(tel, true);
            }
            this.showNotification("Finalizado");
            this.taForce.clear();
        });
        VerticalContainer v = new VerticalContainer(new Component[0]);
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.saldo, btnAtualizarSaldo, btnExtrato, btnComprarCreditos, btnTransferir}).setSpacingOn()});
        v.add(new Component[]{new HorizontalContainer(new Component[]{this.createUpload(), this.createCampanha(), this.getForce()}).setSpacingOn()});
        v.add(new Component[]{this.getGrid()});
        this.atualizarSaldo();
        return v;
    }

    private GridCrud<WhatsAppHaveFile> getGrid() {
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNomeArquivo()))).setHeader("Nome").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHora().format(FormatDate.DATETIME_BR.toDTF()))).setHeader("Data/Hora");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getStatusAnalise().name())).setHeader("Status");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getObservacao()))).setHeader("Observa\u00e7\u00e3o").setFlexGrow(0).setWidth("250px");
        this.crud.getGrid().addComponentColumn((ValueProvider & Serializable)item -> {
            Button b = UIUtils.createSmallButton((String)"Download");
            b.setVisible(item.getHashArquivo() != null && !item.getHashArquivo().isEmpty());
            b.addClickListener((ComponentEventListener & Serializable)e -> {
                String hash = item.getHashArquivo() == null ? "" : item.getHashArquivo();
                this.dd.open(hash, item.getNomeArquivo());
            });
            return b;
        }).setHeader("Download");
        this.crud.getCrudFormFactory().setVisibleProperties(new String[0]);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(this.isMaster());
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }

    private Card createUpload() {
        this.mBuffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)this.mBuffer);
        upload.setMaxFiles(1);
        upload.setAcceptedFileTypes(new String[]{".xlsx"});
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            this.nomeArquivo = e.getFileName();
            UIUtils.showNotification((String)"Arquivo carregado, clique em processar");
        });
        upload.addFileRejectedListener((ComponentEventListener & Serializable)event -> UIUtils.showNotification((String)"Formato inv\u00e1lido, apenas .xlxs"));
        Button processar = UIUtils.createSmallButton((String)(this.getTipoEstrutura().equals((Object)EstruturaTipoEnum.CLARO) ? "Inserir" : "Processar"), (VaadinIcon)VaadinIcon.COGS, (String)"Iniciar processamento");
        processar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.nomeArquivo.isEmpty()) {
                UIUtils.showNotification((String)"Selecione o arquivo.");
            } else {
                try {
                    Set numeros = this.handlerExcel.getValueFirstColumn(this.mBuffer.getInputStream());
                    this.whatsAppHaveExportService.processarLote(this.getEu(), this.nomeArquivo, numeros);
                    UIUtils.showProcessNotification();
                    this.nomeArquivo = "";
                    this.mBuffer.clear();
                }
                catch (Exception ex) {
                    this.showNotification(ex.getMessage());
                }
                SleepUtil.inSeconds((Integer)3);
                upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
                SleepUtil.inSeconds((Integer)3);
                this.crud.refreshGrid();
            }
        });
        Card card = new Card();
        card.setHeader("Upload arquivos");
        card.setContent(new Component[]{upload});
        card.setFooter(new Component[]{processar});
        card.getContentBox().setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        card.getContentBox().setHeightFull();
        card.setWidth("400px");
        card.setHeightFull();
        return card;
    }

    private Component createCampanha() {
        TextField txtNomeProcesso = new TextField();
        txtNomeProcesso.setLabel("Nome Campanha");
        this.txtTelefones = new ListField(ListFieldTypeEnum.TELEFONE, "Telefones");
        Button btnLista = UIUtils.createSmallButton((String)"Processar", (VaadinIcon)VaadinIcon.COGS, (String)"Iniciar processamento");
        btnLista.addClickListener((ComponentEventListener & Serializable)event -> {
            if (txtNomeProcesso.isEmpty() || this.txtTelefones.isEmpty()) {
                UIUtils.showNotification((String)"Nome Campanha e lista Cnpj's s\u00e3o obrigat\u00f3rios.");
            } else {
                try {
                    this.whatsAppHaveExportService.processarLote(this.getEu(), txtNomeProcesso.getValue() + ".xlsx", this.txtTelefones.getValue());
                }
                catch (Exception ex) {
                    this.showNotification(ex.getMessage());
                    return;
                }
                SleepUtil.inSeconds((Integer)3);
                UIUtils.showProcessNotification();
                this.crud.refreshGrid();
                txtNomeProcesso.setValue("");
                this.txtTelefones.clear();
            }
        });
        Card card = new Card();
        card.setHeader("Campanha processo");
        card.setContent(new Component[]{txtNomeProcesso, this.txtTelefones});
        card.setFooter(new Component[]{btnLista});
        card.getContentBox().setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        card.getContentBox().setHeightFull();
        card.setWidth("400px");
        return card;
    }

    private void atualizarSaldo() {
        BigDecimal saldoUsuario = this.usuarioService.getCreditos(this.getEu().getUsuario());
        if (saldoUsuario == null) {
            saldoUsuario = BigDecimal.ZERO;
        }
        this.saldo.setValue("R$ " + saldoUsuario.toString());
    }

    private Card getForce() {
        Card card = new Card();
        card.setHeader("Forcar N\u00fameros");
        card.setContent(new Component[]{this.taForce});
        card.setFooter(new Component[]{this.btnForcar});
        card.getContentBox().setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        card.getContentBox().setHeightFull();
        card.setWidth("400px");
        card.setHeightFull();
        card.setVisible(this.isMaster());
        return card;
    }
}

