/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.AudioPlayer;
import br.com.system.app.components.Card;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.size.FontSize;
import br.com.system.app.features.layout.util.BorderStyle;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.layout.util.WhiteSpace;
import br.com.system.app.features.shared.model.TranscricaoAudio;
import br.com.system.app.features.shared.service.TranscricaoAudioService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.whatsapp.model.WhatsAppContentTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagemTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResource;
import com.vdurmont.emoji.EmojiParser;
import java.io.Serializable;

public class WhatsAppMessageView
implements SecurityContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private final HorizontalContainer imgContainer = new HorizontalContainer(new Component[0]);
    private WhatsAppMensagem message;
    private Boolean found = false;
    private boolean isDark = false;

    public WhatsAppMensagem getMessage() {
        return this.message;
    }

    public boolean isFound(WhatsAppMensagem m, FlexBoxLayout divMensagem) {
        this.found = false;
        divMensagem.getChildren().forEach(e -> {
            try {
                FlexBoxLayout v = (FlexBoxLayout)e;
                if (((String)v.getId().get()).equals(m.getId().toString())) {
                    this.found = true;
                }
            }
            catch (Exception ex) {
                UIUtils.showError((String)(m.getMessageId() + " ERRO: " + ex.getMessage()));
            }
        });
        return this.found;
    }

    public HorizontalContainer getMessage(WhatsAppMensagem m, TranscricaoAudioService tas, boolean darkTheme) {
        Image image;
        this.isDark = darkTheme;
        this.message = m;
        if (!darkTheme) {
            this.imgContainer.setBackgroundColor(Color.AZURE);
        }
        VerticalContainer container = this.getContainer(m);
        container.setId("container");
        HorizontalContainer whithSpace = this.getWhiteSpace();
        HorizontalContainer contentContainerH = this.getMessageContainer(m);
        Span msg = new Span();
        msg.setWidth("100%");
        UIUtils.setWhiteSpace((WhiteSpace)WhiteSpace.PRE_WRAP, (Component[])new Component[]{msg});
        msg.getStyle().set("word-wrap", "break-word");
        UIUtils.setFontSize((FontSize)FontSize.XS, (Component[])new Component[]{msg});
        if (m.getContent() != null && !m.getContent().isEmpty() && m.getFileName() == null) {
            String mensagem = EmojiParser.parseToUnicode((String)m.getContent().replace("\n", "<br>"));
            msg.getElement().setProperty("innerHTML", "<span>" + mensagem + "</span>");
            contentContainerH.add(new Component[]{msg});
        } else if (m.getContentTipo().equals((Object)WhatsAppContentTipoEnum.AUDIO)) {
            if (m.getUrlFile() != null && !m.getUrlFile().isEmpty()) {
                Button btnTranscription = UIUtils.createSmallButton((String)"Transcri\u00e7\u00e3o", (VaadinIcon)VaadinIcon.ELLIPSIS_CIRCLE, (String)"Transcri\u00e7\u00e3o do \u00e1udio");
                btnTranscription.addClickListener((ComponentEventListener & Serializable)t -> this.showTranscription(m.getTipo(), tas, m.getUrlFile()));
                AudioPlayer player = new AudioPlayer();
                player.setSource(StorageUtil.getUrlSign((String)m.getUrlFile(), (String)"bucket-neosales").getUrl());
                if (m.getContent() != null) {
                    String mensagem = EmojiParser.parseToUnicode((String)m.getContent().replace("\n", "<br>"));
                    msg.getElement().setProperty("innerHTML", "<span>" + mensagem + "</span>");
                    contentContainerH.add(new Component[]{new VerticalContainer(new Component[]{player, btnTranscription, msg})});
                } else {
                    contentContainerH.add(new Component[]{new VerticalContainer(new Component[]{player, btnTranscription})});
                }
            }
        } else if (m.getUrlFile() != null && !m.getUrlFile().isEmpty()) {
            VerticalContainer v = new VerticalContainer(new Component[0]).setPaddingOn();
            String text = m.getContent() != null && !m.getContent().isEmpty() ? m.getContent() : (m.getNomeOriginal() == null ? m.getFileName() : m.getNomeOriginal());
            msg.getElement().setProperty("innerHTML", "<span><BR>" + text + "<BR></span>");
            StreamResource srFile = StorageUtil.getStreamResource((String)m.getUrlFile(), (String)m.getFileName());
            if (srFile != null) {
                Anchor anchor = new Anchor((AbstractStreamResource)srFile, m.getFileName());
                anchor.setTarget("_blank");
                v.add(new Component[]{anchor});
                if (m.getContentTipo().equals((Object)WhatsAppContentTipoEnum.IMAGEM)) {
                    Image image2 = new Image((AbstractStreamResource)StorageUtil.getStreamResource((String)m.getUrlFile(), (String)m.getFileName()), "Imagem");
                    image2.setMaxWidth("250px");
                    image2.setMaxHeight("150px");
                    anchor.add(new Component[]{image2});
                    v.add(new Component[]{msg});
                } else {
                    v.add(new Component[]{msg});
                }
            } else {
                v.add(new Component[]{new Span("Este arquivo n\u00e3o pode ser recuperado")});
                v.add(new Component[]{msg});
            }
            v.getElement().getStyle().set("background", "transparent");
            contentContainerH.add(new Component[]{v});
        }
        HorizontalContainer main = new HorizontalContainer(new Component[0]);
        if (m.getTipo().equals((Object)WhatsAppMensagemTipoEnum.ENVIADA)) {
            main.add(new Component[]{whithSpace, container});
            msg.getElement().getStyle().set("text-align", "rigth");
        } else if (m.getTipo().equals((Object)WhatsAppMensagemTipoEnum.RECEBIDA)) {
            msg.getElement().getStyle().set("text-align", "left");
            main.add(new Component[]{container, whithSpace});
        } else if (m.getTipo().equals((Object)WhatsAppMensagemTipoEnum.ANOTACAO)) {
            container.setWidthFull();
            UIUtils.setTooltip((String)"Anota\u00e7\u00f5es, essa informa\u00e7\u00e3o N\u00c3O foi enviada para o contato", (Component[])new Component[]{container});
            msg.getElement().getStyle().set("text-align", "center");
            main.add(new Component[]{container});
            main.setBackgroundColor(Color.CORAL);
        }
        main.setId(m.getId().toString());
        main.setDataObject((Object)this.imgContainer);
        Image image3 = image = m.getTipo().equals((Object)WhatsAppMensagemTipoEnum.ANOTACAO) ? new Image("images/anotacao.png", "") : WhatsAppStatusEnum.getImage((WhatsAppStatusEnum)m.getStatus());
        if (image != null) {
            this.imgContainer.add(new Component[]{image});
        }
        contentContainerH.add(new Component[]{this.imgContainer});
        if (m.getObservacoes() != null && !m.getObservacoes().isEmpty()) {
            Span labelObs = UIUtils.createBreakWrapSpan((String)m.getObservacoes());
            UIUtils.setBorder((BorderStyle)BorderStyle.DOTTED, (String)"1px", (Component[])new Component[]{labelObs});
            container.add(new Component[]{labelObs});
        }
        container.add(new Component[]{contentContainerH, this.getFoot(m)});
        main.setWidthFull();
        return main;
    }

    private VerticalContainer getContainer(WhatsAppMensagem m) {
        VerticalContainer main = new VerticalContainer(new Component[0]);
        if (!this.isDark) {
            UIUtils.setShadow((Shadow)Shadow.XS, (Component[])new Component[]{main});
            if (m.getTipo().equals((Object)WhatsAppMensagemTipoEnum.ENVIADA)) {
                main.setBackgroundColor(Color.AZURE);
            } else if (m.getTipo().equals((Object)WhatsAppMensagemTipoEnum.ANOTACAO)) {
                main.setBackgroundColor(Color.GHOST_WHITE);
            }
        } else if (m.getTipo().equals((Object)WhatsAppMensagemTipoEnum.ANOTACAO)) {
            UIUtils.setBorder((BorderStyle)BorderStyle.DOTTED, (String)"5px", (Component[])new Component[]{main});
        } else {
            UIUtils.setBorder((BorderStyle)BorderStyle.DOTTED, (String)"2px", (Component[])new Component[]{main});
        }
        main.setWidth("60%");
        main.getElement().getStyle().set("padding-bottom", "5px");
        return main;
    }

    private HorizontalContainer getMessageContainer(WhatsAppMensagem m) {
        HorizontalContainer mensagem = new HorizontalContainer(new Component[0]).setSpacingOff();
        mensagem.setNoWrap();
        mensagem.setAlignItems(FlexComponent.Alignment.END);
        mensagem.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        mensagem.setWidth("98%");
        if (!this.isDark && m.getTipo().equals((Object)WhatsAppMensagemTipoEnum.ENVIADA)) {
            mensagem.setBackgroundColor(Color.AZURE);
        }
        return mensagem;
    }

    private Span getFoot(WhatsAppMensagem m) {
        Span foot = new Span();
        if (m.getTipo().equals((Object)WhatsAppMensagemTipoEnum.RECEBIDA)) {
            foot.setText((m.getWhatsappAtendimento().getWhatsapp().getNome() == null ? "" : m.getWhatsappAtendimento().getWhatsapp().getNome()) + " " + m.getDataHoraCriacao().format(FormatDate.DATETIME_BR.toDTF()));
            foot.getElement().getStyle().set("text-align", "left");
        } else {
            String login = m.getEstruturaUsuario().getUsuario().isMaster() ? "Bot" : m.getEstruturaUsuario().getUsuario().getLogin();
            foot.setText(login + " " + (m.getDataHoraCriacao() == null ? "" : m.getDataHoraCriacao().format(FormatDate.DATETIME_BR.toDTF())));
        }
        foot.setWidth("97%");
        UIUtils.setFontSize((FontSize)FontSize.XS, (Component[])new Component[]{foot});
        foot.getElement().getStyle().set("text-align", "right");
        return foot;
    }

    private HorizontalContainer getWhiteSpace() {
        HorizontalContainer whithSpace = new HorizontalContainer(new Component[0]);
        whithSpace.getElement().getStyle().set("background", "transparent");
        whithSpace.setWidth("35%");
        return whithSpace;
    }

    private void showTranscription(WhatsAppMensagemTipoEnum tipo, TranscricaoAudioService tas, String urlFile) {
        Dialog d = new Dialog();
        try {
            TranscricaoAudio ta = tas.get(urlFile);
            Card card = new Card();
            card.setMaxWidth("350px");
            Button btnClose = UIUtils.createSmallButton((String)"Fechar");
            btnClose.addClickListener((ComponentEventListener & Serializable)close -> d.close());
            Div div = new Div();
            div.getElement().setProperty("innerHTML", "<span style='font-size=small'><BR>" + ta.getTranscricao() + "<BR></span>");
            card.setContent(new Component[]{div});
            card.setHeader("Transcri\u00e7\u00e3o do \u00e1udio");
            card.setFooter(new Component[]{btnClose});
            d.add(new Component[]{card});
            d.setMaxWidth("400px");
            d.open();
        }
        catch (Exception e) {
            UIUtils.showNotification((String)"N\u00e3o consegui fazer a transcri\u00e7\u00e3o deste audio, desculpe");
            d.close();
        }
    }
}

