/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.dto.EstruturaUsuarioSimplifyDTO;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppSetores;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.app.features.whatsapp.service.WhatsAppSetoresService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.RandomUtil;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class WhatsAppTransfDialog
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private WhatsAppAtendenteService whatsAppAtendenteService;
    @Autowired
    private WhatsAppSendService send;
    @Autowired
    private WhatsAppControleService whatsAppControleService;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private EquipeService equipeService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private WhatsAppSetoresService whatsAppSetoresService;
    private Grid<EstruturaUsuarioSimplifyDTO> grid;
    private ComboBox<Equipe> cbEquipe;
    private ComboBox<WhatsAppSetores> cbSetores;
    private TextField txtNome;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void create(WhatsAppAtendimento wa) {
        this.removeAll();
        this.setWidth("600px");
        VerticalContainer main = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        main.setWidthFull();
        main.setHeightFull();
        main.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"USU\u00c1RIOS ONLINE")});
        this.cbEquipe = new ComboBox("Equipe", (Collection)this.equipeService.getEquipes(this.getEstrutura()));
        this.cbEquipe.setItemLabelGenerator(Equipe::getNome);
        this.cbEquipe.setWidth("200px");
        this.txtNome = new TextField("Nome ou Login");
        this.cbSetores = new ComboBox("Transferir para Setor", (Collection)this.whatsAppSetoresService.getByEstrutura(this.getEstrutura()));
        this.cbSetores.setItemLabelGenerator(WhatsAppSetores::getNome);
        this.grid = new Grid(EstruturaUsuarioSimplifyDTO.class);
        this.grid.setColumns(new String[0]);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("200px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getLogin()))).setHeader("Login").setFlexGrow(0).setWidth("200px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEquipeNome()))).setHeader("Equipe").setFlexGrow(0).setWidth("200px");
        Button bPesq = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.SEARCH, (String)"Pesquisar");
        bPesq.addClickListener((ComponentEventListener & Serializable)e -> this.povoa());
        Button bTransf = UIUtils.createSmallButton((String)"Transferir");
        bTransf.addClickListener((ComponentEventListener & Serializable)e -> {
            EstruturaUsuario euTransf;
            if (this.grid.getSelectedItems().size() <= 0 && this.cbSetores.getValue() == null) {
                UIUtils.showNotification((String)"Selecione um atendente ou um setor para transferir a conversa");
                return;
            }
            if (this.cbSetores.getValue() != null && this.grid.getSelectedItems().size() <= 0) {
                List atendentes = this.whatsAppAtendenteService.getBySetor(this.getEstrutura(), (WhatsAppSetores)this.cbSetores.getValue());
                if (atendentes.size() <= 0) {
                    UIUtils.showNotification((String)"N\u00e3o h\u00e1 atendentes ativos para esse setor");
                    return;
                }
                euTransf = ((WhatsAppAtendente)atendentes.get(RandomUtil.getRandom((Integer)0, (Integer)(atendentes.size() - 1)))).getEstruturaUsuario();
            } else {
                euTransf = this.eus.getById(((EstruturaUsuarioSimplifyDTO)this.grid.getSelectedItems().iterator().next()).getId());
            }
            if (euTransf.getId().equals(wa.getAtendente().getId())) {
                UIUtils.showNotification((String)"Este atendimento j\u00e1 est\u00e1 com essea atendente");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Transferencia", "Confirma transferencia para atendente " + euTransf.getUsuario().getNome() + "?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                WhatsApp w = wa.getWhatsapp();
                this.whatsAppAtendimentoService.reabrir(w, wa, euTransf);
                UIUtils.showNotification((String)"Transferido com sucesso!");
                WhatsAppMensagem m = this.send.sendMessageText(wa, euTransf, "Voc\u00ea foi transferido para atendente " + euTransf.getUsuario().getNome());
                this.whatsAppControleService.gravarNova(m, m.getStatus());
                this.notificacoesService.notify(euTransf, "Voc\u00ea recebeu um atendimento", "Cliente " + w.getNome() + " " + wa.getUltimaMensagem(), Boolean.valueOf(true), Boolean.valueOf(false), "kanban");
                if (wa.getPedido() != null) {
                    wa.getPedido().setEstruturaUsuario(euTransf);
                    this.pedidoService.salvar(wa.getPedido(), "Transferido para " + euTransf.getUsuario().getLogin(), this.getEu(), true);
                }
                cd.close();
                this.close();
            });
        });
        Button btnClose = UIUtils.createSmallButton((String)"Fechar");
        btnClose.addClickListener((ComponentEventListener & Serializable)close -> this.close());
        main.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.cbEquipe, this.txtNome, bPesq}), this.cbSetores, this.grid, new FooterContainer(new com.vaadin.flow.component.Component[]{btnClose, bTransf})});
        this.add(new com.vaadin.flow.component.Component[]{main});
        this.open();
        this.povoa();
    }

    private void povoa() {
        this.grid.setItems((Collection)this.eus.getSessaoAtiva(this.getEstrutura(), (Equipe)this.cbEquipe.getValue(), this.txtNome.getValue()));
    }
}

