/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteResponsavel;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.marketing.service.MarketingService;
import br.com.system.app.features.sessions.service.SessionsService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppSetores;
import br.com.system.app.features.whatsapp.repository.WhatsAppAtendenteRepository;
import br.com.system.commons.RandomUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppAtendenteService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppAtendenteRepository whatsAppAtendenteRepository;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private SessionsService sessionsService;
    @Autowired
    private MarketingService marketingService;

    public WhatsAppAtendente save(WhatsAppAtendente wa) {
        if (wa.getEstruturaUsuario() == null) {
            throw new BusinessException("Usu\u00e1rio \u00e9 obrigatorio");
        }
        return (WhatsAppAtendente)this.whatsAppAtendenteRepository.save((Object)wa);
    }

    public WhatsAppAtendente getById(Long id) {
        return (WhatsAppAtendente)this.whatsAppAtendenteRepository.findById((Object)id).get();
    }

    public List<WhatsAppAtendente> getByEstrutura(Estrutura estrutura) {
        return this.whatsAppAtendenteRepository.findByEstruturaUsuarioEstrutura(estrutura);
    }

    public List<WhatsAppAtendente> getBySetor(Estrutura estrutura, WhatsAppSetores setor) {
        return this.whatsAppAtendenteRepository.findByEstruturaUsuarioEstruturaAndWhatsappSetores(estrutura, setor);
    }

    public List<WhatsAppAtendente> getByEstrutura(Estrutura estrutura, Pageable pageable) {
        return this.whatsAppAtendenteRepository.findByEstruturaUsuarioEstrutura(estrutura, pageable);
    }

    public long countByEstrutura(Estrutura estrutura) {
        return this.whatsAppAtendenteRepository.countByEstruturaUsuarioEstrutura(estrutura);
    }

    public void delete(WhatsAppAtendente wa) {
        List m = this.marketingService.getByAtendente(wa);
        if (m != null && m.size() > 0) {
            throw new BusinessException("Este atendente est\u00e1 em uma campanha de marketing, impossivel excluir");
        }
        this.whatsAppAtendenteRepository.delete((Object)wa);
    }

    public WhatsAppAtendente getAtendente(EstruturaUsuario eu) {
        return this.whatsAppAtendenteRepository.findByEstruturaUsuario(eu);
    }

    public void setOnline(WhatsAppAtendente wa) {
        wa.setOnline(Boolean.TRUE);
        this.whatsAppAtendenteRepository.save((Object)wa);
    }

    public List<WhatsAppAtendente> getByConta(WhatsAppConta conta) {
        return this.whatsAppAtendenteRepository.findByEstruturaUsuarioUsuarioWhatsappContaAndEstruturaUsuarioAtivo(conta, true);
    }

    public void setOffline(EstruturaUsuario eu) {
        WhatsAppAtendente wa = this.whatsAppAtendenteRepository.findByEstruturaUsuario(eu);
        wa.setOnline(Boolean.FALSE);
        this.whatsAppAtendenteRepository.save((Object)wa);
    }

    public EstruturaUsuario getAtendenteOnline(WhatsApp w, EstruturaUsuario master) {
        return this.getAtendenteOnline(w, master, null);
    }

    public EstruturaUsuario getAtendenteOnline(WhatsApp w, EstruturaUsuario master, WhatsAppSetores setor) {
        List aOnline = this.getAtendentes(w.getWhatsappConta().getEstrutura(), setor, Boolean.valueOf(true), Boolean.valueOf(true));
        return this.getAtendente(w, master, setor, aOnline);
    }

    public EstruturaUsuario getAtendente(WhatsApp w, EstruturaUsuario master, WhatsAppSetores setor) {
        List all = this.getAtendentes(w.getWhatsappConta().getEstrutura(), setor, Boolean.valueOf(true), Boolean.valueOf(false));
        return this.getAtendente(w, master, setor, all);
    }

    private EstruturaUsuario getAtendente(WhatsApp w, EstruturaUsuario master, WhatsAppSetores setor, List<WhatsAppAtendente> atendentes) {
        EstruturaUsuario eu;
        if (w.getUltimoAtendente() != null && !w.getUltimoAtendente().getId().equals(master.getId())) {
            for (WhatsAppAtendente o : atendentes) {
                if (!o.getEstruturaUsuario().getId().equals(w.getUltimoAtendente().getId())) continue;
                return w.getUltimoAtendente();
            }
        }
        if (w.getCnpjEscolhido() == null) {
            // empty if block
        }
        if (w.getCnpjEscolhido() == null || w.getCnpjEscolhido().isEmpty()) {
            return master;
        }
        Cliente cliente = this.clienteService.getAndCreateCliente(master, w.getCnpjEscolhido(), new ClienteContato[0]);
        if (cliente == null) {
            eu = this.getDefault(atendentes, w);
            if (eu == null) {
                return this.getRandom(atendentes, master);
            }
            return eu;
        }
        if (cliente.getClienteResponsavel().size() <= 0) {
            eu = this.getDefault(atendentes, w);
            if (eu == null) {
                return this.getRandom(atendentes, master);
            }
            return eu;
        }
        for (ClienteResponsavel cr : cliente.getClienteResponsavel()) {
            EstruturaUsuario eu2 = this.getByEquipe(atendentes, cr.getEstruturaUsuario().getEquipe());
            if (eu2 != null) {
                return eu2;
            }
            eu2 = this.getDefault(atendentes, w);
            if (eu2 == null) continue;
            return eu2;
        }
        return master;
    }

    public EstruturaUsuario getRandom(EstruturaUsuario master) {
        List online = this.getAtendentesOnline(master.getEstrutura());
        return this.getRandom(online, master);
    }

    private EstruturaUsuario getRandom(List<WhatsAppAtendente> aOnline, EstruturaUsuario master) {
        if (aOnline.size() <= 0) {
            return master;
        }
        Integer ind = RandomUtil.getRandom((Integer)0, (Integer)(aOnline.size() - 1));
        WhatsAppAtendente online = aOnline.get(ind);
        return online.getEstruturaUsuario();
    }

    private EstruturaUsuario getDefault(List<WhatsAppAtendente> aOnline, WhatsApp w) {
        for (WhatsAppAtendente o : aOnline) {
            if (o.getEquipeIds() != null && !o.getEquipeIds().isEmpty()) continue;
            return o.getEstruturaUsuario();
        }
        return null;
    }

    private EstruturaUsuario getByEquipe(List<WhatsAppAtendente> aOnline, Equipe equipe) {
        if (equipe == null) {
            return null;
        }
        for (WhatsAppAtendente o : aOnline) {
            String[] arrEquipe;
            if (o.getEquipeIds() == null || o.getEquipeIds().isEmpty()) continue;
            EstruturaUsuario eu = null;
            for (String id : arrEquipe = o.getEquipeIds().split(",")) {
                if (!id.equals(equipe.getId().toString())) continue;
                eu = o.getEstruturaUsuario();
                break;
            }
            if (eu == null) continue;
            return eu;
        }
        return null;
    }

    public WhatsAppAtendente getFirstAtendenteOnline(Estrutura estrutura) {
        List l = this.getAtendentesOnline(estrutura);
        if (l.size() > 0) {
            return (WhatsAppAtendente)l.get(0);
        }
        return null;
    }

    public List<WhatsAppAtendente> getAtendentesOnline(Estrutura estrutura) {
        return this.getAtendentes(estrutura, null, Boolean.valueOf(true), Boolean.valueOf(true));
    }

    public List<WhatsAppAtendente> getAtendentesOnline(Estrutura estrutura, Boolean recebeAutomatico) {
        return this.getAtendentes(estrutura, null, recebeAutomatico, Boolean.valueOf(true));
    }

    public List<WhatsAppAtendente> getAtendentes(Estrutura estrutura, Boolean recebeAutomatico) {
        return this.whatsAppAtendenteRepository.findByEstruturaUsuarioEstruturaAndRecebeAutomaticoOrderByPrioritarioDesc(estrutura, recebeAutomatico.booleanValue());
    }

    public List<WhatsAppAtendente> getAtendentes(Estrutura estrutura, WhatsAppSetores setor, Boolean recebeAutomatico, Boolean justOnline) {
        ArrayList<WhatsAppAtendente> retorno = new ArrayList<WhatsAppAtendente>();
        List atendentes = recebeAutomatico == null ? (setor == null ? this.whatsAppAtendenteRepository.findByEstruturaUsuarioEstruturaOrderByPrioritarioDesc(estrutura) : this.whatsAppAtendenteRepository.findByEstruturaUsuarioEstruturaAndWhatsappSetoresOrderByPrioritarioDesc(estrutura, setor)) : (setor == null ? this.whatsAppAtendenteRepository.findByEstruturaUsuarioEstruturaAndRecebeAutomaticoOrderByPrioritarioDesc(estrutura, recebeAutomatico.booleanValue()) : this.whatsAppAtendenteRepository.findByEstruturaUsuarioEstruturaAndRecebeAutomaticoAndWhatsappSetoresOrderByPrioritarioDesc(estrutura, recebeAutomatico.booleanValue(), setor));
        for (WhatsAppAtendente atendente : atendentes) {
            if (!atendente.getAtivo().booleanValue() || !atendente.getEstruturaUsuario().isAtivo()) continue;
            if (justOnline.booleanValue()) {
                List sessoes = this.sessionsService.getAtivaByEu(atendente.getEstruturaUsuario());
                if (sessoes.size() <= 0) continue;
                retorno.add(atendente);
                continue;
            }
            retorno.add(atendente);
        }
        return retorno;
    }

    public void deleteByEstrutura(Estrutura e) {
        this.whatsAppAtendenteRepository.deleteByEstruturaUsuarioEstrutura(e);
    }
}

