/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppControle;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.commons.SleepUtil;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppCheckMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppControleService whatsAppControleService;
    private Boolean detachEu = false;
    private Boolean detachWa = false;

    public void setDetachEu(Boolean detachEu) {
        this.detachEu = detachEu;
    }

    public void setDetachWa(Boolean detachWa) {
        this.detachWa = detachWa;
    }

    @Async(value="asyncDefault")
    public void checkNewMessages(WhatsAppAtendimento wa, Consumer<WhatsAppControle> listener) {
        Thread.currentThread().setName("asyncDefault-checkNewMessages-wa-" + wa.getId());
        while (!this.detachWa.booleanValue()) {
            try {
                List lm = this.whatsAppControleService.getAll(wa);
                for (WhatsAppControle c : lm) {
                    listener.accept(c);
                    this.whatsAppControleService.delete(c);
                }
                SleepUtil.inSeconds((Integer)5);
            }
            catch (Exception exception) {}
        }
    }

    @Async(value="asyncDefault")
    public void checkNewMessages(EstruturaUsuario euAtendente, Consumer<WhatsAppControle> listener) {
        Thread.currentThread().setName("asyncDefault-checkNewMessages-eu-" + euAtendente.getId());
        while (!this.detachEu.booleanValue()) {
            try {
                List lm = this.whatsAppControleService.getNotificada(euAtendente, true);
                for (WhatsAppControle c : lm) {
                    c.setNotificada(Boolean.valueOf(true));
                    this.whatsAppControleService.save(c);
                    listener.accept(c);
                }
                SleepUtil.inSeconds((Integer)5);
            }
            catch (Exception exception) {}
        }
    }
}

