/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.service.TranscricaoAudioService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppContentTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagemTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.features.whatsapp.repository.WhatsAppMensagemRepository;
import com.vdurmont.emoji.EmojiParser;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppMensagemService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppMensagemRepository whatsAppMensagemRepository;
    @Autowired
    private TranscricaoAudioService transcricaoAudioService;

    public WhatsAppMensagem getByMessageId(String messageId) {
        return this.whatsAppMensagemRepository.findFirstByMessageIdOrderByIdDesc(messageId);
    }

    public List<WhatsAppMensagem> getByAtendimento(WhatsAppAtendimento wa) {
        return this.whatsAppMensagemRepository.findByWhatsappAtendimentoOrderByIdDesc(wa);
    }

    public List<WhatsAppMensagem> getByAtendimento(WhatsAppAtendimento wa, Pageable pageable) {
        return this.whatsAppMensagemRepository.findByWhatsappAtendimentoOrderByIdDesc(wa);
    }

    public List<WhatsAppMensagem> getByAtendimentoNoOrder(WhatsAppAtendimento wa) {
        return this.whatsAppMensagemRepository.findByWhatsappAtendimento(wa);
    }

    public void deleteMensage(WhatsAppMensagem m) throws Exception {
        if (m.getUrlFile() != null) {
            StorageUtil.deleteObject((String)m.getUrlFile());
        }
        if (m.getContentTipo().equals((Object)WhatsAppContentTipoEnum.AUDIO)) {
            try {
                this.transcricaoAudioService.deleteByHash(m.getUrlFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.whatsAppMensagemRepository.delete((Object)m);
    }

    public WhatsAppMensagem inserirAnotacao(WhatsAppAtendimento wa, EstruturaUsuario eu, String anotacao) {
        WhatsAppMensagem m = new WhatsAppMensagem();
        m.setContent(anotacao);
        m.setContentTipo(WhatsAppContentTipoEnum.TEXTO);
        m.setDataHoraCriacao(LocalDateTime.now());
        m.setEstruturaUsuario(eu);
        m.setStatus(WhatsAppStatusEnum.LIDA);
        m.setTipo(WhatsAppMensagemTipoEnum.ANOTACAO);
        m.setWhatsappAtendimento(wa);
        return this.saveMessage(m);
    }

    public WhatsAppMensagem saveMessage(WhatsAppMensagem wm) {
        if (wm.getEstruturaUsuario() == null) {
            wm.setEstruturaUsuario(wm.getWhatsappAtendimento().getAtendente());
        }
        if (wm.getContent() != null && !wm.getContent().isEmpty()) {
            wm.setContent(EmojiParser.parseToHtmlDecimal((String)wm.getContent()));
        } else if (wm.getButtons() != null && !wm.getButtons().isEmpty()) {
            wm.setContent("Bot\u00f5es " + wm.getButtons());
        }
        return (WhatsAppMensagem)this.whatsAppMensagemRepository.save((Object)wm);
    }

    public WhatsAppMensagem geMessagetById(Long id) {
        Optional opt = this.whatsAppMensagemRepository.findById((Object)id);
        if (!opt.isPresent()) {
            return null;
        }
        return (WhatsAppMensagem)opt.get();
    }

    public WhatsAppMensagem createTemplateMessage(EstruturaUsuario eu, WhatsAppAtendimento wa, String bodyText, String metaMessageId) {
        WhatsAppMensagem wm = new WhatsAppMensagem();
        wm.setContent(bodyText);
        wm.setContentTipo(WhatsAppContentTipoEnum.TEMPLATE);
        wm.setDataHoraCriacao(LocalDateTime.now());
        wm.setDataHoraEnvio(LocalDateTime.now());
        wm.setEstruturaUsuario(eu);
        wm.setMessageId(metaMessageId);
        wm.setStatus(WhatsAppStatusEnum.ENVIADA);
        wm.setTipo(WhatsAppMensagemTipoEnum.ENVIADA);
        wm.setWhatsappAtendimento(wa);
        return this.saveMessage(wm);
    }
}

