/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components;

import br.com.system.app.components.AppNavItem;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import java.util.Optional;

@JsModule(value="@vaadin-component-factory/vcf-nav")
@Tag(value="vcf-nav")
@NpmPackage(value="@vaadin-component-factory/vcf-nav", version="1.0.6")
public class AppNav
extends Component
implements HasSize,
HasStyle {
    private static final long serialVersionUID = 1L;

    public AppNav() {
    }

    public AppNav(String label) {
        this.setLabel(label);
    }

    public AppNav addItem(AppNavItem ... appNavItems) {
        for (AppNavItem appNavItem : appNavItems) {
            this.getElement().appendChild(new Element[]{appNavItem.getElement()});
        }
        return this;
    }

    public AppNav removeItem(AppNavItem appNavItem) {
        Optional parent = appNavItem.getParent();
        if (parent.isPresent() && parent.get() == this) {
            this.getElement().removeChild(new Element[]{appNavItem.getElement()});
        }
        return this;
    }

    public AppNav removeAllItems() {
        this.getElement().removeAllChildren();
        return this;
    }

    public String getLabel() {
        return this.getExistingLabelElement().map(e -> e.getText()).orElse(null);
    }

    public AppNav setLabel(String label) {
        this.getLabelElement().setText(label);
        return this;
    }

    private Optional<Element> getExistingLabelElement() {
        return this.getElement().getChildren().filter(child -> "label".equals(child.getAttribute("slot"))).findFirst();
    }

    private Element getLabelElement() {
        return this.getExistingLabelElement().orElseGet(() -> {
            Element element = new Element("span");
            element.setAttribute("slot", "label");
            this.getElement().appendChild(new Element[]{element});
            return element;
        });
    }

    public boolean isCollapsible() {
        return this.getElement().hasAttribute("collapsible");
    }

    public AppNav setCollapsible(boolean collapsible) {
        this.getElement().setAttribute("collapsible", "");
        return this;
    }
}

