/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.features.layout.UIUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;

public class ConfirmationDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private Button confirm;
    private Button cancel;
    private String mensagem;
    private final String titulo;
    private final VaadinIcon iconConfirm;
    private final VaadinIcon iconCancel;

    public ConfirmationDialog(String titulo, String mensagem) {
        this.titulo = titulo;
        this.mensagem = mensagem;
        this.iconCancel = VaadinIcon.CLOSE_CIRCLE;
        this.iconConfirm = VaadinIcon.CHECK_CIRCLE;
        this.create();
    }

    public ConfirmationDialog(String titulo, String mensagem, VaadinIcon iconConfirm, VaadinIcon iconCancel) {
        this.titulo = titulo;
        this.mensagem = mensagem;
        this.iconCancel = iconCancel;
        this.iconConfirm = iconConfirm;
        this.create();
    }

    private void create() {
        this.setCloseOnEsc(false);
        this.setCloseOnOutsideClick(false);
        this.confirm = UIUtils.createSuccessButton((String)"Confirmar", (VaadinIcon)this.iconConfirm, (String)"");
        this.confirm.setDisableOnClick(true);
        this.cancel = UIUtils.createErrorButton((String)"Cancelar", (VaadinIcon)this.iconCancel, (String)"");
        VerticalLayout card = new VerticalLayout();
        card.setHeightFull();
        card.add(new Component[]{UIUtils.createHeader((String)this.titulo)});
        this.mensagem = this.mensagem.replaceAll("(\r\n|\n)", "<br />") + "<br/>";
        Div div = new Div();
        div.getElement().setProperty("innerHTML", "<span>" + this.mensagem + "</span>");
        card.add(new Component[]{div});
        card.add(new Component[]{new FooterContainer(new Component[]{this.cancel, this.confirm})});
        this.add(new Component[]{card});
        this.open();
    }

    public VaadinIcon getIconConfirm() {
        return this.iconConfirm;
    }

    public VaadinIcon getIconCancel() {
        return this.iconCancel;
    }

    public Button getConfirm() {
        return this.confirm;
    }

    public Button getCancel() {
        return this.cancel;
    }
}

