/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components;

import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.StringUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResource;
import java.io.Serializable;

public class DownloadDialog
extends Dialog
implements Serializable {
    private static final long serialVersionUID = 1L;

    public void open(String hash, String nomeArquivo) {
        this.open(hash, nomeArquivo, false);
    }

    public void open(String hash, String nomeArquivo, boolean delete) {
        this.removeAll();
        nomeArquivo = nomeArquivo.replace("%", " por cento");
        nomeArquivo = StringUtil.removeBars((String)nomeArquivo);
        Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnClose.addClickListener((ComponentEventListener & Serializable)close -> this.close());
        StreamResource resource = StorageUtil.getStreamResource((String)hash, (String)nomeArquivo);
        if (resource == null) {
            UIUtils.showNotification((String)"Erro ao baixar arquivo, tente novamente");
            return;
        }
        resource.setContentType("application/octet-stream");
        resource.setHeader("Content-Disposition", "attachment; filename=\"" + nomeArquivo + "\"");
        Anchor anchor = new Anchor((AbstractStreamResource)resource, nomeArquivo);
        anchor.setTarget("_blank");
        anchor.setText(nomeArquivo);
        anchor.setTitle("Baixar arquivo processado");
        anchor.setVisible(!hash.isEmpty());
        anchor.getElement().setAttribute("download", true);
        VerticalContainer v = new VerticalContainer(new Component[0]).setSpacingOn();
        v.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        v.add(new Component[]{UIUtils.createHeader((String)"Arquivo dispon\u00edvel")});
        v.add(new Component[]{anchor, btnClose});
        this.add(new Component[]{v});
        this.open();
        if (delete) {
            try {
                StorageUtil.deleteObject((String)hash);
            }
            catch (Exception e) {
                UIUtils.showError((String)"Erro ao excluir anexo");
            }
        }
    }
}

