/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.config;

import br.com.system.app.config.HealthCheck;
import br.com.system.app.features.cliente.service.ClienteIntegration;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.datastone.service.DataStoneWebhook;
import br.com.system.app.features.discadora.service.DiscadoraIntegration;
import br.com.system.app.features.googlecron.CronResource;
import br.com.system.app.features.marketing.service.MarketingWebhook;
import br.com.system.app.features.pedido.service.AtividadeIntegration;
import br.com.system.app.features.pedido.service.FacebookIntegration;
import br.com.system.app.features.pedido.service.PedidoEtapaIntegration;
import br.com.system.app.features.pedido.service.PedidoStatusIntegration;
import br.com.system.app.features.pedido.service.RdstationIntegration;
import br.com.system.app.features.pedido.view.AtividadePropostaView;
import br.com.system.app.features.producaopainel.service.ProducaoPainelIntegration;
import br.com.system.app.features.producaopainel.service.ProducaoPainelIntegrationV2;
import br.com.system.app.features.sessions.model.Sessions;
import br.com.system.app.features.sessions.service.SessionsService;
import br.com.system.app.features.starkbank.StarkBankWebhookService;
import br.com.system.app.features.trescx.service.TrescxIntegration;
import br.com.system.app.features.usuario.service.UsuarioIntegration;
import br.com.system.app.features.waha.service.WahaWebhook;
import br.com.system.app.features.whatsapp.service.WhatsAppWebhookMoorse;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=-2147483547)
public class FilterMain
extends OncePerRequestFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private FacebookIntegration facebookIntegration;
    @Autowired
    private RdstationIntegration rdstationIntegration;
    @Autowired
    private AtividadeIntegration atividadeIntegration;
    @Autowired
    private DiscadoraIntegration discadoraIntegration;
    @Autowired
    private AtividadePropostaView atividadePropostaView;
    @Autowired
    private ClienteIntegration clienteIntegration;
    @Autowired
    private CronResource cronResource;
    @Autowired
    private SessionsService sessionsService;
    @Autowired
    private StarkBankWebhookService starkBankWebhookService;
    @Autowired
    private WhatsAppWebhookMoorse whatsAppWebhook;
    @Autowired
    private MarketingWebhook marketingWebhook;
    @Autowired
    private ProducaoPainelIntegration producaoPainelIntegration;
    @Autowired
    private TrescxIntegration tresCxIntegration;
    @Autowired
    private UsuarioIntegration usuarioIntegration;
    @Autowired
    private ProducaoPainelIntegrationV2 producaoPainelBIIntegrationV2;
    @Autowired
    private PedidoEtapaIntegration pedidoEtapaIntegration;
    @Autowired
    private PedidoStatusIntegration pedidoStatusIntegration;
    @Autowired
    private HealthCheck healthCheck;
    @Autowired
    private DataStoneWebhook dataStoneWebhook;
    @Autowired
    private WahaWebhook wahaWebhook;
    @Autowired
    private ConfigurationsService configurationsService;

    public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String scheme = request.getScheme();
        String host = request.getHeader("Host");
        if ("http".equalsIgnoreCase(scheme) && host != null && !host.equalsIgnoreCase("localhost:8080") && !host.contains("ngrok-free.app")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.isIpAddress(host) || "app.neosales.com.br".equalsIgnoreCase(host) || "sistema.neosales.com.br".equalsIgnoreCase(host) || "system.neosales.com.br".equalsIgnoreCase(host) || "seu-dominio.neosales.com.br".equalsIgnoreCase(host) || host.toLowerCase().endsWith(".neocrm.com.br")) {
            response.setContentType("text/html;charset=UTF-8");
            response.setStatus(200);
            response.getWriter().write(this.configurationsService.get(ConfigurationEnum.MENSAGEM_DOMINIO_INVALIDO).getValor());
            return;
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            try {
                Sessions s = this.sessionsService.getBySessionId(session.getId());
                if (s != null && !s.isAtiva()) {
                    session.invalidate();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (request.getRequestURI().contains("health")) {
            this.healthCheck.response((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("webhook-datastone")) {
            this.dataStoneWebhook.webhook((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("webhook-waha")) {
            this.wahaWebhook.webhook((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("webhook-whatsapp")) {
            this.whatsAppWebhook.webhook((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("webhook-marketing")) {
            this.marketingWebhook.webhook((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("webhook-3cx")) {
            this.tresCxIntegration.webhook((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("webhook-stark-bank")) {
            this.starkBankWebhookService.webhook((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("atividade-proposta")) {
            this.atividadePropostaView.show((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("producao-painel-integration-v2")) {
            this.producaoPainelBIIntegrationV2.doIntegration((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("producao-painel-integration")) {
            this.producaoPainelIntegration.doIntegration((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("usuario-integration")) {
            this.usuarioIntegration.doIntegration((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("pedido-etapa-integration")) {
            this.pedidoEtapaIntegration.doIntegration((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("pedido-movimentacao-integration")) {
            this.pedidoStatusIntegration.doIntegration((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("integracao-central-telefonica")) {
            this.discadoraIntegration.doIntegration((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("integracao-atividade")) {
            this.atividadeIntegration.doIntegration((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("facebook-integration")) {
            this.facebookIntegration.doIntegration((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("rdstation-integration")) {
            this.rdstationIntegration.doIntegration((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("cliente-integracao/responsaveis")) {
            this.clienteIntegration.getResponsavel((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().contains("cron-resource")) {
            this.cronResource.execute(request, response);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isIpAddress(String host) {
        String cleanHost = host.split(":")[0];
        if (cleanHost.matches("^\\d{1,3}(\\.\\d{1,3}){3}$")) {
            return true;
        }
        if (cleanHost.contains(":") && !cleanHost.matches(".*[a-zA-Z].*")) {
            return true;
        }
        return !cleanHost.matches(".*[a-zA-Z].*");
    }
}

