/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.analisefatura.service;

import br.com.system.app.features.analisefatura.model.AnaliseFatura;
import br.com.system.app.features.analisefatura.model.AnaliseFaturaDTO;
import br.com.system.app.features.analisefatura.model.AnaliseFaturaItem;
import br.com.system.app.features.analisefatura.model.AnaliseFaturaProposta;
import br.com.system.app.features.analisefatura.model.StatusAnalise;
import br.com.system.app.features.analisefatura.repository.AnaliseFaturaItemRepository;
import br.com.system.app.features.analisefatura.repository.AnaliseFaturaRepository;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pedido.dto.PedidoTipoEnum;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.model.PedidoItem;
import br.com.system.app.features.pedido.model.PedidoItemEtapa;
import br.com.system.app.features.pedido.model.PedidoItemSolicitacao;
import br.com.system.app.features.pedido.service.PedidoDeleteService;
import br.com.system.app.features.pedido.service.PedidoItemEtapaService;
import br.com.system.app.features.pedido.service.PedidoItemSolicitacaoService;
import br.com.system.app.features.pedido.service.PedidoOrigemService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.shared.model.OperadoraEnum;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import br.com.system.commons.regex.Recognizer;
import br.com.system.filereader.pdf.pdfbox.PDFReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AnaliseFaturaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private AnaliseFaturaRepository analiseFaturaRepository;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoItemEtapaService pedidoItemEtapaService;
    @Autowired
    private PedidoItemSolicitacaoService pedidoItemSolicitacaoService;
    @Autowired
    private AnaliseFaturaItemRepository analiseFaturaItemRepository;
    @Autowired
    private PedidoOrigemService pedidoOrigemService;
    @Autowired
    private PedidoDeleteService pedidoDeleteService;

    public List<AnaliseFaturaItem> getFaturaItens(AnaliseFatura af) {
        return this.analiseFaturaItemRepository.findByAnaliseFatura(af);
    }

    public AnaliseFatura reprocessar(AnaliseFatura af) {
        af.setObservacao("");
        af.setStatusAnalise(StatusAnalise.AGUARDANDO);
        return (AnaliseFatura)this.analiseFaturaRepository.save((Object)af);
    }

    public List<AnaliseFaturaDTO> getAnalises(Long faturaId, EstruturaUsuario eu, Set<String> cnpjs, boolean semAtividade, Pageable pageable) {
        Set hierarquia = this.hierarquiaService.getHierarquia(eu);
        List analises = this.analiseFaturaRepository.findAnalises(faturaId, hierarquia, cnpjs, Boolean.valueOf(semAtividade), pageable);
        return analises;
    }

    public long countAnalises(Long faturaId, EstruturaUsuario eu, Set<String> cnpjs, boolean semAtividade) {
        Set hierarquia = this.hierarquiaService.getHierarquia(eu);
        long countAnalises = this.analiseFaturaRepository.countAnalises(faturaId, hierarquia, cnpjs, Boolean.valueOf(semAtividade));
        return countAnalises;
    }

    public void delete(Long analiseFaturaId) throws Exception {
        this.delete((AnaliseFatura)this.analiseFaturaRepository.findById((Object)analiseFaturaId).get(), Boolean.valueOf(true));
    }

    public void delete(AnaliseFatura af, Boolean excluirAnexoBucket) throws Exception {
        if (excluirAnexoBucket.booleanValue()) {
            StorageUtil.deleteObject((String)af.getHashArquivoAnalisado());
            StorageUtil.deleteObject((String)af.getHashArquivoOriginal());
        }
        this.analiseFaturaRepository.delete((Object)af);
    }

    public AnaliseFatura upload(EstruturaUsuario eu, InputStream isFile, String fileName) {
        AnaliseFatura analiseFatura;
        InputStream firstClone = null;
        InputStream secondClone = null;
        ByteArrayOutputStream baosOrbit = null;
        try {
            baosOrbit = new ByteArrayOutputStream();
            isFile.transferTo(baosOrbit);
            firstClone = new ByteArrayInputStream(baosOrbit.toByteArray());
            secondClone = new ByteArrayInputStream(baosOrbit.toByteArray());
            String extensao = FileUtil.getExtension((String)fileName);
            String hash = HashUtil.getUUI();
            StorageUtil.uploadObjectInputStream((String)(hash + extensao), (InputStream)firstClone);
            AnaliseFatura af = new AnaliseFatura();
            af.setDataHoraImportacao(LocalDateTime.now());
            af.setEstruturaUsuario(eu);
            af.setHashArquivoOriginal(hash + extensao);
            af.setHashArquivoAnalisado(hash + ".xlsx");
            af.setHashArquivoAnalisadoDetalhamento(hash + "-detalhamento.XLS");
            af.setNomeArquivo(fileName);
            af.setStatusAnalise(StatusAnalise.AGUARDANDO);
            if (extensao.toLowerCase().equals(".txt")) {
                this.setDadosFaturaTxt(af, secondClone);
            } else {
                this.setDadosFaturaPdf(af, secondClone);
            }
            AnaliseFatura afExistente = this.analiseFaturaRepository.findByEstruturaUsuarioAndCpfCnpjAndCodigoContaAndDataVencimentoAndOperadora(eu, af.getCpfCnpj(), af.getCodigoConta(), af.getDataVencimento(), af.getOperadora());
            if (afExistente != null) {
                afExistente.setObservacao("Fatura j\u00e1 estava importada");
                AnaliseFatura analiseFatura2 = afExistente;
                return analiseFatura2;
            }
            analiseFatura = (AnaliseFatura)this.analiseFaturaRepository.save((Object)af);
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao importar a fatura: " + e.getMessage());
        }
        finally {
            try {
                firstClone.close();
                secondClone.close();
                baosOrbit.close();
                isFile.close();
            }
            catch (Exception exception) {}
        }
        return analiseFatura;
    }

    private void setDadosFaturaTxt(AnaliseFatura af, InputStream secondClone) {
        try {
            String[] arr = InputStreamUtil.toString((InputStream)secondClone, (Charset)Charset.forName("ISO-8859-15")).split("\n");
            if (arr.length < 11 || !arr[0].contains("-")) {
                throw new BusinessException("Erro ao processar, arquivo n\u00e3o reconhecido");
            }
            String[] arrNomeCnpj = arr[0].split("-");
            String nome = arrNomeCnpj[0].trim();
            String cpfCnpj = StringUtil.numbersOnly((String)arrNomeCnpj[arrNomeCnpj.length - 1]);
            if (!ValidationUtil.isValidCnpjAndCpf((String)cpfCnpj)) {
                throw new BusinessException("Erro ao processar, cpfCnpj " + cpfCnpj + " inv\u00e1lido");
            }
            String conta = "";
            LocalDate vencimento = null;
            BigDecimal valorTotal = null;
            String mesAno = "";
            af.setOperadora(OperadoraEnum.CLARO);
            for (String l : arr) {
                if (l.contains("Vencimento:")) {
                    vencimento = DateTimeUtil.toDate((String)Recognizer.getFirst((String)l, (String[])new String[]{"\\b((0[1-9]|[12][0-9]|3[01])[-/.]+(0[1-9]|1[012])[-/.]+([12][0-9]{3}|\\d{2}))\\b"}), (FormatDate)FormatDate.DATE_BR);
                    mesAno = vencimento.format(FormatDate.BR_MES_ANO.toDTF());
                }
                if (l.contains("Valor:")) {
                    valorTotal = Recognizer.getDecimal((String)l);
                }
                if (l.contains("d\u00e9bito autom\u00e1tico")) {
                    conta = StringUtil.numbersOnly((String)l);
                }
                if (l.contains("Identifica\u00e7\u00e3o para d\u00e9bito autom\u00e1tico") || l.contains("Origem(UF)-Destino")) break;
            }
            af.setDataVencimento(vencimento);
            af.setValorTotal(valorTotal);
            af.setMesAno(mesAno);
            af.setCodigoConta(conta);
            af.setCpfCnpj(cpfCnpj);
            af.setNomeCliente(nome);
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao processar, arquivo n\u00e3o parece valido. (TXT aceito apenas para faturas da CLARO)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDadosFaturaPdf(AnaliseFatura af, InputStream secondClone) {
        PDFReader reader = null;
        try {
            String nome = "";
            String cpfCnpj = "";
            String conta = "";
            LocalDate vencimento = null;
            BigDecimal valorTotal = null;
            Object mesAno = "";
            reader = new PDFReader(secondClone);
            String page1 = reader.readPage(1);
            if (page1.contains("www.vivo.com.br/meuvivo") || page1.contains("VEJA O USO DETALHADO DO VIVO")) {
                try {
                    String firstPart = StringUtil.removeLineBreaks((String)page1.substring(page1.indexOf("Nome do Cliente")));
                    firstPart = firstPart.substring(0, firstPart.indexOf("C\u00f3d.")).replace("C\u00f3d.", "").replace("Nome do Cliente", "");
                    String data = Recognizer.getFirst((String)firstPart, (String[])new String[]{"\\b((0[1-9]|[12][0-9]|3[01])[-/.]+(0[1-9]|1[012])[-/.]+([12][0-9]{3}|\\d{2}))\\b"}).trim();
                    String valor = Recognizer.getFirst((String)firstPart, (String[])new String[]{"([+-]?([^0]\\d+|\\d{1,3}(\\.\\d{3})*),(\\d+))"}).trim();
                    nome = firstPart.replace(data, "").replace(valor, "").trim();
                    valorTotal = Recognizer.getDecimal((String)valor);
                    vencimento = DateTimeUtil.toDate((String)data, (FormatDate)FormatDate.DATE_BR);
                    conta = StringUtil.numbersOnly((String)page1.substring(page1.indexOf("da Conta"), page1.indexOf("M\u00eas")));
                    mesAno = page1.substring(page1.indexOf("M\u00eas Refer\u00eancia ")).replace("M\u00eas Refer\u00eancia ", "").trim();
                    mesAno = StringUtil.numbersOnly((String)((String)mesAno).substring(0, 7));
                    String pageCnpj = reader.readPage(2);
                    if (!pageCnpj.contains("CPF/CNPJ")) {
                        pageCnpj = reader.readPage(1);
                        pageCnpj = !pageCnpj.contains("CPF/CNPJ") ? reader.readPage(3) : "";
                    }
                    if (!pageCnpj.isBlank()) {
                        pageCnpj = pageCnpj.substring(pageCnpj.indexOf("CPF/CNPJ"));
                        cpfCnpj = StringUtil.numbersOnly((String)Recognizer.getFirst((String)pageCnpj, (String[])new String[]{"(\\b([0-9]{2}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[\\/]?[0-9]{4}[-]?[0-9]{2})\\b)|(\\b([0-9]{3}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[-]?[0-9]{2})\\b)"}));
                    }
                }
                catch (Exception firstPart) {
                    // empty catch block
                }
                af.setOperadora(OperadoraEnum.VIVO);
            } else if (page1.contains("www.claro.com.br")) {
                try {
                    nome = page1.substring(0, page1.indexOf("\n")).trim();
                    cpfCnpj = StringUtil.numbersOnly((String)Recognizer.getFirst((String)page1.substring(page1.indexOf("CPF/CNPJ")), (String[])new String[]{"(\\b([0-9]{2}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[\\/]?[0-9]{4}[-]?[0-9]{2})\\b)|(\\b([0-9]{3}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[-]?[0-9]{2})\\b)"}));
                    conta = StringUtil.numbersOnly((String)page1.substring(page1.indexOf("N\u00ba da Conta"), page1.indexOf("CPF/CNPJ")));
                    if (page1.contains("Total do M\u00eas")) {
                        valorTotal = Recognizer.getDecimal((String)page1.substring(page1.indexOf("Total do M\u00eas")));
                    } else {
                        int iPage = 2;
                        while (valorTotal == null) {
                            try {
                                if (iPage >= reader.getPageCount()) break;
                                String pagex = reader.readPage(iPage);
                                valorTotal = Recognizer.getDecimal((String)pagex.substring(pagex.indexOf("Total do M\u00eas")));
                            }
                            catch (Exception ex) {
                                ++iPage;
                            }
                        }
                    }
                    vencimento = DateTimeUtil.toDate((String)Recognizer.getLast((String)page1.substring(page1.indexOf("Vencimento"), page1.indexOf("EEEEEEEEEEEE")), (String)"\\b((0[1-9]|[12][0-9]|3[01])[-/.]+(0[1-9]|1[012])[-/.]+([12][0-9]{3}|\\d{2}))\\b"), (FormatDate)FormatDate.DATE_BR);
                    mesAno = vencimento.getMonthValue() + "/" + vencimento.getYear();
                }
                catch (Exception iPage) {
                    // empty catch block
                }
                af.setOperadora(OperadoraEnum.CLARO);
            } else if (page1.contains("WWW.MEUTIM.COM.BR")) {
                try {
                    nome = StringUtil.removeLineBreaks((String)page1.substring(page1.indexOf("NOME DO CLIENTE"), page1.indexOf("IDENTIFICA")).replace("NOME DO CLIENTE", "")).trim();
                    cpfCnpj = StringUtil.numbersOnly((String)Recognizer.getFirst((String)page1.substring(page1.indexOf("CPF/CNPJ: ")), (String[])new String[]{"(\\b([0-9]{2}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[\\/]?[0-9]{4}[-]?[0-9]{2})\\b)|(\\b([0-9]{3}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[-]?[0-9]{2})\\b)"}));
                    vencimento = DateTimeUtil.toDate((String)Recognizer.getFirst((String)page1.substring(page1.indexOf("VENCIMENTO")), (String[])new String[]{"\\b((0[1-9]|[12][0-9]|3[01])[-/.]+(0[1-9]|1[012])[-/.]+([12][0-9]{3}|\\d{2}))\\b"}).trim(), (FormatDate)FormatDate.DATE_BR);
                    conta = page1.substring(page1.indexOf("FATURA DE PAGAMENTO:"));
                    conta = StringUtil.numbersOnly((String)conta.substring(0, conta.indexOf("\n")));
                    mesAno = page1.substring(page1.indexOf("REF:"), page1.indexOf("PER\u00cdODO")).replace("REF:", "").trim();
                    valorTotal = Recognizer.getDecimal((String)page1.substring(page1.indexOf("VALOR")));
                }
                catch (Exception iPage) {
                    // empty catch block
                }
                af.setOperadora(OperadoraEnum.TIM);
            } else if (page1.contains("WWW.OI.COM.BR")) {
                try {
                    String venc = Recognizer.getFirst((String)page1, (String[])new String[]{"\\b((0[1-9]|[12][0-9]|3[01])[-/.]+(0[1-9]|1[012])[-/.]+([12][0-9]{3}|\\d{2}))\\b"});
                    vencimento = DateTimeUtil.toDate((String)venc, (FormatDate)FormatDate.DATE_BR);
                    mesAno = page1.substring(page1.indexOf("EMPRESAS"), page1.indexOf(venc)).replace("EMPRESAS", "").trim();
                    valorTotal = Recognizer.getDecimal((String)(page1.substring(page1.indexOf("PAGAR")) + " "));
                    conta = page1.substring(page1.indexOf("N\u00daMERO DO CLIENTE"));
                    conta = StringUtil.numbersOnly((String)conta.substring(0, conta.indexOf("\n")));
                    cpfCnpj = page1.substring(page1.indexOf("CNPJ"));
                    cpfCnpj = StringUtil.numbersOnly((String)cpfCnpj.substring(0, 24));
                    nome = page1.substring(page1.indexOf("SERVI\u00c7OS UTILIZADOS"), page1.indexOf("CNPJ")).replace("SERVI\u00c7OS UTILIZADOS", "").trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                af.setOperadora(OperadoraEnum.OI);
            } else if (page1.contains("nextel")) {
                af.setOperadora(OperadoraEnum.NEXTEL);
            } else {
                af.setOperadora(OperadoraEnum.OUTRA);
            }
            af.setDataVencimento(vencimento);
            af.setValorTotal(valorTotal);
            af.setMesAno((String)mesAno);
            af.setCodigoConta(conta);
            af.setCpfCnpj(cpfCnpj);
            af.setNomeCliente(nome);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(AnaliseFaturaService.class).error(e.getMessage());
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public AnaliseFatura getById(Long id) {
        return (AnaliseFatura)this.analiseFaturaRepository.findById((Object)id).get();
    }

    public AnaliseFatura save(AnaliseFatura af) {
        return (AnaliseFatura)this.analiseFaturaRepository.save((Object)af);
    }

    public PedidoItemSolicitacao getPortado(Estrutura estrutura) {
        return this.pedidoItemSolicitacaoService.getPortado(estrutura.getEstruturaTipo());
    }

    public PedidoItemSolicitacao getNovo(Estrutura estrutura) {
        return this.pedidoItemSolicitacaoService.getNovo(estrutura.getEstruturaTipo());
    }

    public PedidoItemSolicitacao getRenovacao(Estrutura estrutura) {
        return this.pedidoItemSolicitacaoService.getRenovacao(estrutura.getEstruturaTipo());
    }

    public List<PedidoItemSolicitacao> getSolicitacao(Estrutura estrutura) {
        return this.pedidoItemSolicitacaoService.getAtivos(estrutura.getEstruturaTipo());
    }

    public Pedido createTask(EstruturaUsuario eu, AnaliseFatura af, Set<AnaliseFaturaProposta> itemsProposta) {
        String movimentacao;
        Pedido pedido = null;
        if (af.getAtividadeId() != null && af.getAtividadeId() > 0L) {
            pedido = this.pedidoService.getById(af.getAtividadeId());
        }
        if (pedido == null) {
            movimentacao = "Criando pedido a partir da fatura #" + af.getId();
            pedido = new Pedido();
            pedido.setCliente(this.clienteService.getAndCreateCliente(eu, af.getCpfCnpj(), af.getNomeCliente(), new ClienteContato[0]));
            pedido.setEstruturaUsuario(eu);
            pedido.setPedidoTipo(PedidoTipoEnum.COMERCIAL);
        } else {
            this.pedidoDeleteService.deleteItens(pedido);
            movimentacao = "Atualizando pedido a partir da fatura #" + af.getId();
        }
        pedido.setPedidoOrigem(this.pedidoOrigemService.getOrigemAtividade(eu.getEstrutura()));
        pedido.setComplementos(this.getComplemento(af, pedido));
        pedido.setValorFaturaOrigem(af.getValorTotal());
        pedido.setItens(this.getTaskItens(pedido, itemsProposta));
        return this.pedidoService.salvar(pedido, movimentacao, eu, true);
    }

    private Set<PedidoItem> getTaskItens(Pedido pedido, Set<AnaliseFaturaProposta> itemsProposta) {
        PedidoItemEtapa etapa = this.pedidoItemEtapaService.getEtapaInicial(pedido.getEstruturaUsuario().getEstrutura(), pedido.getPedidoOrigem());
        HashSet<PedidoItem> pedidoItem = new HashSet<PedidoItem>();
        for (AnaliseFaturaProposta i : itemsProposta) {
            if (i.getExcluido().booleanValue()) continue;
            PedidoItem p = new PedidoItem();
            p.setPedido(pedido);
            p.setDescontoPorItem(BigDecimal.ZERO);
            p.setConsiderarProducao(Boolean.TRUE);
            p.setDataReferencia(LocalDate.now());
            p.setNumero(i.getNumero());
            p.setPedidoItemEtapa(etapa);
            p.setPedidoItemSolicitacao(i.getPedidoItemSolicitacao());
            p.setProduto(i.getProduto());
            p.setQuantidade(i.getQuantidade());
            p.setValorUnitario(i.getValor());
            pedidoItem.add(p);
            p = null;
        }
        etapa = null;
        return pedidoItem;
    }

    private String getComplemento(AnaliseFatura af, Pedido pedido) {
        if (pedido.getComplementos() != null && pedido.getComplementos().contains("CODIGO: #") && pedido.getComplementos().contains("VIA FATURA")) {
            return pedido.getComplementos();
        }
        StringBuilder dadosFatura = new StringBuilder();
        if (pedido.getComplementos() != null) {
            dadosFatura.append(pedido.getComplementos()).append("\n");
        }
        if (pedido.getId() == null) {
            dadosFatura.append("ATIVIDADE GERADA VIA FATURA\n");
        } else {
            dadosFatura.append("ATIVIDADE ATUALIZADA VIA FATURA\n");
        }
        dadosFatura.append("CODIGO: #").append(af.getId()).append("\n");
        dadosFatura.append("OPERADORA: ").append(af.getOperadora().name()).append("\n");
        dadosFatura.append("CPF-CNPJ: ").append(af.getCpfCnpj()).append("\n");
        dadosFatura.append("CLIENTE: ").append(af.getNomeCliente()).append("\n");
        dadosFatura.append("CONTA: ").append(af.getCodigoConta()).append("\n");
        dadosFatura.append("MES-ANO: ").append(af.getMesAno()).append("\n");
        dadosFatura.append("VENCIMENTO: ").append(af.getDataVencimento()).append("\n");
        dadosFatura.append("VALOR: R$ ").append(af.getValorTotal()).append("\n");
        return dadosFatura.toString();
    }

    public List<AnaliseFatura> getByEstrutura(Estrutura estrutura) {
        return this.analiseFaturaRepository.findByEstruturaUsuarioEstrutura(estrutura);
    }

    public List<AnaliseFatura> getByHashArquivoOriginal(String hashArquivoOriginal) {
        return this.analiseFaturaRepository.findByhashArquivoOriginal(hashArquivoOriginal);
    }
}

