/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.analisefatura.service.oribt;

import br.com.system.app.features.analisefatura.model.AnaliseFatura;
import br.com.system.app.features.analisefatura.model.AnaliseFaturaItem;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.XLSUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class OrbitToSystem
implements Serializable {
    private static final long serialVersionUID = 1L;

    public void convert(AnaliseFatura af, InputStream isOrbit, HashMap<String, String> planos, Workbook appXls) {
        XSSFWorkbook orbitXls = null;
        try {
            orbitXls = new XSSFWorkbook(isOrbit);
            Sheet abaOrbit = orbitXls.getSheet("Diagn\u00f3stico de Contrata\u00e7\u00f5es");
            Sheet abaSystemConsolidado = appXls.getSheet("Consolidado");
            HashSet<AnaliseFaturaItem> itens = new HashSet<AnaliseFaturaItem>();
            int indRow = 2;
            for (int i = 7; i <= abaOrbit.getLastRowNum(); ++i) {
                Row row = abaOrbit.getRow(i);
                if (XLSUtil.getString((Row)row, (Integer)0).isBlank()) continue;
                AnaliseFaturaItem item = this.getItem(row, planos);
                item.setAnaliseFatura(af);
                this.setRow(abaSystemConsolidado, indRow, item);
                itens.add(item);
                ++indRow;
                row = null;
                item = null;
            }
            af.setItens(itens);
            abaOrbit = null;
            abaSystemConsolidado = null;
            itens = null;
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao converter fatura: " + e.getMessage());
        }
        finally {
            try {
                orbitXls.close();
                orbitXls = null;
            }
            catch (Exception exception) {}
        }
    }

    public void setDetalhamento(InputStream isOrbit, Workbook appXls) throws Exception {
        String csv = InputStreamUtil.toString((InputStream)isOrbit, (Charset)Charset.forName("iso-8859-1"));
        Sheet abaSystem = appXls.getSheet("Detalhamento Completo");
        int linhaSystem = 1;
        String[] arr = csv.split("\n");
        for (int i = 1; i < arr.length; ++i) {
            try {
                String[] colunas = arr[i].split(";");
                if (colunas.length < 20) break;
                Row systemRow = abaSystem.createRow(linhaSystem);
                systemRow.createCell(0).setCellValue(colunas[0].replace("\"", ""));
                systemRow.createCell(1).setCellValue(colunas[3].replace("\"", ""));
                systemRow.createCell(2).setCellValue(colunas[4].replace("\"", ""));
                systemRow.createCell(3).setCellValue(colunas[5].replace("\"", ""));
                systemRow.createCell(4).setCellValue(colunas[6].replace("\"", ""));
                systemRow.createCell(5).setCellValue(colunas[7].replace("\"", ""));
                systemRow.createCell(6).setCellValue(colunas[10].replace("\"", ""));
                systemRow.createCell(7).setCellValue(colunas[11].replace("\"", ""));
                systemRow.createCell(8).setCellValue(colunas[15].replace("\"", ""));
                systemRow.createCell(9).setCellValue(colunas[16].replace("\"", ""));
                systemRow.createCell(10).setCellValue(colunas[17].replace("\"", ""));
                systemRow.createCell(11).setCellValue(colunas[18].replace("\"", ""));
                systemRow.createCell(12).setCellValue(colunas[19].replace("\"", ""));
                systemRow.createCell(13).setCellValue(colunas[20].replace("\"", ""));
                ++linhaSystem;
                systemRow = null;
                colunas = null;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        arr = null;
        csv = null;
        abaSystem = null;
    }

    private void setRow(Sheet aba, int row, AnaliseFaturaItem item) {
        Row rowSystem = aba.createRow(row);
        rowSystem.createCell(0).setCellValue(item.getNumero());
        rowSystem.createCell(1).setCellValue(item.isTemConsumo() ? "SIM" : "N\u00c3O");
        rowSystem.createCell(2).setCellValue(item.getPlanoNome());
        rowSystem.createCell(3).setCellValue(item.getPlanoValor().doubleValue());
        rowSystem.createCell(4).setCellValue(item.getValorDesconto().doubleValue());
        rowSystem.createCell(5).setCellValue(item.getAparelhoNome());
        rowSystem.createCell(6).setCellValue(item.getAparelhoValor().doubleValue());
        rowSystem.createCell(7).setCellValue(item.getDadosLocal().doubleValue());
        rowSystem.createCell(8).setCellValue(item.getDadosInter().doubleValue());
        rowSystem.createCell(9).setCellValue(item.getVozLocal().doubleValue());
        rowSystem.createCell(10).setCellValue(item.getVozLd().doubleValue());
        rowSystem.createCell(11).setCellValue(item.getVozInter().doubleValue());
        rowSystem.createCell(12).setCellValue(item.getOutrosValor().doubleValue());
        rowSystem.createCell(13).setCellValue(item.getValorTotal().doubleValue());
    }

    private AnaliseFaturaItem getItem(Row row, HashMap<String, String> planos) {
        AnaliseFaturaItem item = new AnaliseFaturaItem();
        item.setNumero(XLSUtil.getString((Row)row, (Integer)0));
        item.setAparelhoNome(XLSUtil.getString((Row)row, (Integer)7).replace("--", ""));
        item.setAparelhoValor(XLSUtil.getDecimal((Row)row, (Integer)8));
        item.setDadosInter(XLSUtil.getDecimal((Row)row, (Integer)37));
        item.setDadosLocal(XLSUtil.getDecimal((Row)row, (Integer)29));
        item.setOutrosValor(XLSUtil.getDecimal((Row)row, (Integer)10).add(XLSUtil.getDecimal((Row)row, (Integer)12)));
        String p = XLSUtil.getString((Row)row, (Integer)3);
        if (p.length() < 10) {
            p = planos.get(StringUtil.numbersOnly((String)item.getNumero()));
        }
        item.setPlanoNome(p);
        item.setPlanoValor(XLSUtil.getDecimal((Row)row, (Integer)4));
        item.setValorTotal(XLSUtil.getDecimal((Row)row, (Integer)39));
        item.setValorDesconto(XLSUtil.getDecimal((Row)row, (Integer)6));
        item.setVozInter(XLSUtil.getDecimal((Row)row, (Integer)35).add(XLSUtil.getDecimal((Row)row, (Integer)36)));
        item.setVozLd(XLSUtil.getDecimal((Row)row, (Integer)23));
        item.setVozLocal(XLSUtil.getDecimal((Row)row, (Integer)19));
        item.setTemConsumo(item.getDadosInter().intValue() > 0 || item.getDadosLocal().intValue() > 0 || item.getVozInter().intValue() > 0 || item.getVozLd().intValue() > 0 || item.getVozLocal().intValue() > 0);
        return item;
    }
}

