/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.model;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.shared.model.IEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@DynamicUpdate
@Table(name="cliente_contato")
public class ClienteContato
implements IEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToOne
    @JsonIgnore
    private Cliente cliente;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TipoContatoEnum tipo;
    @NotNull
    private String valor;
    @Enumerated(value=EnumType.STRING)
    private ClienteContatoVerficadoEnum verificado;
    private Integer nivelRelevancia;
    private Boolean temWhats;
    private LocalDate dataWhats;

    public ClienteContato() {
    }

    public ClienteContato(Cliente cliente, TipoContatoEnum tipo, String valor) {
        this.cliente = cliente;
        this.tipo = tipo;
        this.valor = valor;
        this.nivelRelevancia = 0;
    }

    public ClienteContato(TipoContatoEnum tipo, String valor) {
        this.tipo = tipo;
        this.valor = valor;
        this.nivelRelevancia = 0;
    }

    public ClienteContato(TipoContatoEnum tipo, String valor, ClienteContatoVerficadoEnum verificado) {
        this.tipo = tipo;
        this.verificado = verificado;
        this.valor = valor;
        this.nivelRelevancia = 0;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public TipoContatoEnum getTipo() {
        return this.tipo;
    }

    public void setTipo(TipoContatoEnum tipo) {
        this.tipo = tipo;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public ClienteContatoVerficadoEnum getVerificado() {
        return this.verificado;
    }

    public void setVerificado(ClienteContatoVerficadoEnum verificado) {
        this.verificado = verificado;
    }

    public Integer getNivelRelevancia() {
        return this.nivelRelevancia;
    }

    public void setNivelRelevancia(Integer nivelRelevancia) {
        this.nivelRelevancia = nivelRelevancia;
    }

    public Boolean getTemWhats() {
        return this.temWhats;
    }

    public void setTemWhats(Boolean temWhats) {
        this.temWhats = temWhats;
    }

    public LocalDate getDataWhats() {
        return this.dataWhats;
    }

    public void setDataWhats(LocalDate dataWhats) {
        this.dataWhats = dataWhats;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.tipo);
        hash = 89 * hash + Objects.hashCode(this.valor);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClienteContato other = (ClienteContato)obj;
        if (!Objects.equals(this.valor, other.valor)) {
            return false;
        }
        return this.tipo == other.tipo;
    }
}

