/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.repository;

import br.com.system.app.features.cep.model.CepLocalidade;
import br.com.system.app.features.cliente.model.ClienteDTO;
import br.com.system.app.features.cliente.model.ClienteFilter;
import br.com.system.app.features.cliente.model.ClienteFornecedor;
import br.com.system.app.features.cliente.model.ClienteLastOrderDTO;
import br.com.system.app.features.cliente.model.ClienteResponsavelDTO;
import br.com.system.app.features.cliente.model.ClienteTag;
import br.com.system.app.features.cliente.model.ClienteTagsActionEnum;
import br.com.system.app.features.cliente.model.ClienteTrigger;
import br.com.system.app.features.cliente.repository.ClienteRepositoryQuery;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.pedido.dto.TagOptionEnum;
import br.com.system.app.features.pessoa.model.PessoaDTO;
import br.com.system.app.features.usuario.model.UsuarioPerfilEnum;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.commons.StringUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class ClienteRepositoryImpl
implements ClienteRepositoryQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private UsuarioHierarquiaService hierarquiaService;

    @Transactional(readOnly=true)
    public Set<ClienteDTO> filterCliente(ClienteFilter filter, EstruturaUsuario eu, Pageable pageable) {
        Query query = this.getQuery(filter, eu, pageable, false);
        HashSet<ClienteDTO> retorno = new HashSet<ClienteDTO>();
        for (Object item : query.getResultList()) {
            retorno.add((ClienteDTO)item);
        }
        return retorno;
    }

    @Transactional(readOnly=true)
    public long countCliente(ClienteFilter filter, EstruturaUsuario eu) {
        Query query = this.getQuery(filter, eu, null, true);
        try {
            return StringUtil.toLong((String)query.getSingleResult().toString());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ClienteRepositoryImpl.class).error(e.getMessage());
            return 0L;
        }
    }

    public Query getQuery(ClienteFilter filter, EstruturaUsuario eu, Pageable pageable, boolean count) {
        boolean onlyMe = true;
        if (eu.getUsuario().getPerfil().equals((Object)UsuarioPerfilEnum.PROPRIETARIO)) {
            onlyMe = false;
        } else if (eu.haveRole("CLIENTE_CARTEIRA_VER_TUDO")) {
            onlyMe = false;
        } else if (!eu.haveRole("CLIENTE_CARTEIRA_APENAS_ENCARTEIRADO") && !filter.getDocsFilters().isEmpty()) {
            onlyMe = false;
        }
        StringBuilder sql = new StringBuilder();
        if (count) {
            sql.append(" select count(*) total");
        } else {
            sql.append("select c.id,c.cpf_cnpj,c.nome,c.tags,c.bairro,c.cidade,c.estado ,c.cep,c.logradouro,c.numero,c.complemento");
        }
        sql.append(" FROM cliente c,estrutura e ");
        if (filter.getDdds() != null && !filter.getDdds().isEmpty()) {
            sql.append(",ddd");
        }
        boolean needWhere = true;
        if (onlyMe) {
            needWhere = false;
            sql.append(" ,(select * from cliente_responsavel where estrutura_usuario_id in :hierarquia group by cliente_id) cr");
            sql.append(" WHERE c.id=cr.cliente_id");
            sql.append(" AND cr.estrutura_usuario_id in :hierarquia ");
        } else if (!filter.getResponsaveis().isEmpty()) {
            needWhere = false;
            sql.append(" ,(select * from cliente_responsavel where estrutura_usuario_id in :hierarquia group by cliente_id) cr");
            sql.append(" WHERE c.id=cr.cliente_id");
            sql.append(" AND cr.estrutura_usuario_id in :hierarquia ");
        } else if (filter.getEquipes() != null && !filter.getEquipes().isEmpty()) {
            needWhere = false;
            sql.append(" ,(select cliente_responsavel.* from cliente_responsavel,estrutura_usuario");
            sql.append(" where cliente_responsavel.estrutura_usuario_id=estrutura_usuario.id");
            sql.append(" AND estrutura_usuario.equipe_id in :equipe group by cliente_id) cr");
            sql.append(" WHERE c.id=cr.cliente_id");
            sql.append(" AND cr.estrutura_usuario_id in :hierarquia ");
        }
        if (needWhere) {
            sql.append(" WHERE c.estrutura_id=e.id");
        } else {
            sql.append(" AND c.estrutura_id=e.id");
        }
        if (filter.getDdds() != null && !filter.getDdds().isEmpty()) {
            sql.append(" AND c.estado=ddd.estado and c.cidade=ddd.cidade and ddd.ddd in :ddd");
        }
        sql.append(" AND e.id=:estruturaId");
        if (!filter.getTemWhats().equals("Ignorar")) {
            if (filter.getTemWhats().equals("Com cadastro")) {
                sql.append(" and c.cadastro_whatsapp =1");
            } else {
                sql.append(" and c.cadastro_whatsapp is null");
            }
        }
        if (!filter.getDocsFilters().isEmpty()) {
            sql.append(" AND c.cpf_cnpj IN :cnpjs");
        } else {
            if (filter.getEstado() != null && !filter.getEstado().isEmpty()) {
                sql.append(" AND c.estado=:estado");
            }
            if (!filter.getNome().isBlank()) {
                sql.append(" AND c.nome like :nome");
            }
            if (!filter.getBairroFilters().isEmpty()) {
                sql.append(" AND c.bairro in :bairros");
            }
            if (!filter.getCepFilters().isEmpty()) {
                sql.append(" AND c.cep in :ceps");
            }
            if (filter.getTags() != null && !filter.getTags().isEmpty()) {
                sql.append(" AND (");
                int ind = 0;
                for (ClienteTag pt : filter.getTags()) {
                    if (filter.getTagOptionEnum() != null && filter.getTagOptionEnum().equals((Object)TagOptionEnum.NAO)) {
                        sql.append(" not ");
                    }
                    sql.append("find_in_set('").append(pt.getTag()).append("',c.tags)");
                    if (ind < filter.getTags().size() - 1) {
                        if (filter.getTagOptionEnum() != null && (filter.getTagOptionEnum().equals((Object)TagOptionEnum.OU) || filter.getTagOptionEnum().equals((Object)TagOptionEnum.NAO))) {
                            sql.append(" or ");
                        } else if (filter.getTagOptionEnum() != null && filter.getTagOptionEnum().equals((Object)TagOptionEnum.E)) {
                            sql.append(" and ");
                        }
                    }
                    ++ind;
                }
                sql.append(")");
            }
            if (!filter.getCidadeFilters().isEmpty()) {
                sql.append(" AND c.cidade in :cidade");
            }
            if (filter.getFornecedor() != null && !filter.getFornecedor().isEmpty() || filter.getProdutos() != null && !filter.getProdutos().isEmpty() || filter.getQtdInicial() != null && filter.getQtdInicial() > 0 || filter.getQtdFinal() != null && filter.getQtdFinal() > 0 || filter.getValorInicial() != null && filter.getValorInicial().compareTo(BigDecimal.ZERO) > 0 || filter.getValorFinal() != null && filter.getValorFinal().compareTo(BigDecimal.ZERO) > 0 || filter.getAtivacaoInicial() != null || filter.getAtivacaoFinal() != null || filter.getFidelidadeInicial() != null || filter.getFidelidadeFinal() != null) {
                sql.append(" and c.id in (select cliente_produto.cliente_id from cliente_produto,cliente");
                sql.append(" where cliente_produto.cliente_id=cliente.id");
                sql.append(" and cliente.estrutura_id=:estruturaId");
                if (filter.getFornecedor() != null && !filter.getFornecedor().isEmpty()) {
                    sql.append(" and cliente_produto.cliente_fornecedor_id in :fornecedores");
                }
                if (!filter.getProdutos().isEmpty()) {
                    sql.append(" and cliente_produto.cliente_produto_cadastro_id in :produtos");
                }
                if (filter.getQtdInicial() != null && filter.getQtdInicial() > 0) {
                    sql.append(" and cliente_produto.quantidade>=:qtdeInicial");
                }
                if (filter.getQtdFinal() != null && filter.getQtdFinal() > 0) {
                    sql.append(" and cliente_produto.quantidade<=:qtdeFinal");
                }
                if (filter.getValorInicial() != null && filter.getValorInicial().compareTo(BigDecimal.ZERO) > 0) {
                    sql.append(" and cliente_produto.valor >=:valorInicial");
                }
                if (filter.getValorFinal() != null && filter.getValorFinal().compareTo(BigDecimal.ZERO) > 0) {
                    sql.append(" and cliente_produto.valor <=:valorFinal");
                }
                if (filter.getAtivacaoInicial() != null) {
                    sql.append(" and cliente_produto.data_ativacao >=:ativacaoInicial");
                }
                if (filter.getAtivacaoFinal() != null) {
                    sql.append(" and cliente_produto.data_ativacao<=:ativacaoFinal");
                }
                if (filter.getFidelidadeInicial() != null) {
                    sql.append(" and cliente_produto.data_fidelidade >=:fidelidadeInicial");
                }
                if (filter.getFidelidadeFinal() != null) {
                    sql.append(" and cliente_produto.data_fidelidade<=:fidelidadeFinal");
                }
                sql.append(" group by cliente_produto.cliente_id )");
            }
            if (filter.getClassificacao() != null && !filter.getClassificacao().isEmpty()) {
                sql.append(" and c.cliente_classificacao_id in :classificacaoId");
            }
            if (filter.getTempoMedioInicio() != null && filter.getTempoMedioInicio() > 0) {
                sql.append(" and c.tempo_medio >=:tempoMedioInicial");
            }
            if (filter.getTempoMedioFinal() != null && filter.getTempoMedioFinal() > 0) {
                sql.append(" and c.tempo_medio <=:tempoMedioFinal");
            }
        }
        if (pageable != null) {
            sql.append(" limit :limit offset :offset");
        }
        Query query = !count ? this.manager.createNativeQuery(sql.toString(), ClienteDTO.class) : this.manager.createNativeQuery(sql.toString());
        query.setParameter("estruturaId", (Object)eu.getEstrutura().getId());
        if (!filter.getResponsaveis().isEmpty()) {
            query.setParameter("hierarquia", (Object)this.getResp(filter.getResponsaveis()));
        } else if (onlyMe) {
            query.setParameter("hierarquia", (Object)this.hierarquiaService.getHierarquia(eu));
        } else if (filter.getEquipes() != null && !filter.getEquipes().isEmpty()) {
            query.setParameter("hierarquia", (Object)this.hierarquiaService.getHierarquia(eu));
            query.setParameter("equipe", (Object)this.getEquipe(filter.getEquipes()));
        }
        if (!filter.getDocsFilters().isEmpty()) {
            query.setParameter("cnpjs", (Object)filter.getDocsFilters());
        } else {
            if (filter.getDdds() != null && !filter.getDdds().isEmpty()) {
                query.setParameter("ddd", (Object)filter.getDdds());
            }
            if (filter.getEstado() != null && !filter.getEstado().isEmpty()) {
                query.setParameter("estado", (Object)filter.getEstado());
            }
            if (!filter.getNome().isBlank()) {
                query.setParameter("nome", (Object)(filter.getNome() + "%"));
            }
            if (!filter.getBairroFilters().isEmpty()) {
                query.setParameter("bairros", (Object)filter.getBairroFilters());
            }
            if (!filter.getCepFilters().isEmpty()) {
                query.setParameter("ceps", (Object)filter.getCepFilters());
            }
            if (!filter.getCidadeFilters().isEmpty()) {
                query.setParameter("cidade", (Object)this.getCity(filter.getCidadeFilters()));
            }
            if (filter.getFornecedor() != null && !filter.getFornecedor().isEmpty()) {
                ArrayList<Long> fornecedores = new ArrayList<Long>();
                for (ClienteFornecedor cf : filter.getFornecedor()) {
                    fornecedores.add(cf.getId());
                }
                query.setParameter("fornecedores", fornecedores);
            }
            if (filter.getProdutos() != null && !filter.getProdutos().isEmpty()) {
                ArrayList<Long> produtos = new ArrayList<Long>();
                for (ClienteFornecedor cf : filter.getProdutos()) {
                    produtos.add(cf.getId());
                }
                query.setParameter("produtos", produtos);
            }
            if (filter.getQtdInicial() != null && filter.getQtdInicial() > 0) {
                query.setParameter("qtdeInicial", (Object)filter.getQtdInicial());
            }
            if (filter.getQtdFinal() != null && filter.getQtdFinal() > 0) {
                query.setParameter("qtdeFinal", (Object)filter.getQtdFinal());
            }
            if (filter.getValorInicial() != null && filter.getValorInicial().compareTo(BigDecimal.ZERO) > 0) {
                query.setParameter("valorInicial", (Object)filter.getValorInicial());
            }
            if (filter.getValorFinal() != null && filter.getValorFinal().compareTo(BigDecimal.ZERO) > 0) {
                query.setParameter("valorFinal", (Object)filter.getValorFinal());
            }
            if (filter.getAtivacaoInicial() != null) {
                query.setParameter("ativacaoInicial", (Object)filter.getAtivacaoInicial());
            }
            if (filter.getAtivacaoFinal() != null) {
                query.setParameter("ativacaoFinal", (Object)filter.getAtivacaoFinal());
            }
            if (filter.getFidelidadeInicial() != null) {
                query.setParameter("fidelidadeInicial", (Object)filter.getFidelidadeInicial());
            }
            if (filter.getFidelidadeFinal() != null) {
                query.setParameter("fidelidadeFinal", (Object)filter.getFidelidadeFinal());
            }
            if (filter.getClassificacao() != null && !filter.getClassificacao().isEmpty()) {
                ArrayList<Long> classificacoes = new ArrayList<Long>();
                for (ClienteFornecedor cf : filter.getClassificacao()) {
                    classificacoes.add(cf.getId());
                }
                query.setParameter("classificacaoId", classificacoes);
            }
            if (filter.getTempoMedioInicio() != null && filter.getTempoMedioInicio() > 0) {
                query.setParameter("tempoMedioInicial", (Object)filter.getTempoMedioInicio());
            }
            if (filter.getTempoMedioFinal() != null && filter.getTempoMedioFinal() > 0) {
                query.setParameter("tempoMedioFinal", (Object)filter.getTempoMedioFinal());
            }
        }
        if (!count && pageable != null) {
            query.setParameter("limit", (Object)pageable.getPageSize());
            query.setParameter("offset", (Object)pageable.getOffset());
        }
        return query;
    }

    @Transactional(readOnly=true)
    public List<ClienteLastOrderDTO> getByTriggers(Estrutura estrutura, ClienteTrigger trigger) {
        String[] arrTags = trigger.getTagsCliente().split(",");
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT cliente.id,cliente.tags");
        sql.append(" FROM cliente");
        sql.append(" WHERE estrutura_id=:estruturaId");
        if (arrTags != null && arrTags.length > 0) {
            sql.append(" AND (");
            for (int i = 0; i < arrTags.length; ++i) {
                sql.append("find_in_set('").append(arrTags[i]).append("',cliente.tags)");
                if (i >= arrTags.length - 1) continue;
                sql.append(" and ");
            }
            sql.append(")");
        }
        Query query = this.manager.createNativeQuery(sql.toString(), ClienteLastOrderDTO.class);
        query.setParameter("estruturaId", (Object)trigger.getEstruturaUsuario().getEstrutura().getId());
        return query.getResultList();
    }

    private Set<String> getCity(Set<CepLocalidade> lcl) {
        HashSet<String> lista = new HashSet<String>();
        for (CepLocalidade cl : lcl) {
            lista.add(cl.getNome());
        }
        return lista;
    }

    private Set<Long> getEquipe(Set<Equipe> el) {
        HashSet<Long> lista = new HashSet<Long>();
        for (Equipe e : el) {
            lista.add(e.getId());
        }
        return lista;
    }

    private Set<Long> getResp(Set<HierarquiaDTO> lh) {
        HashSet<Long> lista = new HashSet<Long>();
        for (HierarquiaDTO h : lh) {
            lista.add(h.getEstruturaUsuarioId());
        }
        return lista;
    }

    @Transactional
    public void updateListaClienteTags(Estrutura estrutura, ClienteTagsActionEnum action, String tags, Set<Long> ids) {
        StringBuilder sql = new StringBuilder();
        sql.append("update cliente,estrutura set ");
        if (action.equals((Object)ClienteTagsActionEnum.INSERIR)) {
            sql.append("cliente.tags=TAG_CHANGE(tags,'").append(tags).append("','INSERIR')");
            sql.append(" where not find_in_set(:tag,cliente.tags)");
        } else if (action.equals((Object)ClienteTagsActionEnum.EXCLUIR)) {
            sql.append("cliente.tags=TAG_CHANGE(tags,'").append(tags).append("','EXCLUIR')");
            sql.append(" where find_in_set(:tag,cliente.tags) ");
        } else if (action.equals((Object)ClienteTagsActionEnum.LIMPAR)) {
            sql.append("cliente.tags=''");
            sql.append(" where 1=1");
        } else if (action.equals((Object)ClienteTagsActionEnum.SOBREPOR)) {
            sql.append("cliente.tags=:tag");
            sql.append(" where 1=1");
        }
        sql.append(" and cliente.estrutura_id=estrutura.id");
        sql.append(" and estrutura.id=:estruturaId");
        sql.append(" and cliente.id in :ids");
        Query query = this.manager.createNativeQuery(sql.toString());
        if (!action.equals((Object)ClienteTagsActionEnum.LIMPAR)) {
            query.setParameter("tag", (Object)tags);
        }
        query.setParameter("estruturaId", (Object)estrutura.getId());
        query.setParameter("ids", ids);
        query.executeUpdate();
    }

    @Transactional(readOnly=true)
    public List<ClienteResponsavelDTO> getResponsaveis(Estrutura estrutura, Set<ClienteDTO> clientes) {
        HashSet<Long> listaIds = new HashSet<Long>();
        for (ClienteDTO dto : clientes) {
            listaIds.add(dto.getId());
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT (select uuid_short()) as id,c.cpf_cnpj,c.tags tag_cliente,c.nome nome_cliente,u.nome nome_responsavel,u.login login_responsavel,e.nome nome_equipe,u.tags tag_usuario");
        sql.append(" FROM cliente c");
        sql.append(" LEFT JOIN cliente_responsavel cr on (c.id=cr.cliente_id)");
        sql.append(" LEFT JOIN estrutura_usuario eu on (cr.estrutura_usuario_id=eu.id)");
        sql.append(" LEFT JOIN usuario u on (u.id=eu.usuario_id)");
        sql.append(" LEFT JOIN equipe e on (eu.equipe_id=e.id)");
        sql.append(" WHERE c.id in :listaIds and eu.ativo=1");
        sql.append(" AND c.estrutura_id=:estruturaId");
        Query query = this.manager.createNativeQuery(sql.toString(), ClienteResponsavelDTO.class);
        query.setParameter("listaIds", listaIds);
        query.setParameter("estruturaId", (Object)estrutura.getId());
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<PessoaDTO> getPessoas(Estrutura estrutura, Set<ClienteDTO> clientes) {
        HashSet<Long> listaIds = new HashSet<Long>();
        for (ClienteDTO dto : clientes) {
            listaIds.add(dto.getId());
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT (select uuid_short()) as id,c.cpf_cnpj,c.nome nome_cliente,p.nome nome_pessoa,p.cpf,p.rg,p.email,p.celular,p.telefone2 telefone,p.nascimento,p.papel");
        sql.append(" FROM cliente c");
        sql.append(" JOIN pessoa p on (c.id=p.cliente_id)");
        sql.append(" WHERE c.id in :listaIds");
        sql.append(" AND c.estrutura_id=:estruturaId");
        Query query = this.manager.createNativeQuery(sql.toString(), PessoaDTO.class);
        query.setParameter("listaIds", listaIds);
        query.setParameter("estruturaId", (Object)estrutura.getId());
        return query.getResultList();
    }
}

