/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.service;

import br.com.system.app.features.cliente.model.ClienteTag;
import br.com.system.app.features.cliente.repository.ClienteTagRepository;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.commons.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClienteTagService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ClienteTagRepository clienteTagRepository;

    @Transactional
    @Modifying
    public void delete(ClienteTag ct) {
        this.clienteTagRepository.delete((Object)ct);
    }

    public String saveTags(String tags, EstruturaUsuario eu) {
        String normalizedTags = StringUtil.normalizeTags((String)tags);
        for (String tag : normalizedTags.split(",")) {
            if ((tag = tag.trim()).isEmpty() || this.clienteTagRepository.findByEstruturaAndTag(eu.getEstrutura(), tag) != null) continue;
            ClienteTag ct = new ClienteTag();
            ct.setEstrutura(eu.getEstrutura());
            ct.setTag(tag);
            ct.setUsuario(eu.getUsuario());
            this.clienteTagRepository.save((Object)ct);
        }
        return normalizedTags;
    }

    public ClienteTag save(ClienteTag clienteTag) {
        if (clienteTag.getEstrutura() == null) {
            throw new BusinessException("Estrutura  \u00e9 obrigatorio");
        }
        if (clienteTag.getUsuario() == null) {
            throw new BusinessException("Usuario criacao  \u00e9 obrigatorio");
        }
        if (clienteTag.getTag() == null || clienteTag.getTag().isBlank()) {
            throw new BusinessException("Tag \u00e9 obrigatoria");
        }
        return (ClienteTag)this.clienteTagRepository.save((Object)clienteTag);
    }

    public List<ClienteTag> getTags(Estrutura estrutura) {
        return this.clienteTagRepository.findByEstrutura(estrutura);
    }

    public Set<ClienteTag> getTags(Estrutura estrutura, String tags) {
        return this.clienteTagRepository.findTags(estrutura.getId(), tags);
    }

    public String getStringtags(Set<ClienteTag> tags) {
        ArrayList<String> l = new ArrayList<String>();
        for (ClienteTag tag : tags) {
            l.add(tag.getTag());
        }
        return StringUtils.join(l, (String)",");
    }

    public List<ClienteTag> getByEstrutura(Estrutura estrutura, Set<String> value, Pageable pageable) {
        if (value == null || value.size() <= 0) {
            return this.clienteTagRepository.findByEstrutura(estrutura, pageable);
        }
        return this.clienteTagRepository.findByEstruturaAndTagIn(estrutura, value, pageable);
    }

    public void deleteTagByEstrutura(Estrutura estrutura) {
        List tags = this.clienteTagRepository.findByEstrutura(estrutura);
        for (ClienteTag tag : tags) {
            this.delete(tag);
        }
    }

    public long countByEstrutura(Estrutura estrutura, Set<String> value) {
        if (value == null || value.size() <= 0) {
            return this.clienteTagRepository.countByEstrutura(estrutura);
        }
        return this.clienteTagRepository.countByEstruturaAndTagIn(estrutura, value);
    }
}

