/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.service;

import br.com.system.app.features.cliente.model.ClienteLastOrderDTO;
import br.com.system.app.features.cliente.model.ClienteTrigger;
import br.com.system.app.features.cliente.repository.ClienteTriggerRepository;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.pedido.service.PedidoService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClienteTriggerService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ClienteTriggerRepository clienteTriggerRepository;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;

    public List<ClienteTrigger> getByEstrutura(Estrutura estrutura, String nome, Pageable pageable) {
        if (nome != null && !nome.isEmpty()) {
            return this.clienteTriggerRepository.findByEstruturaUsuarioEstruturaAndNomeContains(estrutura, nome, pageable);
        }
        return this.clienteTriggerRepository.findByEstruturaUsuarioEstrutura(estrutura, pageable);
    }

    public List<ClienteTrigger> getByEstrutura(Estrutura estrutura) {
        return this.clienteTriggerRepository.findByEstruturaUsuarioEstrutura(estrutura);
    }

    public long countByEstrutura(Estrutura estrutura, String nome) {
        if (nome != null && !nome.isEmpty()) {
            return this.clienteTriggerRepository.countByEstruturaUsuarioEstruturaAndNomeContains(estrutura, nome);
        }
        return this.clienteTriggerRepository.countByEstruturaUsuarioEstrutura(estrutura);
    }

    @Transactional
    public ClienteTrigger save(ClienteTrigger clienteTrigger, EstruturaUsuario eu) {
        if (clienteTrigger.getEstruturaUsuario() == null) {
            clienteTrigger.setEstruturaUsuario(eu);
        }
        if (clienteTrigger.getDataCriacao() == null) {
            clienteTrigger.setDataCriacao(LocalDate.now());
        }
        return (ClienteTrigger)this.clienteTriggerRepository.save((Object)clienteTrigger);
    }

    @Transactional
    @Modifying
    public void delete(ClienteTrigger clienteTrigger) {
        this.clienteTriggerRepository.delete((Object)clienteTrigger);
    }

    public void triggerProcess() {
        List triggers = this.clienteTriggerRepository.findByAtivo(Boolean.valueOf(true));
        for (ClienteTrigger trigger : triggers) {
            if (!trigger.getEstruturaUsuario().getEstrutura().getId().equals(1512L)) continue;
            List<EstruturaUsuario> lEu = this.estruturaUsuarioService.getByUserTag(trigger.getEstruturaUsuario().getEstrutura(), trigger.getTagUsuario());
            if (lEu.size() <= 0) {
                lEu = Arrays.asList(this.estruturaUsuarioService.getMasterEstrutura(trigger.getEstruturaUsuario().getEstrutura()));
            }
            List clientForTrigger = this.clienteService.getByTrigger(trigger.getEstruturaUsuario().getEstrutura(), trigger);
            int ind = 0;
            for (ClienteLastOrderDTO clienteLastOrderDTO : clientForTrigger) {
                ind = ind >= lEu.size() ? 0 : ind;
                Pedido pedido = new Pedido();
                pedido.setCliente(this.clienteService.getById(clienteLastOrderDTO.getId()));
                pedido.setComplementos("Atividade criada pelo gatilho " + trigger.getNome() + "\n Periodo: " + trigger.getDias() + " sem contato\n Tags: " + trigger.getTagsCliente());
                pedido.setEstruturaUsuario(lEu.get(ind));
                pedido.setTags(trigger.getTagsAtividade());
                pedido.setPedidoTipo(trigger.getTipo());
                this.pedidoService.salvar(pedido);
                ++ind;
            }
        }
    }
}

