/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.components.importacao.ImportacaoColunas;
import br.com.system.app.components.importacao.ImportacaoExcel;
import br.com.system.app.features.cliente.service.ClienteImportacaoThread;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="importacao-cliente", layout=MainLayout.class)
@PageTitle(value="Importacao Cliente")
@RolesAllowed(value={"CLIENTE_IMPORTACAO_VIEW"})
public class ClienteImportacaoView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private ImportacaoExcel ie;
    private final ClienteImportacaoThread clienteImportacaoThread;
    private List<ImportacaoColunas> colunas;

    @Autowired
    public ClienteImportacaoView(ClienteImportacaoThread clienteImportacaoThread) {
        this.clienteImportacaoThread = clienteImportacaoThread;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.setViewContent(this.create());
        }
    }

    private Component create() {
        this.setColunas();
        this.ie.getBtnConfirmar().addClickListener((ComponentEventListener & Serializable)e -> {
            if (!this.ie.isValido()) {
                this.showNotification("H\u00e1 colunas obrigatorias n\u00e3o vinculadas");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Importar clientes", "Confirma importa\u00e7\u00e3o?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)confirmar -> {
                try {
                    this.clienteImportacaoThread.importar(this.ie.getPosicoes(), this.ie.getContent(), this.ie.getNomeArquivo(), this.getEu());
                    this.showNotification("Importa\u00e7\u00e3o concluida, voc\u00ea pode ver o resultado nas notificacoes");
                    this.ie.clear();
                    cd.close();
                }
                catch (Exception ex) {
                    this.showNotification("Erro ao importar, avise o suporte");
                }
            });
        });
        Button btnEmail = UIUtils.createSmallButton((String)"Email", (VaadinIcon)VaadinIcon.PLUS, (String)"Inserir Coluna de Email");
        btnEmail.addClickListener((ComponentEventListener & Serializable)e -> {
            int ind = 1;
            for (ImportacaoColunas ic : this.ie.getColunas()) {
                if (!ic.getNome().contains("E-MAIL")) continue;
                ++ind;
            }
            this.ie.getColunas().add(new ImportacaoColunas("E-MAIL " + ind, Boolean.FALSE));
            this.ie.refreshGrid();
        });
        Button btnTel = UIUtils.createSmallButton((String)"Telefone", (VaadinIcon)VaadinIcon.PLUS, (String)"Inserir Coluna de Telefone");
        btnTel.addClickListener((ComponentEventListener & Serializable)e -> {
            int ind = 1;
            for (ImportacaoColunas ic : this.ie.getColunas()) {
                if (!ic.getNome().contains("TELEFONE")) continue;
                ++ind;
            }
            this.ie.getColunas().add(new ImportacaoColunas("TELEFONE " + ind, Boolean.FALSE));
            this.ie.refreshGrid();
        });
        TextField text = new TextField();
        text.setReadOnly(true);
        text.setWidthFull();
        text.setValue("Campos: E-mail(s),Telefone(s),LoginRespons\u00e1vel(is), podem conter multiplas informa\u00e7\u00f5es, devem ser separadas por virgula");
        return new VerticalContainer(new Component[]{this.ie, new HorizontalContainer(new Component[]{btnTel, btnEmail})});
    }

    private void setColunas() {
        this.colunas = new ArrayList();
        this.colunas.add(new ImportacaoColunas("CNPJ", Boolean.TRUE));
        this.colunas.add(new ImportacaoColunas("NOME", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("TAGS", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("LOGIN_RESPONSAVEL(is)", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("CEP", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("LOGRADOURO", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("NRO", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("BAIRRO", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("CIDADE", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("ESTADO", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("DADOS COMPLEMENTARES", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("CLASSIFICA\u00c7\u00c3O", Boolean.FALSE));
        if (this.isClaro()) {
            this.colunas.add(new ImportacaoColunas("TEMPO M\u00c9DIO", Boolean.FALSE));
        }
        this.colunas.add(new ImportacaoColunas("FORNECEDOR", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("PRODUTO", Boolean.FALSE));
        if (this.isTicket()) {
            this.colunas.add(new ImportacaoColunas("COLABORADORES", Boolean.FALSE));
            this.colunas.add(new ImportacaoColunas("VALOR_DIA", Boolean.FALSE));
            this.colunas.add(new ImportacaoColunas("NRO_DIAS", Boolean.FALSE));
            this.colunas.add(new ImportacaoColunas("DESAGIO", Boolean.FALSE));
        } else {
            this.colunas.add(new ImportacaoColunas("QUANTIDADE", Boolean.FALSE));
            this.colunas.add(new ImportacaoColunas("VALOR", Boolean.FALSE));
        }
        if (this.isTelefonia() || this.isProvedor()) {
            this.colunas.add(new ImportacaoColunas("DATA ATIVA\u00c7\u00c3O", Boolean.FALSE));
        }
        this.colunas.add(new ImportacaoColunas("DATA FIDELIDADE", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("E-MAIL 1", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("E-MAIL 2", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("TELEFONE 1", Boolean.FALSE));
        this.colunas.add(new ImportacaoColunas("TELEFONE 2", Boolean.FALSE));
        this.ie = new ImportacaoExcel(this.colunas);
    }
}

