/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cobranca;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cobranca.CobrancaFaturaScreen;
import br.com.system.app.features.cobranca.model.CobrancaAssinatura;
import br.com.system.app.features.cobranca.model.CobrancaFatura;
import br.com.system.app.features.cobranca.model.CobrancaTipoEnum;
import br.com.system.app.features.cobranca.model.StatusPagamento;
import br.com.system.app.features.cobranca.service.CobrancaAssinaturaService;
import br.com.system.app.features.cobranca.service.CobrancaFaturaService;
import br.com.system.app.features.cobranca.service.CobrancaService;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.starkbank.StarkBankService;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.storage.model.UrlSign;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import com.starkbank.Boleto;
import com.starkbank.Invoice;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class CobrancaFaturaScreen
extends VerticalContainer
implements SecurityContext,
Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private CobrancaService cobrancaService;
    @Autowired
    private CobrancaAssinaturaService cas;
    @Autowired
    private CobrancaFaturaService cobrancaFaturaService;
    @Autowired
    private ConfigurationsService configurationsService;
    @Autowired
    private StarkBankService bankService;
    private Grid<CobrancaFatura> grid;
    private final Button btnClose = UIUtils.createSmallButton((String)"Fechar");
    private NumberField valor;
    private ComboBox<CobrancaTipoEnum> cbTipo;
    private DatePicker dataVencimento;
    private boolean financeiro;

    public CobrancaFaturaScreen() {
        super(new com.vaadin.flow.component.Component[0]);
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public Button getBtnClose() {
        return this.btnClose;
    }

    public VerticalContainer create(CobrancaAssinatura ca, EstruturaUsuario eu) {
        VerticalContainer lay = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        this.financeiro = this.configurationsService.get(ConfigurationEnum.LOGINS_ACESSO_ASSINATURAS).getValor().contains(eu.getUsuario().getLogin());
        lay.removeAll();
        lay.setFull();
        Button btnAlterar = UIUtils.createSmallButton((String)"Alterar");
        btnAlterar.setVisible(this.cas.temPermissao(this.getUsuario().getLogin()) && ca != null);
        btnAlterar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.grid.getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione uma fatura para alterar");
                return;
            }
            CobrancaFatura cf = (CobrancaFatura)this.grid.getSelectedItems().iterator().next();
            if (!cf.getStatus().equals((Object)StatusPagamento.EM_ABERTO)) {
                UIUtils.showNotification((String)"Fatura n\u00e3o permite cancelamento/altera\u00e7\u00e3o");
                return;
            }
            if (!cf.getTipo().equals((Object)CobrancaTipoEnum.PIX)) {
                UIUtils.showNotification((String)"Altera\u00e7\u00e3o apenas em PIX. Boleto deve excluir e criar outro.");
                return;
            }
            this.openInvoice(ca, cf);
        });
        Button btnBaixar = UIUtils.createSmallButton((String)"Baixar manual");
        btnBaixar.setVisible(this.financeiro && ca != null);
        btnBaixar.addClickListener((ComponentEventListener & Serializable)e -> {
            ConfirmationDialog cd = new ConfirmationDialog("Baixa Manual", "Tem certeza que Baixar manualmente este pagamento?");
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                if (this.grid.getSelectedItems().size() <= 0) {
                    UIUtils.showNotification((String)"Selecione uma fatura para baixar");
                    return;
                }
                CobrancaFatura cf = (CobrancaFatura)this.grid.getSelectedItems().iterator().next();
                if (!cf.getStatus().equals((Object)StatusPagamento.EM_ABERTO)) {
                    UIUtils.showNotification((String)"Fatura n\u00e3o permite baixa");
                    return;
                }
                cf.setDataPagamento(LocalDate.now());
                cf.setStatus(StatusPagamento.BAIXA_MANUAL);
                cf.setValorPago(cf.getValor());
                this.update(cf, TipoUpdateFaturaEnum.BAIXA);
                this.cobrancaService.checarInadimplencia(cf.getCobrancaAssinatura().getCpfCnpj());
                cd.close();
                this.povoa(ca);
            });
        });
        Button btnCancelarFatura = UIUtils.createSmallButton((String)"Cancelar");
        btnCancelarFatura.setVisible(this.financeiro && ca != null);
        btnCancelarFatura.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.grid.getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione uma fatura para cancelar");
                return;
            }
            CobrancaFatura cf = (CobrancaFatura)this.grid.getSelectedItems().iterator().next();
            if (!cf.getStatus().equals((Object)StatusPagamento.EM_ABERTO)) {
                UIUtils.showNotification((String)"Fatura n\u00e3o permite cancelamento");
                return;
            }
            this.update(cf, TipoUpdateFaturaEnum.CANCELAMENTO);
        });
        Button btnNovaFatura = UIUtils.createSmallButton((String)"Fatura Avulsa");
        btnNovaFatura.setEnabled(false);
        btnNovaFatura.setVisible(this.financeiro);
        btnNovaFatura.addClickListener((ComponentEventListener & Serializable)e -> this.openInvoice(ca, new CobrancaFatura()));
        this.grid = new Grid(CobrancaFatura.class);
        this.grid.setWidthFull();
        this.grid.setColumns(new String[0]);
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> Long.toString(p.getId()))).setHeader("Cria\u00e7\u00e3o").setFlexGrow(0).setWidth("160px");
        this.grid.addComponentColumn((ValueProvider & Serializable)item -> {
            if (item.getStatus().equals((Object)StatusPagamento.CANCELADO)) {
                return new Span("Cancel");
            }
            if (item.getStatus().equals((Object)StatusPagamento.BAIXA_MANUAL)) {
                return new Span("Baixa Manual");
            }
            if (!item.getStatus().equals((Object)StatusPagamento.EM_ABERTO)) {
                return new Span("Pago");
            }
            if (item.getTipo().equals((Object)CobrancaTipoEnum.PIX)) {
                Invoice invoice = this.bankService.getInvoice(item.getStarkId());
                Anchor anchor = new Anchor(invoice.link, new com.vaadin.flow.component.Component[0]);
                anchor.setText("PIX");
                anchor.setTitle("Abrir PIX para pagamento");
                anchor.setVisible(invoice.link != null);
                anchor.setTarget("_blank");
                return anchor;
            }
            if (item.getStarkId() == null || item.getStarkId().isEmpty()) {
                return new Span("");
            }
            Boleto boleto = this.bankService.getBoleto(item.getStarkId());
            Anchor anchor = new Anchor("https://neo.starkbank.com/boletolink-detail/" + boleto.id, new com.vaadin.flow.component.Component[0]);
            anchor.setText("BOLETO");
            anchor.setTitle("Baixar Boleto");
            anchor.setVisible(boleto.id != null);
            anchor.setTarget("_blank");
            return anchor;
        }).setHeader("Pagar").setFlexGrow(0).setWidth("130px");
        if (this.financeiro) {
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getObservacao()))).setHeader("Observa\u00e7\u00e3o").setFlexGrow(0).setWidth("250px");
        }
        Button btnContrato = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.FILE_TEXT_O, (String)"Contrato");
        btnContrato.addClickListener((ComponentEventListener & Serializable)e -> {
            UrlSign urlSign = StorageUtil.getUrlSign((String)"contrato_neosales.pdf", (String)"files-neosales");
            UI.getCurrent().getPage().open(urlSign.getUrl(), "_blank");
        });
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHoraCriacao() == null ? "" : p.getDataHoraCriacao().toLocalDate().format(FormatDate.DATE_BR.toDTF()))).setHeader("Cria\u00e7\u00e3o").setFlexGrow(0).setWidth("160px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataVencimento() == null ? "" : p.getDataVencimento().format(FormatDate.DATE_BR.toDTF()))).setHeader("Vencimento").setFlexGrow(0).setWidth("160px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getValor() == null ? "" : p.getValor().toString())).setHeader("Valor").setFlexGrow(0).setWidth("150px");
        this.grid.addComponentColumn((ValueProvider & Serializable)item -> {
            if (item.getLinkPdfEnotas() != null && !item.getLinkPdfEnotas().isEmpty()) {
                Anchor anchor = new Anchor(item.getLinkPdfEnotas(), new com.vaadin.flow.component.Component[0]);
                anchor.setText("Baixar");
                anchor.setTitle("Baixar PDF da Nota fiscal");
                anchor.setVisible(item.getLinkPdfEnotas() != null && !item.getLinkPdfEnotas().isEmpty());
                anchor.setTarget("_blank");
                return anchor;
            }
            if (item.getEnotasId() == null || item.getEnotasId().isEmpty()) {
                Button btnGerarNF = UIUtils.createSmallButton((String)"Gerar");
                btnGerarNF.setVisible((item.getEnotasId() == null || item.getEnotasId().isEmpty()) && !item.getStatus().equals((Object)StatusPagamento.CANCELADO) && item.getDataHoraCriacao().toLocalDate().isAfter(DateTimeUtil.toDate((String)"2021-03-01", (FormatDate)FormatDate.US_DATE)));
                btnGerarNF.addClickListener((ComponentEventListener & Serializable)e -> {
                    this.cobrancaFaturaService.emitirNota(item);
                    UIUtils.showNotification((String)"Emiss\u00e3o de nota fiscal solicitada, dentro de instantes ser\u00e1 enviada no seu e-mail");
                    this.povoa(ca);
                });
                return btnGerarNF;
            }
            if (item.getStatus().equals((Object)StatusPagamento.CANCELADO)) {
                return new Span("Cancelado");
            }
            return new Span("Processando");
        }).setHeader("NF").setFlexGrow(0).setWidth("180px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getStatus().name())).setHeader("status").setFlexGrow(0).setWidth("190px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getCobrancaAssinatura().getCpfCnpj())).setHeader("CPF-CNPJ").setFlexGrow(0).setWidth("160px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getCobrancaAssinatura().getNome()))).setHeader("Cliente").setFlexGrow(0).setWidth("250px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataPagamento() == null ? "" : p.getDataPagamento().format(FormatDate.DATE_BR.toDTF()))).setHeader("Pagamento").setFlexGrow(0).setWidth("160px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getValorPago() == null ? "" : p.getValorPago().toString())).setHeader("Valor Pago").setFlexGrow(0).setWidth("180px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getAvulsa() != false ? "Avulsa" : "Mensal")).setHeader("Tipo").setFlexGrow(0).setWidth("140px");
        Div divInadimplencia = new Div();
        divInadimplencia.getElement().setProperty("innerHTML", "<span><h4>H\u00e1 mensalidade(s) em aberto.Por favor entre em contato com Financeiro(Marta)</h4> <a href=\"https://wa.me/554731703219\" data-toggle=\"tooltip\" target=\"_blank\" title=\"Financeiro NEO\"><img src=\"images/whats30.png\"></a></span>");
        lay.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{btnContrato, UIUtils.createHeader((String)"Faturas geradas")}).setNoWrap()});
        if (ca.isInadimplente()) {
            lay.add(new com.vaadin.flow.component.Component[]{divInadimplencia});
        }
        lay.add(new com.vaadin.flow.component.Component[]{new HorizontalContainer(new com.vaadin.flow.component.Component[]{this.btnClose, btnNovaFatura, btnCancelarFatura, btnAlterar, btnBaixar}), this.grid});
        this.povoa(ca);
        return lay;
    }

    private void povoa(CobrancaAssinatura ca) {
        this.grid.setItems((Collection)this.cobrancaFaturaService.getByCobrancaAssinatura(ca));
    }

    private void openInvoice(CobrancaAssinatura ca, CobrancaFatura cf) {
        Dialog d = new Dialog();
        this.valor = new NumberField("Valor Fatura");
        this.valor.setValue(cf.getValor() == null ? null : Double.valueOf(cf.getValor().doubleValue()));
        this.cbTipo = new ComboBox("Tipo", (Object[])CobrancaTipoEnum.values());
        this.cbTipo.setItemLabelGenerator(Enum::name);
        this.cbTipo.setEnabled(cf.getId() == null);
        this.cbTipo.setValue((Object)(cf.getTipo() == null ? ca.getTipo() : cf.getTipo()));
        this.dataVencimento = new DatePicker();
        this.dataVencimento.setLabel("Vencimento");
        this.dataVencimento.setValue(cf.getDataVencimento() == null ? LocalDate.now().plusDays(8L) : cf.getDataVencimento());
        this.dataVencimento.setLocale(UIUtils.getLocale());
        TextArea ta = new TextArea("Justificativa");
        ta.setWidth("100%");
        ta.setHeight("200px");
        Button b = UIUtils.createSmallButton((String)(cf.getId() == null ? "Criar Fatura" : "Alterar Fatura"));
        b.addClickListener((ComponentEventListener & Serializable)bc -> {
            if (this.valor.getValue() == null || (Double)this.valor.getValue() <= 0.0) {
                UIUtils.showNotification((String)"Valor n\u00e3o pode ser zero.");
                return;
            }
            if (this.dataVencimento.getValue() == null) {
                UIUtils.showNotification((String)"Informe uma data de vencimento");
                return;
            }
            if (this.cbTipo.getValue() == null) {
                UIUtils.showNotification((String)"Selecione o tipo");
                return;
            }
            if (ta.getValue() == null || ta.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Informe uma justificativa");
                return;
            }
            try {
                if (cf.getId() == null) {
                    this.cobrancaFaturaService.criarFaturaAvulsa(ca, BigDecimal.valueOf((Double)this.valor.getValue()), (CobrancaTipoEnum)this.cbTipo.getValue(), (LocalDate)this.dataVencimento.getValue(), "Cria\u00e7\u00e3o Fatura Avulsa: " + ta.getValue());
                    UIUtils.showNotification((String)"Fatura criada com sucesso");
                } else {
                    cf.setValor(BigDecimal.valueOf((Double)this.valor.getValue()));
                    cf.setDataVencimento((LocalDate)this.dataVencimento.getValue());
                    this.cobrancaFaturaService.updateFatura(this.getEu(), cf, "Altera\u00e7\u00e3o " + ta.getValue());
                    UIUtils.showNotification((String)"Fatura Alterada com sucesso");
                }
                this.povoa(ca);
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)ex.getMessage());
            }
            d.close();
        });
        Button c = UIUtils.createSmallButton((String)"Fechar");
        c.addClickListener((ComponentEventListener & Serializable)close -> d.close());
        d.add(new com.vaadin.flow.component.Component[]{new VerticalContainer(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Fatura Avulsa"), this.cbTipo, this.valor, this.dataVencimento, ta, new FooterContainer(new com.vaadin.flow.component.Component[]{c, b})})});
        d.open();
    }

    private void update(CobrancaFatura cf, TipoUpdateFaturaEnum tipo) {
        Dialog d = new Dialog();
        d.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)(tipo.equals((Object)TipoUpdateFaturaEnum.CANCELAMENTO) ? "CANCELAMENTO DE FATURA" : "BAIXA MANUAL"))});
        TextArea ta = new TextArea("Justificativa");
        ta.setWidth("100%");
        ta.setHeight("200px");
        Button bClose = UIUtils.createSmallButton((String)"Fechar");
        bClose.addClickListener((ComponentEventListener & Serializable)close -> d.close());
        Button bSave = UIUtils.createSmallButton((String)"Salvar");
        bSave.addClickListener((ComponentEventListener & Serializable)e -> {
            if (ta.getValue() == null || ta.getValue().isEmpty()) {
                UIUtils.showNotification((String)"Informe uma justificativa para a a\u00e7\u00e3o");
                return;
            }
            if (tipo.equals((Object)TipoUpdateFaturaEnum.CANCELAMENTO)) {
                this.cobrancaFaturaService.cancelarFatura(this.getEu(), cf, "Cancelamento " + ta.getValue());
                UIUtils.showNotification((String)"Fatura cancelada com sucesso");
            } else if (tipo.equals((Object)TipoUpdateFaturaEnum.BAIXA)) {
                this.cobrancaFaturaService.updateFatura(this.getEu(), cf, "Baixa Manual: " + ta.getValue());
                UIUtils.showNotification((String)"Baixado com sucesso");
            }
            this.povoa(cf.getCobrancaAssinatura());
            d.close();
        });
        d.add(new com.vaadin.flow.component.Component[]{ta, new FooterContainer(new com.vaadin.flow.component.Component[]{bClose, bSave})});
        d.open();
    }
}

