/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.configurations;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.configurations.model.ConfigurationEnum;
import br.com.system.app.features.configurations.model.Configurations;
import br.com.system.app.features.configurations.service.ConfigurationsService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="autenticacao-sms", layout=MainLayout.class)
@PageTitle(value="Habilita/Desabilita autenticacao via SMS")
@RolesAllowed(value={"MASTER"})
public class AutenticacaoSmsView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ConfigurationsService configurationsService;

    @Autowired
    public AutenticacaoSmsView(ConfigurationsService configurationsService) {
        this.configurationsService = configurationsService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado() && this.isMaster()) {
            this.setViewContent(this.createContent());
        } else {
            this.showNotification("Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        RadioButtonGroup rb = new RadioButtonGroup("Autentica\u00e7\u00e3o via SMS", (Object[])new String[]{"Ligado", "Desligado"});
        Configurations configurations = this.configurationsService.get(ConfigurationEnum.AUTENTICACAO_SMS);
        if (configurations.getValor().equals("true")) {
            rb.setValue((Object)"Ligado");
        } else {
            rb.setValue((Object)"Desligado");
        }
        this.add(new Component[]{rb});
        Button btn = UIUtils.createSmallButton((String)"Salvar");
        btn.addClickListener((ComponentEventListener & Serializable)e -> {
            if ("Ligado".equals(rb.getValue())) {
                configurations.setValor("true");
            } else {
                configurations.setValor("false");
            }
            this.configurationsService.save(configurations);
        });
        VerticalContainer main = new VerticalContainer(new Component[]{rb, new FooterContainer(new Component[]{btn})});
        this.add(new Component[]{main});
        return main;
    }
}

