/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dicasistema;

import br.com.system.app.features.dicasistema.model.DicaSistema;
import br.com.system.app.features.dicasistema.service.DicaSistemaService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.storage.StorageUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.IFrame;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.server.AbstractStreamResource;

public class DicaHomeView
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private final DicaSistemaService dicaSistemaService;
    private final EstruturaUsuario euContext;
    private DicaSistema dica;

    public DicaHomeView(DicaSistemaService dicaSistemaService, EstruturaUsuario euContext) {
        this.dicaSistemaService = dicaSistemaService;
        this.euContext = euContext;
        this.create();
        this.setAlignItems(FlexComponent.Alignment.CENTER);
    }

    private void create() {
        try {
            this.setHeight("98%");
            this.dica = this.dicaSistemaService.getPadrao(this.euContext.getEstrutura().getEstruturaTipo());
            if (this.dica == null) {
                return;
            }
            Span span = new Span();
            span.getElement().setProperty("innerHTML", "<span>" + this.dica.getTexto() + "</span>");
            this.add(new Component[]{span});
            if (this.dica.getUrlYoutube() != null && !this.dica.getUrlYoutube().isEmpty()) {
                this.add(new Component[]{this.showYoutube()});
            } else {
                this.add(new Component[]{this.showImage()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Image showImage() throws Exception {
        Image i = new Image((AbstractStreamResource)StorageUtil.getStreamResource((String)this.dica.getHashImagem(), (String)"Imagem Dica"), "Home Image");
        i.setMaxHeight("95%");
        i.setMaxWidth("95%");
        return i;
    }

    private IFrame showYoutube() {
        IFrame iFrame = new IFrame(this.dica.getUrlYoutube());
        iFrame.setWidth("1280px");
        iFrame.setHeight("720px");
        iFrame.setAllow("accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture");
        iFrame.getElement().setAttribute("allowfullscreen", true);
        iFrame.getElement().setAttribute("frameborder", "2");
        return iFrame;
    }
}

