/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dicasistema;

import br.com.system.app.MainLayout;
import br.com.system.app.components.Card;
import br.com.system.app.features.dicasistema.model.DicaSistema;
import br.com.system.app.features.dicasistema.service.DicaSistemaService;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.layout.util.TextAlign;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.StringUtil;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.IFrame;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

@Route(value="dica-sistema-treino", layout=MainLayout.class)
@PageTitle(value="Treinamento")
public class DicaTreinoView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final DicaSistemaService dicaSistemaService;
    private HashMap<Integer, Integer> hmPage;

    public DicaTreinoView(DicaSistemaService dicaSistemaService) {
        this.dicaSistemaService = dicaSistemaService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.setViewContent((Component)this.create());
    }

    private FlexBoxLayout create() {
        this.hmPage = new HashMap();
        FlexBoxLayout main = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[0]).setSpacingS();
        main.setAlignItems(FlexComponent.Alignment.BASELINE);
        main.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        List modulos = this.dicaSistemaService.getModulesName(this.getEu().getEstrutura().getEstruturaTipo());
        int indCard = 0;
        for (String modulo : modulos) {
            this.hmPage.put(indCard, 0);
            main.add(new Component[]{this.createCards(modulo, Integer.valueOf(indCard))});
            ++indCard;
        }
        return main;
    }

    private Card createCards(String module, Integer indCard) {
        Card card = new Card();
        card.setId(indCard.toString());
        FlexBoxLayout videoContent = new FlexBoxLayout();
        FlexBoxLayout textoContent = new FlexBoxLayout();
        List dicas = this.dicaSistemaService.getByEstruturaTipo(this.getEstrutura().getEstruturaTipo(), module);
        FlexBoxLayout videoContainer = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]);
        FlexBoxLayout btnContainer = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[0]).setSpacingM();
        btnContainer.setAlignItems(FlexComponent.Alignment.BASELINE);
        Button btnProximo = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.STEP_FORWARD, (String)"Pr\u00f3ximo v\u00eddeo");
        Button btnAnterior = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.STEP_BACKWARD, (String)"V\u00eddeo anterior");
        TextField tf = new TextField();
        tf.setReadOnly(true);
        tf.setWidth("80px");
        UIUtils.setTextAlign((TextAlign)TextAlign.CENTER, (Component[])new Component[]{tf});
        btnContainer.add(new Component[]{btnAnterior, tf, btnProximo});
        btnContainer.setId((String)card.getId().get());
        btnProximo.addClickListener((ComponentEventListener & Serializable)e -> {
            int idCard = StringUtil.toInt((String)((String)((Component)((Button)e.getSource()).getParent().get()).getId().get()));
            this.hmPage.get(idCard);
            this.hmPage.put(idCard, (Integer)this.hmPage.get(idCard) + 1);
            this.showDica(videoContent, textoContent, tf, dicas, Integer.valueOf(idCard));
        });
        btnAnterior.addClickListener((ComponentEventListener & Serializable)e -> {
            int idCard = StringUtil.toInt((String)((String)((Component)((Button)e.getSource()).getParent().get()).getId().get()));
            this.hmPage.get(idCard);
            this.hmPage.put(idCard, (Integer)this.hmPage.get(idCard) - 1);
            this.showDica(videoContent, textoContent, tf, dicas, Integer.valueOf(idCard));
        });
        videoContainer.add(new Component[]{videoContent, btnContainer});
        this.showDica(videoContent, textoContent, tf, dicas, Integer.valueOf(StringUtil.toInt((String)((String)card.getId().get()))));
        card.setMaxWidth("426px");
        card.getContentBox().setHeightFull();
        card.setHeader(module);
        card.setContent(new Component[]{videoContainer, textoContent});
        return card;
    }

    private void showDica(FlexBoxLayout videoContent, FlexBoxLayout textoContent, TextField tf, List<DicaSistema> dicas, Integer idCard) {
        int indVideo = (Integer)this.hmPage.get(idCard);
        if (indVideo < 0) {
            this.hmPage.put(idCard, 0);
            return;
        }
        if (indVideo >= dicas.size()) {
            this.hmPage.put(idCard, dicas.size() - 1);
            return;
        }
        tf.setValue(indVideo + 1 + " de " + dicas.size());
        videoContent.removeAll();
        textoContent.removeAll();
        Div htmlBlock = new Div();
        htmlBlock.getElement().setProperty("innerHTML", dicas.get(indVideo).getTexto());
        textoContent.add(new Component[]{htmlBlock});
        IFrame iFrame = new IFrame(dicas.get(indVideo).getUrlYoutube());
        iFrame.setHeight("240px");
        iFrame.setWidth("426px");
        iFrame.setAllow("accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture");
        iFrame.getElement().setAttribute("allowfullscreen", true);
        iFrame.getElement().setAttribute("frameborder", "2");
        videoContent.add(new Component[]{iFrame});
    }
}

