/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.dicasistema.service;

import br.com.system.app.features.dicasistema.model.DicaSistema;
import br.com.system.app.features.dicasistema.repository.DicaSistemaRepository;
import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.FileUtil;
import br.com.system.commons.HashUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DicaSistemaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private DicaSistemaRepository dicaSistemaRepository;

    public List<String> getModulesName(EstruturaTipo et) {
        return this.dicaSistemaRepository.findModulesList(et.getNome());
    }

    public DicaSistema getPadrao(EstruturaTipo tipo) {
        return this.dicaSistemaRepository.getPadrao(tipo.getNome());
    }

    public List<DicaSistema> getByEstruturaTipo(EstruturaTipo estruturaTipo) {
        return this.getByEstruturaTipo(estruturaTipo, "");
    }

    public List<DicaSistema> getByEstruturaTipo(EstruturaTipo estruturaTipo, String module) {
        return this.dicaSistemaRepository.getByEstruturaTipoAndModule(estruturaTipo.getNome(), module);
    }

    public Page<DicaSistema> getAllFilterTitle(String title, Pageable pageable) {
        if (title.isEmpty()) {
            return this.dicaSistemaRepository.findAll(pageable);
        }
        return this.dicaSistemaRepository.findByTituloContains(title, pageable);
    }

    public long countAllFilterTitle(String title) {
        if (title.isEmpty()) {
            return this.dicaSistemaRepository.count();
        }
        return this.dicaSistemaRepository.countByTituloContains(title);
    }

    @Transactional
    public DicaSistema salvar(DicaSistema dica, InputStream is, Set<EstruturaTipoEnum> tipos) {
        if (dica.getDataPostagem() == null) {
            dica.setDataPostagem(LocalDate.now());
        }
        if (dica.getPadrao().booleanValue()) {
            for (EstruturaTipoEnum tipo : tipos) {
                this.dicaSistemaRepository.updatePadrao(tipo.name());
            }
        }
        if (dica.getHashImagem() == null || dica.getHashImagem().isEmpty()) {
            dica.setHashImagem(HashUtil.getUUI() + FileUtil.getExtension((String)dica.getNomeImagem()));
        }
        try {
            if (is.available() > 0) {
                StorageUtil.uploadObjectInputStream((String)dica.getHashImagem(), (InputStream)is);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet<String> lista = new HashSet<String>();
        for (EstruturaTipoEnum e : tipos) {
            lista.add(e.name());
        }
        dica.setListaTipoEstrutura(StringUtils.join(lista, (String)","));
        return (DicaSistema)this.dicaSistemaRepository.save((Object)dica);
    }

    public void delete(DicaSistema dica) {
        this.dicaSistemaRepository.delete((Object)dica);
    }
}

