/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.emoji;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.emoji.EmojiEnum;
import br.com.system.app.features.layout.UIUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import java.io.Serializable;

public class EmojiView
extends Dialog {
    private static final long serialVersionUID = 1L;
    private int page = 0;
    private final HorizontalContainer content = new HorizontalContainer(new Component[0]);
    private Button select;

    public String getSelectName() {
        return (String)this.select.getId().get();
    }

    public String getSelectValue() {
        if (this.select == null) {
            return "";
        }
        return this.select.getText();
    }

    public void show() {
        VerticalContainer main = new VerticalContainer(new Component[0]);
        main.setWidth("780px");
        this.setWidth("815px");
        Button bNext = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_CIRCLE_RIGHT, (String)"Pr\u00f3xima pagina");
        bNext.addClickListener((ComponentEventListener & Serializable)e -> {
            this.page = this.page >= 19 ? 19 : ++this.page;
            this.showEmojis();
        });
        Button bPrev = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_CIRCLE_LEFT, (String)"Pagina Anterior");
        bPrev.addClickListener((ComponentEventListener & Serializable)e -> {
            this.page = this.page <= 0 ? 0 : --this.page;
            this.showEmojis();
        });
        Button bClose = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.CLOSE_CIRCLE, (String)"Fechar");
        bClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        HorizontalContainer hButtons = new HorizontalContainer(new Component[]{bPrev, bClose, bNext});
        hButtons.setWidthFull();
        hButtons.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        main.add(new Component[]{this.content});
        this.showEmojis();
        this.add(new Component[]{main, hButtons});
        this.open();
    }

    private void showEmojis() {
        this.content.removeAll();
        EmojiEnum[] emojis = EmojiEnum.values();
        for (int i = this.page * 100; i <= this.page * 100 + 99; ++i) {
            Button b = UIUtils.createSmallButton((String)emojis[i].toString());
            b.setId(emojis[i].name());
            b.addClickListener((ComponentEventListener & Serializable)e -> {
                this.select = b;
                this.close();
            });
            this.content.add(new Component[]{b});
        }
    }
}

