/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.enriquecimento.service;

import br.com.system.app.features.datastone.service.DataStoneSolicitaService;
import br.com.system.app.features.enriquecimento.model.Enriquecimento;
import br.com.system.app.features.enriquecimento.model.EnriquecimentoItens;
import br.com.system.app.features.enriquecimento.repository.EnriquecimentoItensRepository;
import br.com.system.app.features.enriquecimento.repository.EnriquecimentoRepository;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.model.StatusProcessoEnum;
import br.com.system.app.features.shared.model.TipoProcessoEnum;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class EnriquecimentoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private EnriquecimentoRepository enriquecimentoRepository;
    @Autowired
    private EnriquecimentoItensRepository enriquecimentoItensRepository;
    @Autowired
    private DataStoneSolicitaService dataStoneConsultaService;
    @Autowired
    private UsuarioHierarquiaService usuarioHierarquiaService;

    public Enriquecimento save(Enriquecimento e) {
        return (Enriquecimento)this.enriquecimentoRepository.save((Object)e);
    }

    @Async(value="asyncDefault")
    public void processar(EstruturaUsuario eu, Set<String> cnpjs, String nome, TipoProcessoEnum tipo, boolean consultaWhats, boolean consultarSocios, boolean justConsult) {
        Enriquecimento enriquecimento = new Enriquecimento();
        try {
            enriquecimento.setDataHora(LocalDateTime.now());
            enriquecimento.setEstruturaUsuario(eu);
            enriquecimento.setNomeArquivo(nome);
            enriquecimento.setTotalRegistros(Integer.valueOf(cnpjs.size()));
            enriquecimento.setStatusAnalise(StatusProcessoEnum.NA_FILA);
            enriquecimento.setConsultaWhats(Boolean.valueOf(consultaWhats));
            enriquecimento.setConsultaSocios(Boolean.valueOf(consultarSocios));
            enriquecimento.setJustConsult(Boolean.valueOf(justConsult));
            enriquecimento = (Enriquecimento)this.enriquecimentoRepository.save((Object)enriquecimento);
            for (String cnpj : cnpjs) {
                try {
                    cnpj = tipo.equals((Object)TipoProcessoEnum.CNPJ) ? StringUtil.normalizeCnpj((String)cnpj) : StringUtil.normalizeCpf((String)cnpj);
                    if (TipoProcessoEnum.CNPJ.equals((Object)tipo) && !ValidationUtil.isValidCNPJ((String)cnpj) || TipoProcessoEnum.CPF.equals((Object)tipo) && !ValidationUtil.isValidCPF((String)cnpj)) continue;
                    EnriquecimentoItens ei = new EnriquecimentoItens();
                    ei.setEnriquecimento(enriquecimento);
                    ei.setCpfCnpj(cnpj);
                    ei.setCobrado(Boolean.FALSE);
                    this.enriquecimentoItensRepository.save((Object)ei);
                }
                catch (Exception ex) {
                    if (enriquecimento.getObservacao() == null) {
                        enriquecimento.setObservacao("CNPJ " + cnpj + " " + ex.getMessage() + "\n");
                        continue;
                    }
                    enriquecimento.setObservacao(enriquecimento.getObservacao() + "CNPJ " + cnpj + " " + ex.getMessage() + "\n");
                }
            }
            if (tipo.equals((Object)TipoProcessoEnum.CNPJ)) {
                enriquecimento.setDataStoneId(this.dataStoneConsultaService.solicitarCnpj(nome, cnpjs, consultarSocios));
            } else {
                enriquecimento.setDataStoneId(this.dataStoneConsultaService.solicitarCpf(nome, cnpjs));
            }
            enriquecimento = (Enriquecimento)this.enriquecimentoRepository.save((Object)enriquecimento);
        }
        catch (Exception e) {
            enriquecimento.setObservacao(e.getMessage());
            enriquecimento.setStatusAnalise(StatusProcessoEnum.FINALIZADO_COM_ERRO);
            this.enriquecimentoRepository.save((Object)enriquecimento);
        }
    }

    public List<Enriquecimento> getByStatus(StatusProcessoEnum status) {
        return this.enriquecimentoRepository.findByStatusAnalise(status);
    }

    public Enriquecimento getByDataStone(Integer dataStoneId) {
        return this.enriquecimentoRepository.findFirstByDataStoneId(dataStoneId);
    }

    public List<Enriquecimento> getByEstruturaUsuario(EstruturaUsuario eu, Pageable pageable) {
        Set hierarquia = this.usuarioHierarquiaService.getHierarquia(eu);
        return this.enriquecimentoRepository.findByEstruturaUsuarioIdInOrderByIdDesc(hierarquia, pageable);
    }

    public long countByEstruturaUsuario(EstruturaUsuario eu) {
        Set hierarquia = this.usuarioHierarquiaService.getHierarquia(eu);
        return this.enriquecimentoRepository.countByEstruturaUsuarioIdIn(hierarquia);
    }

    public List<EnriquecimentoItens> getItens(Enriquecimento enriquecimento) {
        return this.enriquecimentoItensRepository.findByEnriquecimento(enriquecimento);
    }

    public void delete(Enriquecimento enriquecimento) throws Exception {
        StorageUtil.deleteObject((String)enriquecimento.getUrlArquivo());
        this.enriquecimentoItensRepository.deleteByEnriquecimento(enriquecimento);
        this.enriquecimentoRepository.delete((Object)enriquecimento);
    }

    public Set<Enriquecimento> getByEstrutura(Estrutura estrutura) {
        return this.enriquecimentoRepository.getByEstruturaUsuarioEstrutura(estrutura);
    }
}

