/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.estrutura.model;

import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.usuario.model.Usuario;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;

@Entity
@Table(name="estrutura_usuario")
public class EstruturaUsuario
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    private Estrutura estrutura;
    @ManyToOne
    private Usuario usuario;
    @OneToOne
    private Equipe equipe;
    private boolean ativo = true;
    @NotNull
    private String rules;

    public String getNomeUsuarioAndLoginUsuarioAndNomeEquipe() {
        if (this.getEquipe() == null) {
            return this.getUsuario().getNome() + " " + this.getUsuario().getLogin() + " (Sem equipe)";
        }
        return this.getUsuario().getNome() + " " + this.getUsuario().getLogin() + " (" + this.getEquipe().getNome() + ")";
    }

    public boolean haveRole(String role) {
        String[] rawUserRules;
        for (String rule : rawUserRules = this.getRules().split(",")) {
            try {
                if (!role.toUpperCase().equals(rule)) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public EstruturaUsuario() {
    }

    public EstruturaUsuario(Long id, Estrutura estrutura, Usuario usuario) {
        this.id = id;
        this.estrutura = estrutura;
        this.usuario = usuario;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Estrutura getEstrutura() {
        return this.estrutura;
    }

    public void setEstrutura(Estrutura estrutura) {
        this.estrutura = estrutura;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public Equipe getEquipe() {
        return this.equipe;
    }

    public void setEquipe(Equipe equipe) {
        this.equipe = equipe;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    public String getRules() {
        if (this.rules == null) {
            this.rules = "";
        }
        return this.rules;
    }

    public void setRules(String rules) {
        this.rules = rules;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EstruturaUsuario other = (EstruturaUsuario)obj;
        return Objects.equals(this.id, other.id);
    }
}

