/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.kanbanpedidos;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.kanbanpedidos.model.KanbanListenerDTO;
import br.com.system.app.features.kanbanpedidos.model.KanbanPedidos;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.TextAlign;
import br.com.system.app.features.pedido.model.PedidoEtapa;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.H6;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;

public class KanbanColunaView
extends VerticalContainer {
    private static final long serialVersionUID = 1L;
    private final H6 label;
    private final Span textoInicial = new Span("carregando...");
    private final Button btnAuto;
    private final Button btnNext;
    private final Button btnPrev;
    private final Button btnCount;
    private final KanbanPedidos kp;
    private VerticalContainer kpContainer;
    private KanbanListenerDTO dto;
    private PedidoEtapa pedidoEtapa;

    public Button getBtnCount() {
        return this.btnCount;
    }

    public Button getBtnNext() {
        return this.btnNext;
    }

    public Button getBtnPrev() {
        return this.btnPrev;
    }

    public Span getTextoInicial() {
        return this.textoInicial;
    }

    public KanbanListenerDTO getDto() {
        return this.dto;
    }

    public void setDto(KanbanListenerDTO dto) {
        this.dto = dto;
    }

    public KanbanPedidos getKp() {
        return this.kp;
    }

    public PedidoEtapa getPedidoEtapa() {
        return this.pedidoEtapa;
    }

    public void setPedidoEtapa(PedidoEtapa pedidoEtapa) {
        this.pedidoEtapa = pedidoEtapa;
    }

    public KanbanColunaView(KanbanPedidos kp) {
        super(new Component[0]);
        this.setWidth("335px");
        this.kp = kp;
        this.label = new H6(kp.getPedidoEtapa().getNome());
        this.label.setWidthFull();
        this.btnAuto = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.AUTOMATION, (String)"Tratar a lista na sequencia");
        this.btnPrev = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_LEFT, (String)"P\u00e1gina Anterior");
        this.btnPrev.setDisableOnClick(true);
        this.btnNext = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ARROW_RIGHT, (String)"Pr\u00f3xima pagina");
        this.btnNext.setDisableOnClick(true);
        this.btnCount = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.ABACUS, (String)"Contar atividades");
        UIUtils.setTextAlign((TextAlign)TextAlign.CENTER, (Component[])new Component[]{this.label});
        HorizontalContainer cabecalho = new HorizontalContainer(new Component[]{this.label, this.btnAuto, this.btnPrev, this.btnNext, this.btnCount}).setSpacingOff().setPaddingOff().setNoWrap().setHorizontalFull();
        cabecalho.getElement().getStyle().set("background-color", Color.GAINSBORO.getValue());
        this.add(new Component[]{cabecalho});
    }

    public Button getBtnAuto() {
        return this.btnAuto;
    }

    public VerticalContainer getContainer() {
        return this.kpContainer;
    }

    public VerticalContainer create() {
        this.kpContainer = new VerticalContainer(new Component[0]).setSpacingOn();
        this.kpContainer.setJustifyContentMode(FlexComponent.JustifyContentMode.START);
        this.kpContainer.setAlignItems(FlexComponent.Alignment.CENTER);
        this.kpContainer.setWidth("320px");
        this.kpContainer.setHeight("600px");
        if (this.kp.getBackgroundColor() != null && this.kp.getBackgroundColor().isEmpty()) {
            this.kpContainer.getStyle().set("background-color", this.kp.getBackgroundColor());
        }
        this.kpContainer.setDataObject((Object)this.kp);
        this.kpContainer.setId("kpContainer");
        this.kpContainer.getStyle().set("overflow-x", "hidden");
        this.add(new Component[]{this.textoInicial});
        this.add(new Component[]{this.kpContainer});
        return this.kpContainer;
    }

    public void removeCard(VerticalContainer card) {
        this.kpContainer.remove(new Component[]{card});
    }

    public void setTextoInicial() {
        this.setTextoInicial("carregando...");
    }

    public void setTextoInicial(String texto) {
        this.textoInicial.setText(texto);
    }

    public void addCardPosition(VerticalContainer card, boolean asFist) {
        Long count = this.kpContainer.getChildren().count();
        if (asFist) {
            this.kpContainer.addComponentAtIndex(count.intValue() - 1, (Component)card);
        } else {
            this.kpContainer.add(new Component[]{card});
        }
    }

    public void addCard(VerticalContainer card, boolean asFirst) {
        if (asFirst) {
            this.kpContainer.addComponentAsFirst((Component)card);
        } else {
            this.kpContainer.add(new Component[]{card});
        }
    }

    public void clearColumn() {
        this.kpContainer.removeAll();
    }

    public void setLabel(Integer qt) {
        this.label.setText(this.kp.getPedidoEtapa().getNome() + " (" + qt + ")");
    }
}

